/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;
import java.util.List;

public class DependencyNode
implements Dependency {
    public Dependency updateDelegate = null;
    public boolean delegateToWidgetRun = false;
    public boolean readyToSolve = false;
    WidgetRun run;
    Type type = Type.UNKNOWN;
    int margin;
    public int value;
    int marginFactor = 1;
    DimensionDependency marginDependency = null;
    public boolean resolved = false;
    List<Dependency> dependencies = new ArrayList<Dependency>();
    List<DependencyNode> targets = new ArrayList<DependencyNode>();

    public DependencyNode(WidgetRun run) {
        this.run = run;
    }

    public String toString() {
        return this.run.widget.getDebugName() + ":" + (Object)((Object)this.type) + "(" + (this.resolved ? Integer.valueOf(this.value) : "unresolved") + ") <t=" + this.targets.size() + ":d=" + this.dependencies.size() + ">";
    }

    public void resolve(int value) {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        this.value = value;
        for (Dependency node : this.dependencies) {
            node.update(node);
        }
    }

    @Override
    public void update(Dependency node) {
        for (DependencyNode target : this.targets) {
            if (target.resolved) continue;
            return;
        }
        this.readyToSolve = true;
        if (this.updateDelegate != null) {
            this.updateDelegate.update(this);
        }
        if (this.delegateToWidgetRun) {
            this.run.update(this);
            return;
        }
        DependencyNode target = null;
        int numTargets = 0;
        for (DependencyNode t : this.targets) {
            if (t instanceof DimensionDependency) continue;
            target = t;
            ++numTargets;
        }
        if (target != null && numTargets == 1 && target.resolved) {
            if (this.marginDependency != null) {
                if (this.marginDependency.resolved) {
                    this.margin = this.marginFactor * this.marginDependency.value;
                } else {
                    return;
                }
            }
            this.resolve(target.value + this.margin);
        }
        if (this.updateDelegate != null) {
            this.updateDelegate.update(this);
        }
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
        if (this.resolved) {
            dependency.update(dependency);
        }
    }

    public String name() {
        String definition = this.run.widget.getDebugName();
        definition = this.type == Type.LEFT || this.type == Type.RIGHT ? definition + "_HORIZONTAL" : definition + "_VERTICAL";
        definition = definition + ":" + this.type.name();
        return definition;
    }

    public void clear() {
        this.targets.clear();
        this.dependencies.clear();
        this.resolved = false;
        this.value = 0;
        this.readyToSolve = false;
        this.delegateToWidgetRun = false;
    }

    static enum Type {
        UNKNOWN,
        HORIZONTAL_DIMENSION,
        VERTICAL_DIMENSION,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        BASELINE;

    }
}

