/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.contentcapture;

import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.LongSparseArray;
import android.view.View;
import android.view.autofill.AutofillId;
import android.view.translation.TranslationRequestValue;
import android.view.translation.ViewTranslationRequest;
import android.view.translation.ViewTranslationResponse;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArraySet;
import androidx.collection.IntObjectMap;
import androidx.collection.IntObjectMapKt;
import androidx.collection.IntSet;
import androidx.collection.MutableIntObjectMap;
import androidx.collection.MutableIntSet;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.contentcapture.AndroidContentCaptureManager;
import androidx.compose.ui.contentcapture.ContentCaptureManager;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.platform.AndroidComposeView;
import androidx.compose.ui.platform.SemanticsNodeCopy;
import androidx.compose.ui.platform.SemanticsNodeWithAdjustedBounds;
import androidx.compose.ui.platform.SemanticsUtils_androidKt;
import androidx.compose.ui.platform.coreshims.AutofillIdCompat;
import androidx.compose.ui.platform.coreshims.ContentCaptureSessionCompat;
import androidx.compose.ui.platform.coreshims.ViewCompatShims;
import androidx.compose.ui.platform.coreshims.ViewStructureCompat;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.util.ListUtilsKt;
import androidx.core.util.LongSparseArrayKt;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0002~\u007fB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010>\u001a\u00020\u000eH\u0080@\u00a2\u0006\u0004\b?\u0010@J\u001a\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010E\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020CH\u0002J\u0016\u0010F\u001a\u00020\u000e2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\b\u0010H\u001a\u00020\u000eH\u0002J\b\u0010I\u001a\u00020\u000eH\u0002J\b\u0010J\u001a\u00020\u000eH\u0002J\u0010\u0010K\u001a\u00020\u000e2\u0006\u0010L\u001a\u000209H\u0002J\r\u0010M\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\bNJ-\u0010O\u001a\u00020\u000e2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u000e\u0010T\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010V0UH\u0001\u00a2\u0006\u0002\bWJ\r\u0010X\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\bYJ\u0015\u0010Z\u001a\u00020\u000e2\u0006\u0010L\u001a\u000209H\u0000\u00a2\u0006\u0002\b[J\r\u0010\\\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b]J\r\u0010^\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b_J\u0010\u0010`\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020bH\u0016J\u0010\u0010c\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020bH\u0016J\u0010\u0010d\u001a\u00020\u000e2\u0006\u0010e\u001a\u00020fH\u0016J\u0010\u0010g\u001a\u00020\u000e2\u0006\u0010e\u001a\u00020fH\u0016J%\u0010h\u001a\u00020\u000e2\u0006\u0010i\u001a\u00020\u00002\u000e\u0010j\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010l0kH\u0001\u00a2\u0006\u0002\bmJ\u0018\u0010n\u001a\u00020\u000e2\u0006\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u000205H\u0002J\u0018\u0010r\u001a\u00020\u000e2\u0006\u0010s\u001a\u00020C2\u0006\u0010t\u001a\u00020uH\u0002J\u0018\u0010v\u001a\u00020\u000e2\u0006\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u000205H\u0002J\b\u0010w\u001a\u00020\u000eH\u0002J\u0010\u0010x\u001a\u00020\u000e2\u0006\u0010y\u001a\u00020pH\u0002J\u0010\u0010z\u001a\u00020\u000e2\u0006\u0010y\u001a\u00020pH\u0002J\b\u0010{\u001a\u00020\u000eH\u0002J\u0010\u0010|\u001a\u00020\u000e2\u0006\u0010y\u001a\u00020pH\u0002J\u000e\u0010}\u001a\u0004\u0018\u00010\u0011*\u00020pH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0018\u001a\u0004\u0018\u00010\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020)X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u00158@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b-\u0010\u001a\u001a\u0004\b.\u0010/R\"\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0014\u00104\u001a\b\u0012\u0004\u0012\u0002050\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020908X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=\u00a8\u0006\u0080\u0001"}, d2={"Landroidx/compose/ui/contentcapture/AndroidContentCaptureManager;", "Landroidx/compose/ui/contentcapture/ContentCaptureManager;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "Landroid/view/View$OnAttachStateChangeListener;", "view", "Landroidx/compose/ui/platform/AndroidComposeView;", "onContentCaptureSession", "Lkotlin/Function0;", "Landroidx/compose/ui/platform/coreshims/ContentCaptureSessionCompat;", "(Landroidx/compose/ui/platform/AndroidComposeView;Lkotlin/jvm/functions/Function0;)V", "SendRecurringContentCaptureEventsIntervalMillis", "", "boundsUpdateChannel", "Lkotlinx/coroutines/channels/Channel;", "", "bufferedAppearedNodes", "Landroidx/collection/MutableIntObjectMap;", "Landroidx/compose/ui/platform/coreshims/ViewStructureCompat;", "bufferedDisappearedNodes", "Landroidx/collection/MutableIntSet;", "checkingForSemanticsChanges", "", "contentCaptureChangeChecker", "Ljava/lang/Runnable;", "contentCaptureSession", "getContentCaptureSession$ui_release$annotations", "()V", "getContentCaptureSession$ui_release", "()Landroidx/compose/ui/platform/coreshims/ContentCaptureSessionCompat;", "setContentCaptureSession$ui_release", "(Landroidx/compose/ui/platform/coreshims/ContentCaptureSessionCompat;)V", "currentSemanticsNodes", "Landroidx/collection/IntObjectMap;", "Landroidx/compose/ui/platform/SemanticsNodeWithAdjustedBounds;", "getCurrentSemanticsNodes$ui_release", "()Landroidx/collection/IntObjectMap;", "setCurrentSemanticsNodes$ui_release", "(Landroidx/collection/IntObjectMap;)V", "currentSemanticsNodesInvalidated", "currentSemanticsNodesSnapshotTimestampMillis", "handler", "Landroid/os/Handler;", "getHandler$ui_release", "()Landroid/os/Handler;", "isEnabled", "isEnabled$ui_release$annotations", "isEnabled$ui_release", "()Z", "getOnContentCaptureSession", "()Lkotlin/jvm/functions/Function0;", "setOnContentCaptureSession", "(Lkotlin/jvm/functions/Function0;)V", "previousSemanticsNodes", "Landroidx/compose/ui/platform/SemanticsNodeCopy;", "previousSemanticsRoot", "subtreeChangedLayoutNodes", "Landroidx/collection/ArraySet;", "Landroidx/compose/ui/node/LayoutNode;", "translateStatus", "Landroidx/compose/ui/contentcapture/AndroidContentCaptureManager$TranslateStatus;", "getView", "()Landroidx/compose/ui/platform/AndroidComposeView;", "boundsUpdatesEventLoop", "boundsUpdatesEventLoop$ui_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "bufferContentCaptureViewAppeared", "virtualId", "", "viewStructure", "bufferContentCaptureViewDisappeared", "checkForContentCapturePropertyChanges", "newSemanticsNodes", "clearTranslatedText", "hideTranslatedText", "notifyContentCaptureChanges", "notifySubtreeStateChangeIfNeeded", "layoutNode", "onClearTranslation", "onClearTranslation$ui_release", "onCreateVirtualViewTranslationRequests", "virtualIds", "", "supportedFormats", "", "requestsCollector", "Ljava/util/function/Consumer;", "Landroid/view/translation/ViewTranslationRequest;", "onCreateVirtualViewTranslationRequests$ui_release", "onHideTranslation", "onHideTranslation$ui_release", "onLayoutChange", "onLayoutChange$ui_release", "onSemanticsChange", "onSemanticsChange$ui_release", "onShowTranslation", "onShowTranslation$ui_release", "onStart", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onStop", "onViewAttachedToWindow", "v", "Landroid/view/View;", "onViewDetachedFromWindow", "onVirtualViewTranslationResponses", "contentCaptureManager", "response", "Landroid/util/LongSparseArray;", "Landroid/view/translation/ViewTranslationResponse;", "onVirtualViewTranslationResponses$ui_release", "sendContentCaptureStructureChangeEvents", "newNode", "Landroidx/compose/ui/semantics/SemanticsNode;", "oldNode", "sendContentCaptureTextUpdateEvent", "id", "newText", "", "sendSemanticsStructureChangeEvents", "showTranslatedText", "updateBuffersOnAppeared", "node", "updateBuffersOnDisappeared", "updateSemanticsCopy", "updateTranslationOnAppeared", "toViewStructure", "TranslateStatus", "ViewTranslationHelperMethods", "ui_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAndroidContentCaptureManager.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidContentCaptureManager.android.kt\nandroidx/compose/ui/contentcapture/AndroidContentCaptureManager\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 IntSet.kt\nandroidx/collection/IntSet\n+ 4 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n+ 6 IntObjectMap.kt\nandroidx/collection/IntObjectMap\n*L\n1#1,650:1\n33#2,6:651\n33#2,4:684\n38#2:697\n33#2,6:698\n33#2,4:729\n38#2:742\n151#2,3:837\n33#2,4:840\n154#2,2:844\n38#2:846\n156#2:847\n151#2,3:875\n33#2,4:878\n154#2,2:882\n38#2:884\n156#2:885\n33#2,6:886\n33#2,6:892\n262#3,4:657\n232#3,7:661\n243#3,3:669\n246#3,2:673\n266#3,2:675\n249#3,6:677\n268#3:683\n262#3,4:848\n232#3,7:852\n243#3,3:860\n246#3,2:864\n266#3,2:866\n249#3,6:868\n268#3:874\n1810#4:668\n1672#4:672\n1810#4:713\n1672#4:717\n1810#4:752\n1672#4:756\n1810#4:796\n1672#4:800\n1810#4:821\n1672#4:825\n1810#4:859\n1672#4:863\n1810#4:907\n1672#4:911\n1810#4:932\n1672#4:936\n1810#4:957\n1672#4:961\n66#5,9:688\n66#5,9:733\n66#5,9:760\n66#5,9:777\n396#6,3:704\n354#6,6:707\n364#6,3:714\n367#6,2:718\n399#6,2:720\n370#6,6:722\n401#6:728\n396#6,3:743\n354#6,6:746\n364#6,3:753\n367#6,2:757\n399#6:759\n400#6:769\n370#6,6:770\n401#6:776\n382#6,4:786\n354#6,6:790\n364#6,3:797\n367#6,2:801\n387#6,2:803\n370#6,6:805\n389#6:811\n408#6,3:812\n354#6,6:815\n364#6,3:822\n367#6,2:826\n412#6,2:828\n370#6,6:830\n414#6:836\n408#6,3:898\n354#6,6:901\n364#6,3:908\n367#6,2:912\n412#6,2:914\n370#6,6:916\n414#6:922\n408#6,3:923\n354#6,6:926\n364#6,3:933\n367#6,2:937\n412#6,2:939\n370#6,6:941\n414#6:947\n408#6,3:948\n354#6,6:951\n364#6,3:958\n367#6,2:962\n412#6,2:964\n370#6,6:966\n414#6:972\n*S KotlinDebug\n*F\n+ 1 AndroidContentCaptureManager.android.kt\nandroidx/compose/ui/contentcapture/AndroidContentCaptureManager\n*L\n235#1:651,6\n253#1:684,4\n253#1:697\n268#1:698,6\n281#1:729,4\n281#1:742\n458#1:837,3\n458#1:840,4\n458#1:844,2\n458#1:846\n458#1:847\n466#1:875,3\n466#1:878,4\n466#1:882,2\n466#1:884\n466#1:885\n480#1:886,6\n488#1:892,6\n246#1:657,4\n246#1:661,7\n246#1:669,3\n246#1:673,2\n246#1:675,2\n246#1:677,6\n246#1:683\n464#1:848,4\n464#1:852,7\n464#1:860,3\n464#1:864,2\n464#1:866,2\n464#1:868,6\n464#1:874\n246#1:668\n246#1:672\n275#1:713\n275#1:717\n296#1:752\n296#1:756\n345#1:796\n345#1:800\n456#1:821\n456#1:825\n464#1:859\n464#1:863\n526#1:907\n526#1:911\n537#1:932\n537#1:936\n548#1:957\n548#1:961\n255#1:688,9\n284#1:733,9\n300#1:760,9\n338#1:777,9\n275#1:704,3\n275#1:707,6\n275#1:714,3\n275#1:718,2\n275#1:720,2\n275#1:722,6\n275#1:728\n296#1:743,3\n296#1:746,6\n296#1:753,3\n296#1:757,2\n296#1:759\n296#1:769\n296#1:770,6\n296#1:776\n345#1:786,4\n345#1:790,6\n345#1:797,3\n345#1:801,2\n345#1:803,2\n345#1:805,6\n345#1:811\n456#1:812,3\n456#1:815,6\n456#1:822,3\n456#1:826,2\n456#1:828,2\n456#1:830,6\n456#1:836\n526#1:898,3\n526#1:901,6\n526#1:908,3\n526#1:912,2\n526#1:914,2\n526#1:916,6\n526#1:922\n537#1:923,3\n537#1:926,6\n537#1:933,3\n537#1:937,2\n537#1:939,2\n537#1:941,6\n537#1:947\n548#1:948,3\n548#1:951,6\n548#1:958,3\n548#1:962,2\n548#1:964,2\n548#1:966,6\n548#1:972\n*E\n"})
public final class AndroidContentCaptureManager
implements ContentCaptureManager,
DefaultLifecycleObserver,
View.OnAttachStateChangeListener {
    @NotNull
    private final AndroidComposeView view;
    @NotNull
    private Function0<? extends ContentCaptureSessionCompat> onContentCaptureSession;
    @Nullable
    private ContentCaptureSessionCompat contentCaptureSession;
    @NotNull
    private final MutableIntObjectMap<ViewStructureCompat> bufferedAppearedNodes;
    @NotNull
    private final MutableIntSet bufferedDisappearedNodes;
    private long SendRecurringContentCaptureEventsIntervalMillis;
    @NotNull
    private TranslateStatus translateStatus;
    private boolean currentSemanticsNodesInvalidated;
    @NotNull
    private final ArraySet<LayoutNode> subtreeChangedLayoutNodes;
    @NotNull
    private final Channel<Unit> boundsUpdateChannel;
    @NotNull
    private final Handler handler;
    @NotNull
    private IntObjectMap<SemanticsNodeWithAdjustedBounds> currentSemanticsNodes;
    private long currentSemanticsNodesSnapshotTimestampMillis;
    @NotNull
    private MutableIntObjectMap<SemanticsNodeCopy> previousSemanticsNodes;
    @NotNull
    private SemanticsNodeCopy previousSemanticsRoot;
    private boolean checkingForSemanticsChanges;
    @NotNull
    private final Runnable contentCaptureChangeChecker;
    public static final int $stable = 8;

    public AndroidContentCaptureManager(@NotNull AndroidComposeView view, @NotNull Function0<? extends ContentCaptureSessionCompat> onContentCaptureSession) {
        this.view = view;
        this.onContentCaptureSession = onContentCaptureSession;
        this.bufferedAppearedNodes = new MutableIntObjectMap(0, 1, null);
        this.bufferedDisappearedNodes = new MutableIntSet(0, 1, null);
        this.SendRecurringContentCaptureEventsIntervalMillis = 100L;
        this.translateStatus = TranslateStatus.SHOW_ORIGINAL;
        this.currentSemanticsNodesInvalidated = true;
        this.subtreeChangedLayoutNodes = new ArraySet(0, 1, null);
        this.boundsUpdateChannel = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
        this.handler = new Handler(Looper.getMainLooper());
        this.currentSemanticsNodes = IntObjectMapKt.intObjectMapOf();
        this.previousSemanticsNodes = IntObjectMapKt.mutableIntObjectMapOf();
        this.previousSemanticsRoot = new SemanticsNodeCopy(this.view.getSemanticsOwner().getUnmergedRootSemanticsNode(), (IntObjectMap<SemanticsNodeWithAdjustedBounds>)IntObjectMapKt.intObjectMapOf());
        this.contentCaptureChangeChecker = () -> AndroidContentCaptureManager.contentCaptureChangeChecker$lambda$0(this);
    }

    @NotNull
    public final AndroidComposeView getView() {
        return this.view;
    }

    @NotNull
    public final Function0<ContentCaptureSessionCompat> getOnContentCaptureSession() {
        return this.onContentCaptureSession;
    }

    public final void setOnContentCaptureSession(@NotNull Function0<? extends ContentCaptureSessionCompat> function0) {
        this.onContentCaptureSession = function0;
    }

    @Nullable
    public final ContentCaptureSessionCompat getContentCaptureSession$ui_release() {
        return this.contentCaptureSession;
    }

    public final void setContentCaptureSession$ui_release(@Nullable ContentCaptureSessionCompat contentCaptureSessionCompat) {
        this.contentCaptureSession = contentCaptureSessionCompat;
    }

    @VisibleForTesting
    public static /* synthetic */ void getContentCaptureSession$ui_release$annotations() {
    }

    @NotNull
    public final Handler getHandler$ui_release() {
        return this.handler;
    }

    @NotNull
    public final IntObjectMap<SemanticsNodeWithAdjustedBounds> getCurrentSemanticsNodes$ui_release() {
        if (this.currentSemanticsNodesInvalidated) {
            this.currentSemanticsNodesInvalidated = false;
            this.currentSemanticsNodes = SemanticsUtils_androidKt.getAllUncoveredSemanticsNodesToIntObjectMap(this.view.getSemanticsOwner());
            this.currentSemanticsNodesSnapshotTimestampMillis = System.currentTimeMillis();
        }
        return this.currentSemanticsNodes;
    }

    public final void setCurrentSemanticsNodes$ui_release(@NotNull IntObjectMap<SemanticsNodeWithAdjustedBounds> intObjectMap) {
        this.currentSemanticsNodes = intObjectMap;
    }

    public void onViewAttachedToWindow(@NotNull View v) {
    }

    public void onViewDetachedFromWindow(@NotNull View v) {
        this.handler.removeCallbacks(this.contentCaptureChangeChecker);
        this.contentCaptureSession = null;
    }

    public final boolean isEnabled$ui_release() {
        return ContentCaptureManager.Companion.isEnabled() && this.contentCaptureSession != null;
    }

    public static /* synthetic */ void isEnabled$ui_release$annotations() {
    }

    public void onStart(@NotNull LifecycleOwner owner) {
        this.contentCaptureSession = (ContentCaptureSessionCompat)this.onContentCaptureSession.invoke();
        this.updateBuffersOnAppeared(this.view.getSemanticsOwner().getUnmergedRootSemanticsNode());
        this.notifyContentCaptureChanges();
    }

    public void onStop(@NotNull LifecycleOwner owner) {
        this.updateBuffersOnDisappeared(this.view.getSemanticsOwner().getUnmergedRootSemanticsNode());
        this.notifyContentCaptureChanges();
        this.contentCaptureSession = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Object boundsUpdatesEventLoop$ui_release(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof boundsUpdatesEventLoop.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AndroidContentCaptureManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.boundsUpdatesEventLoop$ui_release((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    var2_5 = this.boundsUpdateChannel.iterator();
                }
                catch (Throwable var2_6) {
                    this.subtreeChangedLayoutNodes.clear();
                    throw var2_6;
                }
lbl19:
                // 3 sources

                while (true) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = var2_5;
                    $continuation.label = 1;
                    v0 = var2_5.hasNext((Continuation)$continuation);
                    if (v0 == var5_4) {
                        return var5_4;
                    }
                    ** GOTO lbl33
                    break;
                }
            }
            case 1: {
                var2_5 = (ChannelIterator)$continuation.L$1;
                this = (AndroidContentCaptureManager)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    if (!((Boolean)v0).booleanValue()) break;
                    var2_5.next();
                    if (this.isEnabled$ui_release()) {
                        this.notifyContentCaptureChanges();
                    }
                    if (!this.checkingForSemanticsChanges) {
                        this.checkingForSemanticsChanges = true;
                        this.handler.post(this.contentCaptureChangeChecker);
                    }
                    this.subtreeChangedLayoutNodes.clear();
                    $continuation.L$0 = this;
                    $continuation.L$1 = var2_5;
                    $continuation.label = 2;
                    v1 = DelayKt.delay((long)this.SendRecurringContentCaptureEventsIntervalMillis, (Continuation)$continuation);
                    if (v1 != var5_4) ** GOTO lbl19
                }
                return var5_4;
            }
            case 2: {
                var2_5 = (ChannelIterator)$continuation.L$1;
                this = (AndroidContentCaptureManager)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    ** continue;
                }
            }
        }
        this.subtreeChangedLayoutNodes.clear();
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void onSemanticsChange$ui_release() {
        this.currentSemanticsNodesInvalidated = true;
        if (this.isEnabled$ui_release() && !this.checkingForSemanticsChanges) {
            this.checkingForSemanticsChanges = true;
            this.handler.post(this.contentCaptureChangeChecker);
        }
    }

    public final void onLayoutChange$ui_release(@NotNull LayoutNode layoutNode2) {
        this.currentSemanticsNodesInvalidated = true;
        if (this.isEnabled$ui_release()) {
            this.notifySubtreeStateChangeIfNeeded(layoutNode2);
        }
    }

    private final void sendSemanticsStructureChangeEvents(SemanticsNode newNode, SemanticsNodeCopy oldNode) {
        SemanticsNode child;
        MutableIntSet newChildren = new MutableIntSet(0, 1, null);
        List<SemanticsNode> $this$fastForEach$iv = newNode.getReplacedChildren$ui_release();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            SemanticsNode item$iv;
            child = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            if (!this.getCurrentSemanticsNodes$ui_release().contains(child.getId())) continue;
            if (!oldNode.getChildren().contains(child.getId())) {
                this.notifySubtreeStateChangeIfNeeded(newNode.getLayoutNode$ui_release());
                return;
            }
            newChildren.add(child.getId());
        }
        IntSet this_$iv = (IntSet)oldNode.getChildren();
        boolean $i$f$forEach = false;
        int[] k$iv = this_$iv.elements;
        IntSet this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndex = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            int child2 = k$iv[index$iv];
                            boolean bl2 = false;
                            if (!newChildren.contains(child2)) {
                                this.notifySubtreeStateChangeIfNeeded(newNode.getLayoutNode$ui_release());
                                return;
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        $this$fastForEach$iv = newNode.getReplacedChildren$ui_release();
        $i$f$fastForEach = false;
        int n2 = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n2; ++index$iv) {
            SemanticsNode item$iv;
            child = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            if (!this.getCurrentSemanticsNodes$ui_release().contains(child.getId())) continue;
            Object value$iv = this.previousSemanticsNodes.get(child.getId());
            boolean $i$f$checkPreconditionNotNull = false;
            if (value$iv == null) {
                boolean bl3 = false;
                InlineClassHelperKt.throwIllegalStateExceptionForNullCheck("node not present in pruned tree before this change");
                throw new KotlinNothingValueException();
            }
            SemanticsNodeCopy prevNode = (SemanticsNodeCopy)value$iv;
            this.sendSemanticsStructureChangeEvents(child, prevNode);
        }
    }

    private final void sendContentCaptureStructureChangeEvents(SemanticsNode newNode, SemanticsNodeCopy oldNode) {
        SemanticsNode child;
        List<SemanticsNode> $this$fastForEach$iv = newNode.getReplacedChildren$ui_release();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            SemanticsNode item$iv;
            child = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            if (!this.getCurrentSemanticsNodes$ui_release().contains(child.getId()) || oldNode.getChildren().contains(child.getId())) continue;
            this.updateBuffersOnAppeared(child);
        }
        IntObjectMap this_$iv = (IntObjectMap)this.previousSemanticsNodes;
        boolean $i$f$forEachKey = false;
        int[] k$iv = this_$iv.keys;
        IntObjectMap this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            int key = k$iv[index$iv];
                            boolean bl2 = false;
                            if (!this.getCurrentSemanticsNodes$ui_release().contains(key)) {
                                this.bufferContentCaptureViewDisappeared(key);
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        $this$fastForEach$iv = newNode.getReplacedChildren$ui_release();
        $i$f$fastForEach = false;
        int n2 = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n2; ++index$iv) {
            SemanticsNode item$iv;
            child = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            if (!this.getCurrentSemanticsNodes$ui_release().contains(child.getId()) || !this.previousSemanticsNodes.contains(child.getId())) continue;
            Object value$iv = this.previousSemanticsNodes.get(child.getId());
            boolean $i$f$checkPreconditionNotNull = false;
            if (value$iv == null) {
                boolean bl3 = false;
                InlineClassHelperKt.throwIllegalStateExceptionForNullCheck("node not present in pruned tree before this change");
                throw new KotlinNothingValueException();
            }
            SemanticsNodeCopy prevNodeCopy = (SemanticsNodeCopy)value$iv;
            this.sendContentCaptureStructureChangeEvents(child, prevNodeCopy);
        }
    }

    private final void checkForContentCapturePropertyChanges(IntObjectMap<SemanticsNodeWithAdjustedBounds> newSemanticsNodes) {
        IntObjectMap<SemanticsNodeWithAdjustedBounds> this_$iv = newSemanticsNodes;
        boolean $i$f$forEachKey = false;
        int[] k$iv = this_$iv.keys;
        IntObjectMap<SemanticsNodeWithAdjustedBounds> this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            int id2 = k$iv[index$iv];
                            boolean bl2 = false;
                            SemanticsNodeCopy oldNode = (SemanticsNodeCopy)this.previousSemanticsNodes.get(id2);
                            SemanticsNodeWithAdjustedBounds semanticsNodeWithAdjustedBounds = (SemanticsNodeWithAdjustedBounds)newSemanticsNodes.get(id2);
                            SemanticsNode value$iv = semanticsNodeWithAdjustedBounds != null ? semanticsNodeWithAdjustedBounds.getSemanticsNode() : null;
                            boolean $i$f$checkPreconditionNotNull = false;
                            if (value$iv == null) {
                                boolean bl3 = false;
                                InlineClassHelperKt.throwIllegalStateExceptionForNullCheck("no value for specified key");
                                throw new KotlinNothingValueException();
                            }
                            SemanticsNode newNode = value$iv;
                            if (oldNode == null) {
                                for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : newNode.getUnmergedConfig$ui_release()) {
                                    if (!Intrinsics.areEqual(entry.getKey(), SemanticsProperties.INSTANCE.getText())) continue;
                                    List<AnnotatedString> list = SemanticsConfigurationKt.getOrNull(newNode.getUnmergedConfig$ui_release(), SemanticsProperties.INSTANCE.getText());
                                    AnnotatedString newText = list != null ? (AnnotatedString)CollectionsKt.firstOrNull(list) : null;
                                    this.sendContentCaptureTextUpdateEvent(newNode.getId(), String.valueOf(newText));
                                }
                            } else {
                                for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : newNode.getUnmergedConfig$ui_release()) {
                                    List<AnnotatedString> list;
                                    AnnotatedString newText;
                                    List<AnnotatedString> list2;
                                    AnnotatedString oldText;
                                    if (!Intrinsics.areEqual(entry.getKey(), SemanticsProperties.INSTANCE.getText()) || Intrinsics.areEqual((Object)(oldText = (list2 = SemanticsConfigurationKt.getOrNull(oldNode.getUnmergedConfig(), SemanticsProperties.INSTANCE.getText())) != null ? (AnnotatedString)CollectionsKt.firstOrNull(list2) : null), (Object)(newText = (list = SemanticsConfigurationKt.getOrNull(newNode.getUnmergedConfig$ui_release(), SemanticsProperties.INSTANCE.getText())) != null ? (AnnotatedString)CollectionsKt.firstOrNull(list) : null))) continue;
                                    this.sendContentCaptureTextUpdateEvent(newNode.getId(), String.valueOf(newText));
                                }
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
    }

    private final void sendContentCaptureTextUpdateEvent(int id2, String newText) {
        if (Build.VERSION.SDK_INT < 29) {
            return;
        }
        ContentCaptureSessionCompat contentCaptureSessionCompat = this.contentCaptureSession;
        if (contentCaptureSessionCompat == null) {
            return;
        }
        ContentCaptureSessionCompat session = contentCaptureSessionCompat;
        AutofillId autofillId = session.newAutofillId(id2);
        boolean $i$f$checkPreconditionNotNull = false;
        if (autofillId == null) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateExceptionForNullCheck("Invalid content capture ID");
            throw new KotlinNothingValueException();
        }
        session.notifyViewTextChanged(autofillId, newText);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSemanticsCopy() {
        this.previousSemanticsNodes.clear();
        IntObjectMap<SemanticsNodeWithAdjustedBounds> this_$iv = this.getCurrentSemanticsNodes$ui_release();
        boolean $i$f$forEach = false;
        int[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        IntObjectMap<SemanticsNodeWithAdjustedBounds> this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void value;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            SemanticsNodeWithAdjustedBounds semanticsNodeWithAdjustedBounds = (SemanticsNodeWithAdjustedBounds)v$iv[index$iv];
                            int key = k$iv[index$iv];
                            boolean bl2 = false;
                            this.previousSemanticsNodes.set(key, (Object)new SemanticsNodeCopy(value.getSemanticsNode(), this.getCurrentSemanticsNodes$ui_release()));
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        this.previousSemanticsRoot = new SemanticsNodeCopy(this.view.getSemanticsOwner().getUnmergedRootSemanticsNode(), this.getCurrentSemanticsNodes$ui_release());
    }

    private final void notifySubtreeStateChangeIfNeeded(LayoutNode layoutNode2) {
        if (this.subtreeChangedLayoutNodes.add((Object)layoutNode2)) {
            this.boundsUpdateChannel.trySend-JP2dKIU((Object)Unit.INSTANCE);
        }
    }

    private final ViewStructureCompat toViewStructure(SemanticsNode $this$toViewStructure) {
        Object object;
        TextLayoutResult it;
        AutofillId autofillId;
        ContentCaptureSessionCompat contentCaptureSessionCompat = this.contentCaptureSession;
        if (contentCaptureSessionCompat == null) {
            return null;
        }
        ContentCaptureSessionCompat session = contentCaptureSessionCompat;
        if (Build.VERSION.SDK_INT < 29) {
            return null;
        }
        AutofillIdCompat autofillIdCompat = ViewCompatShims.getAutofillId((View)this.view);
        if (autofillIdCompat == null) {
            return null;
        }
        AutofillIdCompat rootAutofillId = autofillIdCompat;
        SemanticsNode parentNode = $this$toViewStructure.getParent();
        if (parentNode != null) {
            autofillId = session.newAutofillId(parentNode.getId());
            if (autofillId == null) {
                return null;
            }
        } else {
            autofillId = rootAutofillId.toAutofillId();
        }
        AutofillId parentAutofillId = autofillId;
        ViewStructureCompat viewStructureCompat = session.newVirtualViewStructure(parentAutofillId, $this$toViewStructure.getId());
        if (viewStructureCompat == null) {
            return null;
        }
        ViewStructureCompat structure = viewStructureCompat;
        SemanticsConfiguration configuration = $this$toViewStructure.getUnmergedConfig$ui_release();
        if (configuration.contains(SemanticsProperties.INSTANCE.getPassword())) {
            return null;
        }
        Bundle bundle = structure.getExtras();
        if (bundle != null) {
            bundle.putLong("android.view.contentcapture.EventTimestamp", this.currentSemanticsNodesSnapshotTimestampMillis);
        }
        String string = SemanticsConfigurationKt.getOrNull(configuration, SemanticsProperties.INSTANCE.getTestTag());
        if (string != null) {
            it = string;
            boolean bl = false;
            structure.setId($this$toViewStructure.getId(), null, null, (String)it);
        }
        List<AnnotatedString> list = SemanticsConfigurationKt.getOrNull(configuration, SemanticsProperties.INSTANCE.getText());
        if (list != null) {
            it = list;
            boolean bl = false;
            structure.setClassName("android.widget.TextView");
            structure.setText(ListUtilsKt.fastJoinToString$default((List)it, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        AnnotatedString annotatedString = SemanticsConfigurationKt.getOrNull(configuration, SemanticsProperties.INSTANCE.getEditableText());
        if (annotatedString != null) {
            it = annotatedString;
            boolean bl = false;
            structure.setClassName("android.widget.EditText");
            structure.setText((CharSequence)it);
        }
        TextLayoutResult textLayoutResult = SemanticsConfigurationKt.getOrNull(configuration, SemanticsProperties.INSTANCE.getContentDescription());
        if (textLayoutResult != null) {
            it = textLayoutResult;
            boolean bl = false;
            structure.setContentDescription(ListUtilsKt.fastJoinToString$default(it, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        if ((object = SemanticsConfigurationKt.getOrNull(configuration, SemanticsProperties.INSTANCE.getRole())) != null && (object = SemanticsUtils_androidKt.toLegacyClassName-V4PA4sw(((Role)object).unbox-impl())) != null) {
            Object it2 = object;
            boolean bl = false;
            structure.setClassName((String)it2);
        }
        TextLayoutResult textLayoutResult2 = SemanticsUtils_androidKt.getTextLayoutResult(configuration);
        if (textLayoutResult2 != null) {
            it = textLayoutResult2;
            boolean bl = false;
            TextLayoutInput input = it.getLayoutInput();
            float px = TextUnit.getValue-impl((long)input.getStyle().getFontSize-XSAIIZE()) * input.getDensity().getDensity() * input.getDensity().getFontScale();
            structure.setTextStyle(px, 0, 0, 0);
        }
        Rect $this$toViewStructure_u24lambda_u2419 = $this$toViewStructure.getBoundsInParent$ui_release();
        boolean bl = false;
        structure.setDimens((int)$this$toViewStructure_u24lambda_u2419.getLeft(), (int)$this$toViewStructure_u24lambda_u2419.getTop(), 0, 0, (int)$this$toViewStructure_u24lambda_u2419.getWidth(), (int)$this$toViewStructure_u24lambda_u2419.getHeight());
        return structure;
    }

    private final void bufferContentCaptureViewAppeared(int virtualId, ViewStructureCompat viewStructure) {
        if (viewStructure == null) {
            return;
        }
        if (this.bufferedDisappearedNodes.contains(virtualId)) {
            this.bufferedDisappearedNodes.remove(virtualId);
        } else {
            this.bufferedAppearedNodes.set(virtualId, (Object)viewStructure);
        }
    }

    private final void bufferContentCaptureViewDisappeared(int virtualId) {
        if (this.bufferedAppearedNodes.containsKey(virtualId)) {
            this.bufferedAppearedNodes.remove(virtualId);
        } else {
            this.bufferedDisappearedNodes.add(virtualId);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void notifyContentCaptureChanges() {
        Collection collection;
        boolean bl;
        Object it$iv;
        boolean $i$f$fastForEach;
        List $this$fastForEach$iv$iv;
        List $this$fastMap$iv;
        int index$iv;
        int index$iv$iv;
        boolean $i$f$isFull;
        long value$iv$iv$iv;
        int j$iv$iv;
        int bitCount$iv$iv;
        boolean $i$f$maskEmptyOrDeleted;
        long $this$maskEmptyOrDeleted$iv$iv$iv;
        int lastIndex$iv$iv;
        long[] m$iv$iv;
        int i$iv$iv2;
        IntObjectMap this_$iv;
        ContentCaptureSessionCompat contentCaptureSessionCompat;
        ContentCaptureSessionCompat contentCaptureSessionCompat2 = this.contentCaptureSession;
        if (contentCaptureSessionCompat2 == null) {
            return;
        }
        ContentCaptureSessionCompat session = contentCaptureSessionCompat2;
        if (Build.VERSION.SDK_INT < 29) {
            return;
        }
        if (this.bufferedAppearedNodes.isNotEmpty()) {
            List list;
            List list2 = list = (List)new ArrayList();
            contentCaptureSessionCompat = session;
            boolean bl2 = false;
            this_$iv = (IntObjectMap)this.bufferedAppearedNodes;
            boolean $i$f$forEachValue = false;
            Object[] v$iv = this_$iv.values;
            IntObjectMap this_$iv$iv22 = this_$iv;
            boolean $i$f$forEachIndexed = false;
            i$iv$iv2 = 0;
            m$iv$iv = this_$iv$iv22.metadata;
            lastIndex$iv$iv = m$iv$iv.length - 2;
            if (i$iv$iv2 <= lastIndex$iv$iv) {
                while (true) {
                    long slot$iv$iv;
                    $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv2];
                    $i$f$maskEmptyOrDeleted = false;
                    if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                        bitCount$iv$iv = 8 - (~(i$iv$iv2 - lastIndex$iv$iv) >>> 31);
                        for (j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                            value$iv$iv$iv = slot$iv$iv & 0xFFL;
                            $i$f$isFull = false;
                            if (value$iv$iv$iv < 128L) {
                                void $this$notifyContentCaptureChanges_u24lambda_u2421;
                                index$iv = index$iv$iv = (i$iv$iv2 << 3) + j$iv$iv;
                                boolean bl3 = false;
                                ViewStructureCompat it = (ViewStructureCompat)v$iv[index$iv];
                                boolean bl4 = false;
                                $this$notifyContentCaptureChanges_u24lambda_u2421.add(it);
                            }
                            slot$iv$iv >>= 8;
                        }
                        if (bitCount$iv$iv != 8) break;
                    }
                    if (i$iv$iv2 == lastIndex$iv$iv) break;
                    ++i$iv$iv2;
                }
            }
            boolean $i$f$fastMap = false;
            ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
            $this$fastForEach$iv$iv = $this$fastMap$iv;
            $i$f$fastForEach = false;
            int this_$iv$iv22 = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv2 = 0; index$iv$iv2 < this_$iv$iv22; ++index$iv$iv2) {
                void it;
                Object item$iv$iv;
                it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv2);
                bl = false;
                ViewStructureCompat i$iv$iv2 = (ViewStructureCompat)it$iv;
                collection = target$iv;
                boolean bl5 = false;
                collection.add(it.toViewStructure());
            }
            contentCaptureSessionCompat.notifyViewsAppeared(target$iv);
            this.bufferedAppearedNodes.clear();
        }
        if (this.bufferedDisappearedNodes.isNotEmpty()) {
            List $i$f$fastMap = $this$fastMap$iv = (List)new ArrayList();
            contentCaptureSessionCompat = session;
            boolean bl6 = false;
            this_$iv = (IntSet)this.bufferedDisappearedNodes;
            boolean $i$f$forEach = false;
            int[] k$iv = this_$iv.elements;
            IntObjectMap this_$iv$iv = this_$iv;
            boolean $i$f$forEachIndex = false;
            i$iv$iv2 = 0;
            m$iv$iv = this_$iv$iv.metadata;
            lastIndex$iv$iv = m$iv$iv.length - 2;
            if (i$iv$iv2 <= lastIndex$iv$iv) {
                while (true) {
                    long slot$iv$iv;
                    $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv2];
                    $i$f$maskEmptyOrDeleted = false;
                    if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                        bitCount$iv$iv = 8 - (~(i$iv$iv2 - lastIndex$iv$iv) >>> 31);
                        for (j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                            value$iv$iv$iv = slot$iv$iv & 0xFFL;
                            $i$f$isFull = false;
                            if (value$iv$iv$iv < 128L) {
                                void $this$notifyContentCaptureChanges_u24lambda_u2424;
                                index$iv = index$iv$iv = (i$iv$iv2 << 3) + j$iv$iv;
                                boolean bl7 = false;
                                int it = k$iv[index$iv];
                                boolean bl8 = false;
                                $this$notifyContentCaptureChanges_u24lambda_u2424.add(it);
                            }
                            slot$iv$iv >>= 8;
                        }
                        if (bitCount$iv$iv != 8) break;
                    }
                    if (i$iv$iv2 == lastIndex$iv$iv) break;
                    ++i$iv$iv2;
                }
            }
            boolean $i$f$fastMap2 = false;
            ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
            $this$fastForEach$iv$iv = $this$fastMap$iv;
            $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv3 = 0; index$iv$iv3 < n; ++index$iv$iv3) {
                void it;
                Object item$iv$iv;
                it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv3);
                bl = false;
                i$iv$iv2 = ((Number)it$iv).intValue();
                collection = target$iv;
                boolean bl9 = false;
                collection.add((long)it);
            }
            contentCaptureSessionCompat.notifyViewsDisappeared(CollectionsKt.toLongArray((Collection)target$iv));
            this.bufferedDisappearedNodes.clear();
        }
    }

    private final void updateBuffersOnAppeared(SemanticsNode node) {
        if (!this.isEnabled$ui_release()) {
            return;
        }
        this.updateTranslationOnAppeared(node);
        this.bufferContentCaptureViewAppeared(node.getId(), this.toViewStructure(node));
        List<SemanticsNode> $this$fastForEach$iv = node.getReplacedChildren$ui_release();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            SemanticsNode item$iv;
            SemanticsNode child = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            this.updateBuffersOnAppeared(child);
        }
    }

    private final void updateBuffersOnDisappeared(SemanticsNode node) {
        if (!this.isEnabled$ui_release()) {
            return;
        }
        this.bufferContentCaptureViewDisappeared(node.getId());
        List<SemanticsNode> $this$fastForEach$iv = node.getReplacedChildren$ui_release();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            SemanticsNode item$iv;
            SemanticsNode child = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            this.updateBuffersOnDisappeared(child);
        }
    }

    private final void updateTranslationOnAppeared(SemanticsNode node) {
        block1: {
            AccessibilityAction<Function1<Boolean, Boolean>> accessibilityAction;
            Boolean isShowingTextSubstitution;
            SemanticsConfiguration config2;
            block0: {
                config2 = node.getUnmergedConfig$ui_release();
                isShowingTextSubstitution = SemanticsConfigurationKt.getOrNull(config2, SemanticsProperties.INSTANCE.getIsShowingTextSubstitution());
                if (this.translateStatus != TranslateStatus.SHOW_ORIGINAL || !Intrinsics.areEqual((Object)isShowingTextSubstitution, (Object)true)) break block0;
                AccessibilityAction<Function1<Boolean, Boolean>> accessibilityAction2 = SemanticsConfigurationKt.getOrNull(config2, SemanticsActions.INSTANCE.getShowTextSubstitution());
                if (accessibilityAction2 == null || (accessibilityAction2 = accessibilityAction2.getAction()) == null) break block1;
                Boolean cfr_ignored_0 = (Boolean)accessibilityAction2.invoke(false);
                break block1;
            }
            if (this.translateStatus != TranslateStatus.SHOW_TRANSLATED || !Intrinsics.areEqual((Object)isShowingTextSubstitution, (Object)false) || (accessibilityAction = SemanticsConfigurationKt.getOrNull(config2, SemanticsActions.INSTANCE.getShowTextSubstitution())) == null || (accessibilityAction = accessibilityAction.getAction()) == null) break block1;
            Boolean cfr_ignored_1 = (Boolean)accessibilityAction.invoke(true);
        }
    }

    public final void onShowTranslation$ui_release() {
        this.translateStatus = TranslateStatus.SHOW_TRANSLATED;
        this.showTranslatedText();
    }

    public final void onHideTranslation$ui_release() {
        this.translateStatus = TranslateStatus.SHOW_ORIGINAL;
        this.hideTranslatedText();
    }

    public final void onClearTranslation$ui_release() {
        this.translateStatus = TranslateStatus.SHOW_ORIGINAL;
        this.clearTranslatedText();
    }

    private final void showTranslatedText() {
        IntObjectMap<SemanticsNodeWithAdjustedBounds> this_$iv = this.getCurrentSemanticsNodes$ui_release();
        boolean $i$f$forEachValue = false;
        Object[] v$iv = this_$iv.values;
        IntObjectMap<SemanticsNodeWithAdjustedBounds> this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            SemanticsNodeWithAdjustedBounds node = (SemanticsNodeWithAdjustedBounds)v$iv[index$iv];
                            boolean bl2 = false;
                            SemanticsConfiguration config2 = node.getSemanticsNode().getUnmergedConfig$ui_release();
                            if (Intrinsics.areEqual((Object)SemanticsConfigurationKt.getOrNull(config2, SemanticsProperties.INSTANCE.getIsShowingTextSubstitution()), (Object)false)) {
                                AccessibilityAction<Function1<Boolean, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(config2, SemanticsActions.INSTANCE.getShowTextSubstitution());
                                if (accessibilityAction != null && (accessibilityAction = accessibilityAction.getAction()) != null) {
                                    Boolean cfr_ignored_0 = (Boolean)accessibilityAction.invoke(true);
                                }
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
    }

    private final void hideTranslatedText() {
        IntObjectMap<SemanticsNodeWithAdjustedBounds> this_$iv = this.getCurrentSemanticsNodes$ui_release();
        boolean $i$f$forEachValue = false;
        Object[] v$iv = this_$iv.values;
        IntObjectMap<SemanticsNodeWithAdjustedBounds> this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            SemanticsNodeWithAdjustedBounds node = (SemanticsNodeWithAdjustedBounds)v$iv[index$iv];
                            boolean bl2 = false;
                            SemanticsConfiguration config2 = node.getSemanticsNode().getUnmergedConfig$ui_release();
                            if (Intrinsics.areEqual((Object)SemanticsConfigurationKt.getOrNull(config2, SemanticsProperties.INSTANCE.getIsShowingTextSubstitution()), (Object)true)) {
                                AccessibilityAction<Function1<Boolean, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(config2, SemanticsActions.INSTANCE.getShowTextSubstitution());
                                if (accessibilityAction != null && (accessibilityAction = accessibilityAction.getAction()) != null) {
                                    Boolean cfr_ignored_0 = (Boolean)accessibilityAction.invoke(false);
                                }
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
    }

    private final void clearTranslatedText() {
        IntObjectMap<SemanticsNodeWithAdjustedBounds> this_$iv = this.getCurrentSemanticsNodes$ui_release();
        boolean $i$f$forEachValue = false;
        Object[] v$iv = this_$iv.values;
        IntObjectMap<SemanticsNodeWithAdjustedBounds> this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            SemanticsNodeWithAdjustedBounds node = (SemanticsNodeWithAdjustedBounds)v$iv[index$iv];
                            boolean bl2 = false;
                            SemanticsConfiguration config2 = node.getSemanticsNode().getUnmergedConfig$ui_release();
                            if (SemanticsConfigurationKt.getOrNull(config2, SemanticsProperties.INSTANCE.getIsShowingTextSubstitution()) != null) {
                                AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(config2, SemanticsActions.INSTANCE.getClearTextSubstitution());
                                if (accessibilityAction != null && (accessibilityAction = accessibilityAction.getAction()) != null) {
                                    Boolean cfr_ignored_0 = (Boolean)accessibilityAction.invoke();
                                }
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
    }

    @RequiresApi(value=31)
    public final void onCreateVirtualViewTranslationRequests$ui_release(@NotNull long[] virtualIds, @NotNull int[] supportedFormats, @NotNull Consumer<ViewTranslationRequest> requestsCollector) {
        ViewTranslationHelperMethods.INSTANCE.onCreateVirtualViewTranslationRequests(this, virtualIds, supportedFormats, requestsCollector);
    }

    @RequiresApi(value=31)
    public final void onVirtualViewTranslationResponses$ui_release(@NotNull AndroidContentCaptureManager contentCaptureManager2, @NotNull LongSparseArray<ViewTranslationResponse> response) {
        ViewTranslationHelperMethods.INSTANCE.onVirtualViewTranslationResponses(contentCaptureManager2, response);
    }

    private static final void contentCaptureChangeChecker$lambda$0(AndroidContentCaptureManager this$0) {
        if (!this$0.isEnabled$ui_release()) {
            return;
        }
        Owner.measureAndLayout$default(this$0.view, false, 1, null);
        this$0.sendSemanticsStructureChangeEvents(this$0.view.getSemanticsOwner().getUnmergedRootSemanticsNode(), this$0.previousSemanticsRoot);
        this$0.sendContentCaptureStructureChangeEvents(this$0.view.getSemanticsOwner().getUnmergedRootSemanticsNode(), this$0.previousSemanticsRoot);
        this$0.checkForContentCapturePropertyChanges(this$0.getCurrentSemanticsNodes$ui_release());
        this$0.updateSemanticsCopy();
        this$0.checkingForSemanticsChanges = false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/compose/ui/contentcapture/AndroidContentCaptureManager$TranslateStatus;", "", "(Ljava/lang/String;I)V", "SHOW_ORIGINAL", "SHOW_TRANSLATED", "ui_release"})
    private static final class TranslateStatus
    extends Enum<TranslateStatus> {
        public static final /* enum */ TranslateStatus SHOW_ORIGINAL = new TranslateStatus();
        public static final /* enum */ TranslateStatus SHOW_TRANSLATED = new TranslateStatus();
        private static final /* synthetic */ TranslateStatus[] $VALUES;

        public static TranslateStatus[] values() {
            return (TranslateStatus[])$VALUES.clone();
        }

        public static TranslateStatus valueOf(String value) {
            return Enum.valueOf(TranslateStatus.class, value);
        }

        static {
            $VALUES = translateStatusArray = new TranslateStatus[]{TranslateStatus.SHOW_ORIGINAL, TranslateStatus.SHOW_TRANSLATED};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0002J0\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0007J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0007\u00a8\u0006\u0013"}, d2={"Landroidx/compose/ui/contentcapture/AndroidContentCaptureManager$ViewTranslationHelperMethods;", "", "()V", "doTranslation", "", "contentCaptureManager", "Landroidx/compose/ui/contentcapture/AndroidContentCaptureManager;", "response", "Landroid/util/LongSparseArray;", "Landroid/view/translation/ViewTranslationResponse;", "onCreateVirtualViewTranslationRequests", "virtualIds", "", "supportedFormats", "", "requestsCollector", "Ljava/util/function/Consumer;", "Landroid/view/translation/ViewTranslationRequest;", "onVirtualViewTranslationResponses", "ui_release"})
    @RequiresApi(value=31)
    @SourceDebugExtension(value={"SMAP\nAndroidContentCaptureManager.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidContentCaptureManager.android.kt\nandroidx/compose/ui/contentcapture/AndroidContentCaptureManager$ViewTranslationHelperMethods\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,650:1\n13607#2,2:651\n*S KotlinDebug\n*F\n+ 1 AndroidContentCaptureManager.android.kt\nandroidx/compose/ui/contentcapture/AndroidContentCaptureManager$ViewTranslationHelperMethods\n*L\n568#1:651,2\n*E\n"})
    private static final class ViewTranslationHelperMethods {
        @NotNull
        public static final ViewTranslationHelperMethods INSTANCE = new ViewTranslationHelperMethods();

        private ViewTranslationHelperMethods() {
        }

        @DoNotInline
        @RequiresApi(value=31)
        public final void onCreateVirtualViewTranslationRequests(@NotNull AndroidContentCaptureManager contentCaptureManager2, @NotNull long[] virtualIds, @NotNull int[] supportedFormats, @NotNull Consumer<ViewTranslationRequest> requestsCollector) {
            long[] $this$forEach$iv = virtualIds;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String string;
                SemanticsNode semanticsNode2;
                long element$iv;
                long it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                SemanticsNodeWithAdjustedBounds semanticsNodeWithAdjustedBounds = (SemanticsNodeWithAdjustedBounds)contentCaptureManager2.getCurrentSemanticsNodes$ui_release().get((int)it);
                if (semanticsNodeWithAdjustedBounds == null || (semanticsNode2 = semanticsNodeWithAdjustedBounds.getSemanticsNode()) == null) continue;
                SemanticsNode node = semanticsNode2;
                ViewTranslationRequest.Builder requestBuilder = new ViewTranslationRequest.Builder(contentCaptureManager2.getView().getAutofillId(), (long)node.getId());
                List<AnnotatedString> list = SemanticsConfigurationKt.getOrNull(node.getUnmergedConfig$ui_release(), SemanticsProperties.INSTANCE.getText());
                if (list == null || (string = ListUtilsKt.fastJoinToString$default(list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)) == null) continue;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n2 = 6;
                List list2 = null;
                List list3 = null;
                String string2 = string;
                AnnotatedString text = new AnnotatedString(string2, list3, list2, n2, defaultConstructorMarker);
                requestBuilder.setValue("android:text", TranslationRequestValue.forText((CharSequence)((CharSequence)text)));
                requestsCollector.accept(requestBuilder.build());
            }
        }

        @DoNotInline
        @RequiresApi(value=31)
        public final void onVirtualViewTranslationResponses(@NotNull AndroidContentCaptureManager contentCaptureManager2, @NotNull LongSparseArray<ViewTranslationResponse> response) {
            if (Build.VERSION.SDK_INT < 31) {
                return;
            }
            if (Intrinsics.areEqual((Object)Looper.getMainLooper().getThread(), (Object)Thread.currentThread())) {
                this.doTranslation(contentCaptureManager2, response);
            } else {
                contentCaptureManager2.getView().post(() -> ViewTranslationHelperMethods.onVirtualViewTranslationResponses$lambda$1(contentCaptureManager2, response));
            }
        }

        private final void doTranslation(AndroidContentCaptureManager contentCaptureManager2, LongSparseArray<ViewTranslationResponse> response) {
            LongIterator longIterator = LongSparseArrayKt.keyIterator(response);
            while (longIterator.hasNext()) {
                Function1<AnnotatedString, Boolean> function1;
                SemanticsNode semanticsNode2;
                long key = longIterator.nextLong();
                Object object = (ViewTranslationResponse)response.get(key);
                if (object == null || (object = object.getValue("android:text")) == null || (object = object.getText()) == null) continue;
                Object it = object;
                boolean bl = false;
                SemanticsNodeWithAdjustedBounds semanticsNodeWithAdjustedBounds = (SemanticsNodeWithAdjustedBounds)contentCaptureManager2.getCurrentSemanticsNodes$ui_release().get((int)key);
                if (semanticsNodeWithAdjustedBounds == null || (semanticsNode2 = semanticsNodeWithAdjustedBounds.getSemanticsNode()) == null) continue;
                SemanticsNode semanticsNode3 = semanticsNode2;
                boolean bl2 = false;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(semanticsNode3.getUnmergedConfig$ui_release(), SemanticsActions.INSTANCE.getSetTextSubstitution());
                if (accessibilityAction == null || (function1 = accessibilityAction.getAction()) == null) continue;
                Boolean cfr_ignored_0 = (Boolean)function1.invoke((Object)new AnnotatedString(it.toString(), null, null, 6, null));
            }
        }

        private static final void onVirtualViewTranslationResponses$lambda$1(AndroidContentCaptureManager $contentCaptureManager, LongSparseArray $response) {
            INSTANCE.doTranslation($contentCaptureManager, (LongSparseArray<ViewTranslationResponse>)$response);
        }
    }
}

