/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.autofill;

import android.util.Log;
import android.view.View;
import android.view.autofill.AutofillManager;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.autofill.AndroidAutofill;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u000e"}, d2={"Landroidx/compose/ui/autofill/AutofillCallback;", "Landroid/view/autofill/AutofillManager$AutofillCallback;", "()V", "onAutofillEvent", "", "view", "Landroid/view/View;", "virtualId", "", "event", "register", "autofill", "Landroidx/compose/ui/autofill/AndroidAutofill;", "unregister", "ui_release"})
@RequiresApi(value=26)
@StabilityInferred(parameters=1)
public final class AutofillCallback
extends AutofillManager.AutofillCallback {
    @NotNull
    public static final AutofillCallback INSTANCE = new AutofillCallback();
    public static final int $stable;

    private AutofillCallback() {
    }

    public void onAutofillEvent(@NotNull View view, int virtualId, int event) {
        String string;
        super.onAutofillEvent(view, virtualId, event);
        switch (event) {
            case 1: {
                string = "Autofill popup was shown.";
                break;
            }
            case 2: {
                string = "Autofill popup was hidden.";
                break;
            }
            case 3: {
                string = "Autofill popup isn't shown because autofill is not available.\n\nDid you set up autofill?\n1. Go to Settings > System > Languages&input > Advanced > Autofill Service\n2. Pick a service\n\nDid you add an account?\n1. Go to Settings > System > Languages&input > Advanced\n2. Click on the settings icon next to the Autofill Service\n3. Add your account";
                break;
            }
            default: {
                string = "Unknown status event.";
            }
        }
        Log.d((String)"Autofill Status", (String)string);
    }

    @ExperimentalComposeUiApi
    @DoNotInline
    public final void register(@NotNull AndroidAutofill autofill) {
        autofill.getAutofillManager().registerCallback((AutofillManager.AutofillCallback)this);
    }

    @ExperimentalComposeUiApi
    @DoNotInline
    public final void unregister(@NotNull AndroidAutofill autofill) {
        autofill.getAutofillManager().unregisterCallback((AutofillManager.AutofillCallback)this);
    }
}

