/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/compose/ui/lint/ReturnFromAwaitPointerEventScopeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "ui-lint"})
public final class ReturnFromAwaitPointerEventScopeDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String IssueId = "ReturnFromAwaitPointerEventScope";
    @NotNull
    public static final String ErrorMessage = "Returning from awaitPointerEventScope may cause some input events to be dropped";
    @NotNull
    private static final Issue ExitAwaitPointerEventScope = Issue.Companion.create("ReturnFromAwaitPointerEventScope", "Returning from awaitPointerEventScope may cause some input events to be dropped", "Pointer Input events are queued inside awaitPointerEventScope. By using the return value of awaitPointerEventScope one might unexpectedly lose events. If another awaitPointerEventScope is restarted there is no guarantee that the events will persist between those calls. In this case you should keep all events inside the awaitPointerEventScope block", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ReturnFromAwaitPointerEventScopeDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)Names.Ui.Pointer.INSTANCE.getAwaitPointerEventScope().getShortName());
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!PsiUtilsKt.isInPackageName(method, Names.Ui.Pointer.INSTANCE.getPackageName())) {
            return;
        }
        UElement methodParent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
        boolean isAssignedToVariable = methodParent instanceof ULocalVariable;
        boolean isReturnExpression = methodParent instanceof UReturnExpression;
        if (isAssignedToVariable || isReturnExpression) {
            JavaContext.report$default((JavaContext)context, (Issue)ExitAwaitPointerEventScope, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)ErrorMessage, null, (int)16, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/compose/ui/lint/ReturnFromAwaitPointerEventScopeDetector$Companion;", "", "()V", "ErrorMessage", "", "ExitAwaitPointerEventScope", "Lcom/android/tools/lint/detector/api/Issue;", "getExitAwaitPointerEventScope", "()Lcom/android/tools/lint/detector/api/Issue;", "IssueId", "ui-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getExitAwaitPointerEventScope() {
            return ExitAwaitPointerEventScope;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

