/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import android.view.Choreographer;
import android.view.inputmethod.EditorInfo;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.KeyboardCapitalization;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.core.view.inputmethod.EditorInfoCompat;
import androidx.emoji2.text.EmojiCompat;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0000\u001a\u001c\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\f\u0010\u0011\u001a\u00020\u000b*\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"DEBUG_CLASS", "", "hasFlag", "", "bits", "", "flag", "asExecutor", "Ljava/util/concurrent/Executor;", "Landroid/view/Choreographer;", "update", "", "Landroid/view/inputmethod/EditorInfo;", "imeOptions", "Landroidx/compose/ui/text/input/ImeOptions;", "textFieldValue", "Landroidx/compose/ui/text/input/TextFieldValue;", "updateWithEmojiCompat", "ui_release"})
public final class TextInputServiceAndroid_androidKt {
    @NotNull
    private static final String DEBUG_CLASS = "TextInputServiceAndroid";

    private static final void updateWithEmojiCompat(EditorInfo $this$updateWithEmojiCompat) {
        if (!EmojiCompat.isConfigured()) {
            return;
        }
        EmojiCompat.get().updateEditorInfo($this$updateWithEmojiCompat);
    }

    public static final void update(@NotNull EditorInfo $this$update, @NotNull ImeOptions imeOptions, @NotNull TextFieldValue textFieldValue) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"textFieldValue");
        int n2 = imeOptions.getImeAction-eUduSuo();
        if (ImeAction.equals-impl0((int)n2, (int)ImeAction.Companion.getDefault-eUduSuo())) {
            n = imeOptions.getSingleLine() ? 6 : 0;
        } else if (ImeAction.equals-impl0((int)n2, (int)ImeAction.Companion.getNone-eUduSuo())) {
            n = 1;
        } else if (ImeAction.equals-impl0((int)n2, (int)ImeAction.Companion.getGo-eUduSuo())) {
            n = 2;
        } else if (ImeAction.equals-impl0((int)n2, (int)ImeAction.Companion.getNext-eUduSuo())) {
            n = 5;
        } else if (ImeAction.equals-impl0((int)n2, (int)ImeAction.Companion.getPrevious-eUduSuo())) {
            n = 7;
        } else if (ImeAction.equals-impl0((int)n2, (int)ImeAction.Companion.getSearch-eUduSuo())) {
            n = 3;
        } else if (ImeAction.equals-impl0((int)n2, (int)ImeAction.Companion.getSend-eUduSuo())) {
            n = 4;
        } else if (ImeAction.equals-impl0((int)n2, (int)ImeAction.Companion.getDone-eUduSuo())) {
            n = 6;
        } else {
            throw new IllegalStateException("invalid ImeAction".toString());
        }
        $this$update.imeOptions = n;
        n2 = imeOptions.getKeyboardType-PjHm6EE();
        if (KeyboardType.equals-impl0((int)n2, (int)KeyboardType.Companion.getText-PjHm6EE())) {
            $this$update.inputType = 1;
        } else if (KeyboardType.equals-impl0((int)n2, (int)KeyboardType.Companion.getAscii-PjHm6EE())) {
            $this$update.inputType = 1;
            $this$update.imeOptions |= Integer.MIN_VALUE;
        } else if (KeyboardType.equals-impl0((int)n2, (int)KeyboardType.Companion.getNumber-PjHm6EE())) {
            $this$update.inputType = 2;
        } else if (KeyboardType.equals-impl0((int)n2, (int)KeyboardType.Companion.getPhone-PjHm6EE())) {
            $this$update.inputType = 3;
        } else if (KeyboardType.equals-impl0((int)n2, (int)KeyboardType.Companion.getUri-PjHm6EE())) {
            $this$update.inputType = 17;
        } else if (KeyboardType.equals-impl0((int)n2, (int)KeyboardType.Companion.getEmail-PjHm6EE())) {
            $this$update.inputType = 33;
        } else if (KeyboardType.equals-impl0((int)n2, (int)KeyboardType.Companion.getPassword-PjHm6EE())) {
            $this$update.inputType = 129;
        } else if (KeyboardType.equals-impl0((int)n2, (int)KeyboardType.Companion.getNumberPassword-PjHm6EE())) {
            $this$update.inputType = 18;
        } else if (KeyboardType.equals-impl0((int)n2, (int)KeyboardType.Companion.getDecimal-PjHm6EE())) {
            $this$update.inputType = 8194;
        } else {
            throw new IllegalStateException("Invalid Keyboard Type".toString());
        }
        if (!imeOptions.getSingleLine() && TextInputServiceAndroid_androidKt.hasFlag($this$update.inputType, 1)) {
            $this$update.inputType |= 0x20000;
            if (ImeAction.equals-impl0((int)imeOptions.getImeAction-eUduSuo(), (int)ImeAction.Companion.getDefault-eUduSuo())) {
                $this$update.imeOptions |= 0x40000000;
            }
        }
        if (TextInputServiceAndroid_androidKt.hasFlag($this$update.inputType, 1)) {
            n2 = imeOptions.getCapitalization-IUNYP9k();
            if (KeyboardCapitalization.equals-impl0((int)n2, (int)KeyboardCapitalization.Companion.getCharacters-IUNYP9k())) {
                $this$update.inputType |= 0x1000;
            } else if (KeyboardCapitalization.equals-impl0((int)n2, (int)KeyboardCapitalization.Companion.getWords-IUNYP9k())) {
                $this$update.inputType |= 0x2000;
            } else if (KeyboardCapitalization.equals-impl0((int)n2, (int)KeyboardCapitalization.Companion.getSentences-IUNYP9k())) {
                $this$update.inputType |= 0x4000;
            }
            if (imeOptions.getAutoCorrect()) {
                $this$update.inputType |= 0x8000;
            }
        }
        $this$update.initialSelStart = TextRange.getStart-impl((long)textFieldValue.getSelection-d9O1mEE());
        $this$update.initialSelEnd = TextRange.getEnd-impl((long)textFieldValue.getSelection-d9O1mEE());
        EditorInfoCompat.setInitialSurroundingText((EditorInfo)$this$update, (CharSequence)textFieldValue.getText());
        $this$update.imeOptions |= 0x2000000;
    }

    @NotNull
    public static final Executor asExecutor(@NotNull Choreographer $this$asExecutor) {
        Intrinsics.checkNotNullParameter((Object)$this$asExecutor, (String)"<this>");
        return arg_0 -> TextInputServiceAndroid_androidKt.asExecutor$lambda$1($this$asExecutor, arg_0);
    }

    private static final boolean hasFlag(int bits, int flag) {
        return (bits & flag) == flag;
    }

    private static final void asExecutor$lambda$1$lambda$0(Runnable $runnable, long it) {
        $runnable.run();
    }

    private static final void asExecutor$lambda$1(Choreographer $this_asExecutor, Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)$this_asExecutor, (String)"$this_asExecutor");
        $this_asExecutor.postFrameCallback(arg_0 -> TextInputServiceAndroid_androidKt.asExecutor$lambda$1$lambda$0(runnable, arg_0));
    }

    public static final /* synthetic */ void access$updateWithEmojiCompat(EditorInfo $receiver) {
        TextInputServiceAndroid_androidKt.updateWithEmojiCompat($receiver);
    }
}

