/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view.internal.compat.quirk;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.Quirk;
import androidx.camera.core.impl.QuirkSettingsHolder;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.view.internal.compat.quirk.DeviceQuirksLoader;

public class DeviceQuirks {
    private static final String TAG = "DeviceQuirks";
    @NonNull
    private static volatile Quirks sQuirks;

    private DeviceQuirks() {
    }

    @Nullable
    public static <T extends Quirk> T get(@NonNull Class<T> quirkClass) {
        return (T)sQuirks.get(quirkClass);
    }

    static {
        QuirkSettingsHolder.instance().observe(CameraXExecutors.directExecutor(), quirkSettings -> {
            sQuirks = new Quirks(DeviceQuirksLoader.loadQuirks(quirkSettings));
            Logger.d((String)TAG, (String)("view DeviceQuirks = " + Quirks.toString((Quirks)sQuirks)));
        });
    }
}

