/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.graphics.Bitmap;
import android.util.Size;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.view.PreviewTransformation;
import androidx.camera.view.PreviewView;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

abstract class PreviewViewImplementation {
    @Nullable
    Size mResolution;
    @NonNull
    FrameLayout mParent;
    @NonNull
    private final PreviewTransformation mPreviewTransform;
    private boolean mWasSurfaceProvided = false;

    abstract void initializePreview();

    @Nullable
    abstract View getPreview();

    PreviewViewImplementation(@NonNull FrameLayout parent, @NonNull PreviewTransformation previewTransform) {
        this.mParent = parent;
        this.mPreviewTransform = previewTransform;
    }

    abstract void onSurfaceRequested(@NonNull SurfaceRequest var1, @Nullable OnSurfaceNotInUseListener var2);

    void redrawPreview() {
        View preview = this.getPreview();
        if (preview == null || !this.mWasSurfaceProvided) {
            return;
        }
        this.mPreviewTransform.transformView(new Size(this.mParent.getWidth(), this.mParent.getHeight()), this.mParent.getLayoutDirection(), preview);
    }

    void onSurfaceProvided() {
        this.mWasSurfaceProvided = true;
        this.redrawPreview();
    }

    abstract void onAttachedToWindow();

    abstract void onDetachedFromWindow();

    @NonNull
    abstract ListenableFuture<Void> waitForNextFrame();

    @Nullable
    Bitmap getBitmap() {
        Bitmap bitmap = this.getPreviewBitmap();
        if (bitmap == null) {
            return null;
        }
        return this.mPreviewTransform.createTransformedBitmap(bitmap, new Size(this.mParent.getWidth(), this.mParent.getHeight()), this.mParent.getLayoutDirection());
    }

    @Nullable
    abstract Bitmap getPreviewBitmap();

    void setFrameUpdateListener(@NonNull Executor executor, @NonNull PreviewView.OnFrameUpdateListener listener) {
    }

    static interface OnSurfaceNotInUseListener {
        public void onSurfaceNotInUse();
    }
}

