/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Size;
import android.view.Display;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Logger;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.utils.CameraOrientationUtil;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.view.PreviewView;
import androidx.core.util.Preconditions;

@RequiresApi(value=21)
final class PreviewTransformation {
    private static final String TAG = "PreviewTransform";
    private static final PreviewView.ScaleType DEFAULT_SCALE_TYPE = PreviewView.ScaleType.FILL_CENTER;
    private Size mResolution;
    private Rect mSurfaceCropRect;
    private int mPreviewRotationDegrees;
    private int mTargetRotation;
    private boolean mIsFrontCamera;
    private PreviewView.ScaleType mScaleType = DEFAULT_SCALE_TYPE;

    PreviewTransformation() {
    }

    void setTransformationInfo(@NonNull SurfaceRequest.TransformationInfo transformationInfo, Size resolution, boolean isFrontCamera) {
        Logger.d((String)TAG, (String)("Transformation info set: " + transformationInfo + " " + resolution + " " + isFrontCamera));
        this.mSurfaceCropRect = transformationInfo.getCropRect();
        this.mPreviewRotationDegrees = transformationInfo.getRotationDegrees();
        this.mTargetRotation = transformationInfo.getTargetRotation();
        this.mResolution = resolution;
        this.mIsFrontCamera = isFrontCamera;
    }

    void overrideWithDisplayRotation(int rotationDegrees, int displayRotation) {
        this.mPreviewRotationDegrees = rotationDegrees;
        this.mTargetRotation = displayRotation;
    }

    @VisibleForTesting
    Matrix getTextureViewCorrectionMatrix() {
        Preconditions.checkState((boolean)this.isTransformationInfoReady());
        RectF surfaceRect = new RectF(0.0f, 0.0f, (float)this.mResolution.getWidth(), (float)this.mResolution.getHeight());
        int rotationDegrees = -CameraOrientationUtil.surfaceRotationToDegrees((int)this.mTargetRotation);
        return TransformUtils.getRectToRect((RectF)surfaceRect, (RectF)surfaceRect, (int)rotationDegrees);
    }

    void transformView(Size previewViewSize, int layoutDirection, @NonNull View preview) {
        if (previewViewSize.getHeight() == 0 || previewViewSize.getWidth() == 0) {
            Logger.w((String)TAG, (String)("Transform not applied due to PreviewView size: " + previewViewSize));
            return;
        }
        if (!this.isTransformationInfoReady()) {
            return;
        }
        if (preview instanceof TextureView) {
            ((TextureView)preview).setTransform(this.getTextureViewCorrectionMatrix());
        } else {
            Display display = preview.getDisplay();
            if (display != null && display.getRotation() != this.mTargetRotation) {
                Logger.e((String)TAG, (String)"Non-display rotation not supported with SurfaceView / PERFORMANCE mode.");
            }
        }
        RectF surfaceRectInPreviewView = this.getTransformedSurfaceRect(previewViewSize, layoutDirection);
        preview.setPivotX(0.0f);
        preview.setPivotY(0.0f);
        preview.setScaleX(surfaceRectInPreviewView.width() / (float)this.mResolution.getWidth());
        preview.setScaleY(surfaceRectInPreviewView.height() / (float)this.mResolution.getHeight());
        preview.setTranslationX(surfaceRectInPreviewView.left - (float)preview.getLeft());
        preview.setTranslationY(surfaceRectInPreviewView.top - (float)preview.getTop());
    }

    void setScaleType(PreviewView.ScaleType scaleType) {
        this.mScaleType = scaleType;
    }

    PreviewView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    private RectF getTransformedSurfaceRect(Size previewViewSize, int layoutDirection) {
        Preconditions.checkState((boolean)this.isTransformationInfoReady());
        Matrix surfaceToPreviewView = this.getSurfaceToPreviewViewMatrix(previewViewSize, layoutDirection);
        RectF rect = new RectF(0.0f, 0.0f, (float)this.mResolution.getWidth(), (float)this.mResolution.getHeight());
        surfaceToPreviewView.mapRect(rect);
        return rect;
    }

    Matrix getSurfaceToPreviewViewMatrix(Size previewViewSize, int layoutDirection) {
        Preconditions.checkState((boolean)this.isTransformationInfoReady());
        RectF previewViewCropRect = this.isViewportAspectRatioMatchPreviewView(previewViewSize) ? new RectF(0.0f, 0.0f, (float)previewViewSize.getWidth(), (float)previewViewSize.getHeight()) : this.getPreviewViewViewportRectForMismatchedAspectRatios(previewViewSize, layoutDirection);
        Matrix matrix = TransformUtils.getRectToRect((RectF)new RectF(this.mSurfaceCropRect), (RectF)previewViewCropRect, (int)this.mPreviewRotationDegrees);
        if (this.mIsFrontCamera) {
            if (TransformUtils.is90or270((int)this.mPreviewRotationDegrees)) {
                matrix.preScale(1.0f, -1.0f, (float)this.mSurfaceCropRect.centerX(), (float)this.mSurfaceCropRect.centerY());
            } else {
                matrix.preScale(-1.0f, 1.0f, (float)this.mSurfaceCropRect.centerX(), (float)this.mSurfaceCropRect.centerY());
            }
        }
        return matrix;
    }

    RectF getPreviewViewViewportRectForMismatchedAspectRatios(Size previewViewSize, int layoutDirection) {
        RectF previewViewRect = new RectF(0.0f, 0.0f, (float)previewViewSize.getWidth(), (float)previewViewSize.getHeight());
        Size rotatedViewportSize = this.getRotatedViewportSize();
        RectF rotatedViewportRect = new RectF(0.0f, 0.0f, (float)rotatedViewportSize.getWidth(), (float)rotatedViewportSize.getHeight());
        Matrix matrix = new Matrix();
        PreviewTransformation.setMatrixRectToRect(matrix, rotatedViewportRect, previewViewRect, this.mScaleType);
        matrix.mapRect(rotatedViewportRect);
        if (layoutDirection == 1) {
            return PreviewTransformation.flipHorizontally(rotatedViewportRect, (float)previewViewSize.getWidth() / 2.0f);
        }
        return rotatedViewportRect;
    }

    private static void setMatrixRectToRect(Matrix matrix, RectF source, RectF destination, PreviewView.ScaleType scaleType) {
        boolean isFitTypes;
        Matrix.ScaleToFit matrixScaleType;
        switch (scaleType) {
            case FIT_CENTER: 
            case FILL_CENTER: {
                matrixScaleType = Matrix.ScaleToFit.CENTER;
                break;
            }
            case FIT_END: 
            case FILL_END: {
                matrixScaleType = Matrix.ScaleToFit.END;
                break;
            }
            case FIT_START: 
            case FILL_START: {
                matrixScaleType = Matrix.ScaleToFit.START;
                break;
            }
            default: {
                Logger.e((String)TAG, (String)("Unexpected crop rect: " + (Object)((Object)scaleType)));
                matrixScaleType = Matrix.ScaleToFit.FILL;
            }
        }
        boolean bl = isFitTypes = scaleType == PreviewView.ScaleType.FIT_CENTER || scaleType == PreviewView.ScaleType.FIT_START || scaleType == PreviewView.ScaleType.FIT_END;
        if (isFitTypes) {
            matrix.setRectToRect(source, destination, matrixScaleType);
        } else {
            matrix.setRectToRect(destination, source, matrixScaleType);
            matrix.invert(matrix);
        }
    }

    private static RectF flipHorizontally(RectF original, float flipLineX) {
        return new RectF(flipLineX + flipLineX - original.right, original.top, flipLineX + flipLineX - original.left, original.bottom);
    }

    private Size getRotatedViewportSize() {
        if (TransformUtils.is90or270((int)this.mPreviewRotationDegrees)) {
            return new Size(this.mSurfaceCropRect.height(), this.mSurfaceCropRect.width());
        }
        return new Size(this.mSurfaceCropRect.width(), this.mSurfaceCropRect.height());
    }

    @VisibleForTesting
    boolean isViewportAspectRatioMatchPreviewView(Size previewViewSize) {
        Size rotatedViewportSize = this.getRotatedViewportSize();
        return TransformUtils.isAspectRatioMatchingWithRoundingError((Size)previewViewSize, (boolean)true, (Size)rotatedViewportSize, (boolean)false);
    }

    @Nullable
    Rect getSurfaceCropRect() {
        return this.mSurfaceCropRect;
    }

    Bitmap createTransformedBitmap(@NonNull Bitmap original, Size previewViewSize, int layoutDirection) {
        if (!this.isTransformationInfoReady()) {
            return original;
        }
        Matrix textureViewCorrection = this.getTextureViewCorrectionMatrix();
        RectF surfaceRectInPreviewView = this.getTransformedSurfaceRect(previewViewSize, layoutDirection);
        Bitmap transformed = Bitmap.createBitmap((int)previewViewSize.getWidth(), (int)previewViewSize.getHeight(), (Bitmap.Config)original.getConfig());
        Canvas canvas = new Canvas(transformed);
        Matrix canvasTransform = new Matrix();
        canvasTransform.postConcat(textureViewCorrection);
        canvasTransform.postScale(surfaceRectInPreviewView.width() / (float)this.mResolution.getWidth(), surfaceRectInPreviewView.height() / (float)this.mResolution.getHeight());
        canvasTransform.postTranslate(surfaceRectInPreviewView.left, surfaceRectInPreviewView.top);
        canvas.drawBitmap(original, canvasTransform, new Paint(7));
        return transformed;
    }

    @Nullable
    Matrix getPreviewViewToNormalizedSurfaceMatrix(Size previewViewSize, int layoutDirection) {
        if (!this.isTransformationInfoReady()) {
            return null;
        }
        Matrix matrix = new Matrix();
        this.getSurfaceToPreviewViewMatrix(previewViewSize, layoutDirection).invert(matrix);
        Matrix normalization = new Matrix();
        normalization.setRectToRect(new RectF(0.0f, 0.0f, (float)this.mResolution.getWidth(), (float)this.mResolution.getHeight()), new RectF(0.0f, 0.0f, 1.0f, 1.0f), Matrix.ScaleToFit.FILL);
        matrix.postConcat(normalization);
        return matrix;
    }

    private boolean isTransformationInfoReady() {
        return this.mSurfaceCropRect != null && this.mResolution != null && this.mTargetRotation != -1;
    }
}

