/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.workaround;

import android.media.MediaCodec;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiresApi(value=21)
public class CorrectVideoTimeByTimebase {
    private static final String TAG = "CorrectVideoTimeByTimebase";
    @Nullable
    private AtomicBoolean mNeedToCorrectVideoTimebase = null;

    public void correctTimestamp(@NonNull MediaCodec.BufferInfo bufferInfo) {
        if (this.mNeedToCorrectVideoTimebase == null) {
            boolean closeToRealTime;
            if (bufferInfo.size <= 0 || bufferInfo.presentationTimeUs <= 0L || (bufferInfo.flags & 2) != 0) {
                return;
            }
            long uptimeUs = TimeUnit.MILLISECONDS.toMicros(SystemClock.uptimeMillis());
            long realtimeUs = TimeUnit.MILLISECONDS.toMicros(SystemClock.elapsedRealtime());
            boolean bl = closeToRealTime = Math.abs(bufferInfo.presentationTimeUs - realtimeUs) < Math.abs(bufferInfo.presentationTimeUs - uptimeUs);
            if (closeToRealTime) {
                Logger.w((String)TAG, (String)"Detected video buffer timestamp is close to real time.");
            }
            this.mNeedToCorrectVideoTimebase = new AtomicBoolean(closeToRealTime);
        }
        if (this.mNeedToCorrectVideoTimebase.get()) {
            bufferInfo.presentationTimeUs -= TimeUnit.MILLISECONDS.toMicros(SystemClock.elapsedRealtime() - SystemClock.uptimeMillis());
        }
    }
}

