/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.video.internal.utils.RingBuffer;
import androidx.core.util.Preconditions;
import java.util.ArrayDeque;
import java.util.Queue;

@RequiresApi(value=21)
public class ArrayDequeRingBuffer<E>
implements RingBuffer<E> {
    private static final String TAG = "ArrayDequeRingBuffer";
    private final int mCapacity;
    private final Queue<E> mQueue = new ArrayDeque();

    public ArrayDequeRingBuffer(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"The capacity should be greater than 0.");
        this.mCapacity = capacity;
    }

    @Override
    public boolean offer(@NonNull E data) {
        Preconditions.checkNotNull(data);
        if (!this.mQueue.offer(data)) {
            return false;
        }
        while (this.size() > this.mCapacity) {
            this.poll();
            Logger.d((String)TAG, (String)"Head data is dropped because the ring buffer reached its capacity.");
        }
        return true;
    }

    @Override
    @Nullable
    public E poll() {
        return this.mQueue.poll();
    }

    @Override
    @Nullable
    public E peek() {
        return this.mQueue.peek();
    }

    @Override
    public int capacity() {
        return this.mCapacity;
    }

    @Override
    public int size() {
        return this.mQueue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mQueue.isEmpty();
    }

    @Override
    public void clear() {
        this.mQueue.clear();
    }
}

