/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import androidx.annotation.NonNull;
import androidx.camera.video.internal.encoder.AudioEncoderConfig;

final class AutoValue_AudioEncoderConfig
extends AudioEncoderConfig {
    private final String mimeType;
    private final int profile;
    private final int bitrate;
    private final int sampleRate;
    private final int channelCount;

    private AutoValue_AudioEncoderConfig(String mimeType, int profile, int bitrate, int sampleRate, int channelCount) {
        this.mimeType = mimeType;
        this.profile = profile;
        this.bitrate = bitrate;
        this.sampleRate = sampleRate;
        this.channelCount = channelCount;
    }

    @Override
    @NonNull
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public int getProfile() {
        return this.profile;
    }

    @Override
    public int getBitrate() {
        return this.bitrate;
    }

    @Override
    public int getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public int getChannelCount() {
        return this.channelCount;
    }

    public String toString() {
        return "AudioEncoderConfig{mimeType=" + this.mimeType + ", profile=" + this.profile + ", bitrate=" + this.bitrate + ", sampleRate=" + this.sampleRate + ", channelCount=" + this.channelCount + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AudioEncoderConfig) {
            AudioEncoderConfig that = (AudioEncoderConfig)o;
            return this.mimeType.equals(that.getMimeType()) && this.profile == that.getProfile() && this.bitrate == that.getBitrate() && this.sampleRate == that.getSampleRate() && this.channelCount == that.getChannelCount();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.mimeType.hashCode();
        h$ *= 1000003;
        h$ ^= this.profile;
        h$ *= 1000003;
        h$ ^= this.bitrate;
        h$ *= 1000003;
        h$ ^= this.sampleRate;
        h$ *= 1000003;
        return h$ ^= this.channelCount;
    }

    static final class Builder
    extends AudioEncoderConfig.Builder {
        private String mimeType;
        private Integer profile;
        private Integer bitrate;
        private Integer sampleRate;
        private Integer channelCount;

        Builder() {
        }

        @Override
        public AudioEncoderConfig.Builder setMimeType(String mimeType) {
            if (mimeType == null) {
                throw new NullPointerException("Null mimeType");
            }
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public AudioEncoderConfig.Builder setProfile(int profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public AudioEncoderConfig.Builder setBitrate(int bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        @Override
        public AudioEncoderConfig.Builder setSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        @Override
        public AudioEncoderConfig.Builder setChannelCount(int channelCount) {
            this.channelCount = channelCount;
            return this;
        }

        @Override
        AudioEncoderConfig autoBuild() {
            String missing = "";
            if (this.mimeType == null) {
                missing = missing + " mimeType";
            }
            if (this.profile == null) {
                missing = missing + " profile";
            }
            if (this.bitrate == null) {
                missing = missing + " bitrate";
            }
            if (this.sampleRate == null) {
                missing = missing + " sampleRate";
            }
            if (this.channelCount == null) {
                missing = missing + " channelCount";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AudioEncoderConfig(this.mimeType, this.profile, this.bitrate, this.sampleRate, this.channelCount);
        }
    }
}

