/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.video.VideoSpec;
import androidx.camera.video.internal.config.VideoConfigUtil;
import androidx.camera.video.internal.encoder.VideoEncoderConfig;
import androidx.core.util.Supplier;

@RequiresApi(value=21)
public class VideoEncoderConfigDefaultResolver
implements Supplier<VideoEncoderConfig> {
    private static final String TAG = "VidEncCfgDefaultRslvr";
    private static final int VIDEO_BITRATE_BASE = 14000000;
    private static final Size VIDEO_SIZE_BASE = new Size(1280, 720);
    private static final int VIDEO_FRAME_RATE_BASE = 30;
    private final String mMimeType;
    private final VideoSpec mVideoSpec;
    private final Size mSurfaceSize;

    public VideoEncoderConfigDefaultResolver(@NonNull String mimeType, @NonNull VideoSpec videoSpec, @NonNull Size surfaceSize) {
        this.mMimeType = mimeType;
        this.mVideoSpec = videoSpec;
        this.mSurfaceSize = surfaceSize;
    }

    @NonNull
    public VideoEncoderConfig get() {
        int resolvedFrameRate = VideoConfigUtil.resolveFrameRate(this.mVideoSpec);
        Range<Integer> videoSpecBitrateRange = this.mVideoSpec.getBitrate();
        Logger.d((String)TAG, (String)"Using fallback VIDEO bitrate");
        int resolvedBitrate = VideoConfigUtil.scaleAndClampBitrate(14000000, resolvedFrameRate, 30, this.mSurfaceSize.getWidth(), VIDEO_SIZE_BASE.getWidth(), this.mSurfaceSize.getHeight(), VIDEO_SIZE_BASE.getHeight(), videoSpecBitrateRange);
        return VideoEncoderConfig.builder().setMimeType(this.mMimeType).setResolution(this.mSurfaceSize).setBitrate(resolvedBitrate).setFrameRate(resolvedFrameRate).build();
    }
}

