/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.video.VideoSpec;

@RequiresApi(value=21)
public final class VideoConfigUtil {
    private static final String TAG = "VideoConfigUtil";
    private static final int VIDEO_FRAME_RATE_FIXED_DEFAULT = 30;

    private VideoConfigUtil() {
    }

    static int resolveFrameRate(@NonNull VideoSpec videoSpec) {
        Range<Integer> videoSpecFrameRateRange = videoSpec.getFrameRate();
        int resolvedFrameRate = 30;
        if (VideoSpec.FRAME_RATE_RANGE_AUTO.equals(videoSpecFrameRateRange) || videoSpecFrameRateRange.contains((Comparable)Integer.valueOf(30))) {
            Logger.d((String)TAG, (String)("Using single supported VIDEO frame rate: " + resolvedFrameRate));
        } else {
            Logger.w((String)TAG, (String)("Requested frame rate range does not include single supported frame rate. Ignoring range. [range: " + videoSpecFrameRateRange + " supported frame rate: " + resolvedFrameRate + "]"));
        }
        return resolvedFrameRate;
    }

    static int scaleAndClampBitrate(int baseBitrate, int actualFrameRate, int baseFrameRate, int actualWidth, int baseWidth, int actualHeight, int baseHeight, @NonNull Range<Integer> clampedRange) {
        Rational frameRateRatio = new Rational(actualFrameRate, baseFrameRate);
        Rational widthRatio = new Rational(actualWidth, baseWidth);
        Rational heightRatio = new Rational(actualHeight, baseHeight);
        int resolvedBitrate = (int)((double)baseBitrate * frameRateRatio.doubleValue() * widthRatio.doubleValue() * heightRatio.doubleValue());
        String debugString = "";
        if (Logger.isDebugEnabled((String)TAG)) {
            debugString = String.format("Base Bitrate(%dbps) * Frame Rate Ratio(%d / %d) * Width Ratio(%d / %d) * Height Ratio(%d / %d) = %d", baseBitrate, actualFrameRate, baseFrameRate, actualWidth, baseWidth, actualHeight, baseHeight, resolvedBitrate);
        }
        if (!VideoSpec.BITRATE_RANGE_AUTO.equals(clampedRange)) {
            resolvedBitrate = (Integer)clampedRange.clamp((Comparable)Integer.valueOf(resolvedBitrate));
            if (Logger.isDebugEnabled((String)TAG)) {
                debugString = debugString + String.format("\nClamped to range %s -> %dbps", clampedRange, resolvedBitrate);
            }
        }
        Logger.d((String)TAG, (String)debugString);
        return resolvedBitrate;
    }
}

