/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CamcorderProfileProxy;
import androidx.camera.video.AudioSpec;
import androidx.camera.video.internal.AudioSource;
import androidx.camera.video.internal.config.AudioConfigUtil;
import androidx.core.util.Supplier;

@RequiresApi(value=21)
public final class AudioSourceSettingsCamcorderProfileResolver
implements Supplier<AudioSource.Settings> {
    private static final String TAG = "AudioSrcCmcrdrPrflRslvr";
    private final AudioSpec mAudioSpec;
    private final CamcorderProfileProxy mCamcorderProfile;

    public AudioSourceSettingsCamcorderProfileResolver(@NonNull AudioSpec audioSpec, @NonNull CamcorderProfileProxy camcorderProfile) {
        this.mAudioSpec = audioSpec;
        this.mCamcorderProfile = camcorderProfile;
    }

    @NonNull
    public AudioSource.Settings get() {
        int resolvedChannelCount;
        int resolvedAudioSource = AudioConfigUtil.resolveAudioSource(this.mAudioSpec);
        int resolvedSourceFormat = AudioConfigUtil.resolveAudioSourceFormat(this.mAudioSpec);
        int audioSpecChannelCount = this.mAudioSpec.getChannelCount();
        Range<Integer> audioSpecSampleRate = this.mAudioSpec.getSampleRate();
        int camcorderProfileChannelCount = this.mCamcorderProfile.getAudioChannels();
        if (audioSpecChannelCount == -1) {
            resolvedChannelCount = camcorderProfileChannelCount;
            Logger.d((String)TAG, (String)("Resolved AUDIO channel count from CamcorderProfile: " + resolvedChannelCount));
        } else {
            resolvedChannelCount = audioSpecChannelCount;
            Logger.d((String)TAG, (String)("Media spec AUDIO channel count overrides CamcorderProfile [CamcorderProfile channel count: " + camcorderProfileChannelCount + ", Resolved Channel Count: " + resolvedChannelCount + "]"));
        }
        int camcorderProfileAudioSampleRate = this.mCamcorderProfile.getAudioSampleRate();
        int resolvedSampleRate = AudioConfigUtil.selectSampleRateOrNearestSupported(audioSpecSampleRate, resolvedChannelCount, resolvedSourceFormat, camcorderProfileAudioSampleRate);
        Logger.d((String)TAG, (String)("Using resolved AUDIO sample rate or nearest supported from CamcorderProfile: " + resolvedSampleRate + "Hz. [CamcorderProfile sample rate: " + camcorderProfileAudioSampleRate + "Hz]"));
        return AudioSource.Settings.builder().setAudioSource(resolvedAudioSource).setAudioFormat(resolvedSourceFormat).setChannelCount(resolvedChannelCount).setSampleRate(resolvedSampleRate).build();
    }
}

