/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.video.AudioSpec;
import androidx.camera.video.internal.AudioSource;
import androidx.camera.video.internal.config.AudioConfigUtil;
import androidx.camera.video.internal.encoder.AudioEncoderConfig;
import androidx.core.util.Supplier;

@RequiresApi(value=21)
public final class AudioEncoderConfigDefaultResolver
implements Supplier<AudioEncoderConfig> {
    private static final String TAG = "AudioEncCfgDefaultRslvr";
    private final String mMimeType;
    private final int mAudioProfile;
    private final AudioSpec mAudioSpec;
    private final AudioSource.Settings mAudioSourceSettings;
    private static final int AUDIO_BITRATE_BASE = 156000;
    private static final int AUDIO_CHANNEL_COUNT_BASE = 2;
    private static final int AUDIO_SAMPLE_RATE_BASE = 48000;

    public AudioEncoderConfigDefaultResolver(@NonNull String mimeType, int audioProfile, @NonNull AudioSpec audioSpec, @NonNull AudioSource.Settings audioSourceSettings) {
        this.mMimeType = mimeType;
        this.mAudioProfile = audioProfile;
        this.mAudioSpec = audioSpec;
        this.mAudioSourceSettings = audioSourceSettings;
    }

    @NonNull
    public AudioEncoderConfig get() {
        Range<Integer> audioSpecBitrateRange = this.mAudioSpec.getBitrate();
        Logger.d((String)TAG, (String)"Using fallback AUDIO bitrate");
        int resolvedBitrate = AudioConfigUtil.scaleAndClampBitrate(156000, this.mAudioSourceSettings.getChannelCount(), 2, this.mAudioSourceSettings.getSampleRate(), 48000, audioSpecBitrateRange);
        return AudioEncoderConfig.builder().setMimeType(this.mMimeType).setProfile(this.mAudioProfile).setChannelCount(this.mAudioSourceSettings.getChannelCount()).setSampleRate(this.mAudioSourceSettings.getSampleRate()).setBitrate(resolvedBitrate).build();
    }
}

