/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CamcorderProfileProxy;
import androidx.camera.video.AudioSpec;
import androidx.camera.video.internal.AudioSource;
import androidx.camera.video.internal.config.AudioConfigUtil;
import androidx.camera.video.internal.encoder.AudioEncoderConfig;
import androidx.core.util.Supplier;

@RequiresApi(value=21)
public final class AudioEncoderConfigCamcorderProfileResolver
implements Supplier<AudioEncoderConfig> {
    private static final String TAG = "AudioEncCmcrdrPrflRslvr";
    private final String mMimeType;
    private final int mAudioProfile;
    private final AudioSpec mAudioSpec;
    private final AudioSource.Settings mAudioSourceSettings;
    private final CamcorderProfileProxy mCamcorderProfile;

    public AudioEncoderConfigCamcorderProfileResolver(@NonNull String mimeType, int audioProfile, @NonNull AudioSpec audioSpec, @NonNull AudioSource.Settings audioSourceSettings, @NonNull CamcorderProfileProxy camcorderProfile) {
        this.mMimeType = mimeType;
        this.mAudioProfile = audioProfile;
        this.mAudioSpec = audioSpec;
        this.mAudioSourceSettings = audioSourceSettings;
        this.mCamcorderProfile = camcorderProfile;
    }

    @NonNull
    public AudioEncoderConfig get() {
        Logger.d((String)TAG, (String)"Using resolved AUDIO bitrate from CamcorderProfile");
        Range<Integer> audioSpecBitrateRange = this.mAudioSpec.getBitrate();
        int resolvedBitrate = AudioConfigUtil.scaleAndClampBitrate(this.mCamcorderProfile.getAudioBitRate(), this.mAudioSourceSettings.getChannelCount(), this.mCamcorderProfile.getAudioChannels(), this.mAudioSourceSettings.getSampleRate(), this.mCamcorderProfile.getAudioSampleRate(), audioSpecBitrateRange);
        return AudioEncoderConfig.builder().setMimeType(this.mMimeType).setProfile(this.mAudioProfile).setChannelCount(this.mAudioSourceSettings.getChannelCount()).setSampleRate(this.mAudioSourceSettings.getSampleRate()).setBitrate(resolvedBitrate).build();
    }
}

