/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal;

import androidx.annotation.IntRange;
import androidx.camera.video.internal.AudioSource;

final class AutoValue_AudioSource_Settings
extends AudioSource.Settings {
    private final int audioSource;
    private final int sampleRate;
    private final int channelCount;
    private final int audioFormat;

    private AutoValue_AudioSource_Settings(int audioSource, int sampleRate, int channelCount, int audioFormat) {
        this.audioSource = audioSource;
        this.sampleRate = sampleRate;
        this.channelCount = channelCount;
        this.audioFormat = audioFormat;
    }

    @Override
    public int getAudioSource() {
        return this.audioSource;
    }

    @Override
    @IntRange(from=1L)
    public int getSampleRate() {
        return this.sampleRate;
    }

    @Override
    @IntRange(from=1L)
    public int getChannelCount() {
        return this.channelCount;
    }

    @Override
    public int getAudioFormat() {
        return this.audioFormat;
    }

    public String toString() {
        return "Settings{audioSource=" + this.audioSource + ", sampleRate=" + this.sampleRate + ", channelCount=" + this.channelCount + ", audioFormat=" + this.audioFormat + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AudioSource.Settings) {
            AudioSource.Settings that = (AudioSource.Settings)o;
            return this.audioSource == that.getAudioSource() && this.sampleRate == that.getSampleRate() && this.channelCount == that.getChannelCount() && this.audioFormat == that.getAudioFormat();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.audioSource;
        h$ *= 1000003;
        h$ ^= this.sampleRate;
        h$ *= 1000003;
        h$ ^= this.channelCount;
        h$ *= 1000003;
        return h$ ^= this.audioFormat;
    }

    @Override
    public AudioSource.Settings.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AudioSource.Settings.Builder {
        private Integer audioSource;
        private Integer sampleRate;
        private Integer channelCount;
        private Integer audioFormat;

        Builder() {
        }

        private Builder(AudioSource.Settings source) {
            this.audioSource = source.getAudioSource();
            this.sampleRate = source.getSampleRate();
            this.channelCount = source.getChannelCount();
            this.audioFormat = source.getAudioFormat();
        }

        @Override
        public AudioSource.Settings.Builder setAudioSource(int audioSource) {
            this.audioSource = audioSource;
            return this;
        }

        @Override
        public AudioSource.Settings.Builder setSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        @Override
        public AudioSource.Settings.Builder setChannelCount(int channelCount) {
            this.channelCount = channelCount;
            return this;
        }

        @Override
        public AudioSource.Settings.Builder setAudioFormat(int audioFormat) {
            this.audioFormat = audioFormat;
            return this;
        }

        @Override
        AudioSource.Settings autoBuild() {
            String missing = "";
            if (this.audioSource == null) {
                missing = missing + " audioSource";
            }
            if (this.sampleRate == null) {
                missing = missing + " sampleRate";
            }
            if (this.channelCount == null) {
                missing = missing + " channelCount";
            }
            if (this.audioFormat == null) {
                missing = missing + " audioFormat";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AudioSource_Settings(this.audioSource, this.sampleRate, this.channelCount, this.audioFormat);
        }
    }
}

