/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.video.OutputOptions;
import androidx.camera.video.OutputResults;
import androidx.camera.video.RecordingStats;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RequiresApi(value=21)
public abstract class VideoRecordEvent {
    private final OutputOptions mOutputOptions;
    private final RecordingStats mRecordingStats;

    VideoRecordEvent(@NonNull OutputOptions outputOptions, @NonNull RecordingStats recordingStats) {
        this.mOutputOptions = (OutputOptions)Preconditions.checkNotNull((Object)outputOptions);
        this.mRecordingStats = (RecordingStats)Preconditions.checkNotNull((Object)recordingStats);
    }

    @NonNull
    public RecordingStats getRecordingStats() {
        return this.mRecordingStats;
    }

    @NonNull
    public OutputOptions getOutputOptions() {
        return this.mOutputOptions;
    }

    @NonNull
    static Start start(@NonNull OutputOptions outputOptions, @NonNull RecordingStats recordingStats) {
        return new Start(outputOptions, recordingStats);
    }

    @NonNull
    static Finalize finalize(@NonNull OutputOptions outputOptions, @NonNull RecordingStats recordingStats, @NonNull OutputResults outputResults) {
        return new Finalize(outputOptions, recordingStats, outputResults, 0, null);
    }

    @NonNull
    static Finalize finalizeWithError(@NonNull OutputOptions outputOptions, @NonNull RecordingStats recordingStats, @NonNull OutputResults outputResults, int error, @Nullable Throwable cause) {
        Preconditions.checkArgument((error != 0 ? 1 : 0) != 0, (Object)"An error type is required.");
        return new Finalize(outputOptions, recordingStats, outputResults, error, cause);
    }

    @NonNull
    static Status status(@NonNull OutputOptions outputOptions, @NonNull RecordingStats recordingStats) {
        return new Status(outputOptions, recordingStats);
    }

    @NonNull
    static Pause pause(@NonNull OutputOptions outputOptions, @NonNull RecordingStats recordingStats) {
        return new Pause(outputOptions, recordingStats);
    }

    @NonNull
    static Resume resume(@NonNull OutputOptions outputOptions, @NonNull RecordingStats recordingStats) {
        return new Resume(outputOptions, recordingStats);
    }

    @RequiresApi(value=21)
    public static final class Resume
    extends VideoRecordEvent {
        Resume(@NonNull OutputOptions outputOptions, @NonNull RecordingStats recordingStats) {
            super(outputOptions, recordingStats);
        }
    }

    @RequiresApi(value=21)
    public static final class Pause
    extends VideoRecordEvent {
        Pause(@NonNull OutputOptions outputOptions, @NonNull RecordingStats recordingStats) {
            super(outputOptions, recordingStats);
        }
    }

    @RequiresApi(value=21)
    public static final class Status
    extends VideoRecordEvent {
        Status(@NonNull OutputOptions outputOptions, @NonNull RecordingStats recordingStats) {
            super(outputOptions, recordingStats);
        }
    }

    @RequiresApi(value=21)
    public static final class Finalize
    extends VideoRecordEvent {
        public static final int ERROR_NONE = 0;
        public static final int ERROR_UNKNOWN = 1;
        public static final int ERROR_FILE_SIZE_LIMIT_REACHED = 2;
        public static final int ERROR_INSUFFICIENT_STORAGE = 3;
        public static final int ERROR_SOURCE_INACTIVE = 4;
        public static final int ERROR_INVALID_OUTPUT_OPTIONS = 5;
        public static final int ERROR_ENCODING_FAILED = 6;
        public static final int ERROR_RECORDER_ERROR = 7;
        public static final int ERROR_NO_VALID_DATA = 8;
        private final OutputResults mOutputResults;
        private final int mError;
        private final Throwable mCause;

        Finalize(@NonNull OutputOptions outputOptions, @NonNull RecordingStats recordingStats, @NonNull OutputResults outputResults, int error, @Nullable Throwable cause) {
            super(outputOptions, recordingStats);
            this.mOutputResults = outputResults;
            this.mError = error;
            this.mCause = cause;
        }

        @NonNull
        public OutputResults getOutputResults() {
            return this.mOutputResults;
        }

        public boolean hasError() {
            return this.mError != 0;
        }

        public int getError() {
            return this.mError;
        }

        @Nullable
        public Throwable getCause() {
            return this.mCause;
        }

        @NonNull
        static String errorToString(int error) {
            switch (error) {
                case 0: {
                    return "ERROR_NONE";
                }
                case 1: {
                    return "ERROR_UNKNOWN";
                }
                case 2: {
                    return "ERROR_FILE_SIZE_LIMIT_REACHED";
                }
                case 3: {
                    return "ERROR_INSUFFICIENT_STORAGE";
                }
                case 5: {
                    return "ERROR_INVALID_OUTPUT_OPTIONS";
                }
                case 6: {
                    return "ERROR_ENCODING_FAILED";
                }
                case 7: {
                    return "ERROR_RECORDER_ERROR";
                }
                case 8: {
                    return "ERROR_NO_VALID_DATA";
                }
                case 4: {
                    return "ERROR_SOURCE_INACTIVE";
                }
            }
            return "Unknown(" + error + ")";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static @interface VideoRecordError {
        }
    }

    @RequiresApi(value=21)
    public static final class Start
    extends VideoRecordEvent {
        Start(@NonNull OutputOptions outputOptions, @NonNull RecordingStats recordingStats) {
            super(outputOptions, recordingStats);
        }
    }
}

