/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.graphics.Rect;
import android.media.MediaCodec;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Logger;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.ThreadConfig;
import androidx.camera.core.internal.UseCaseEventConfig;
import androidx.camera.video.MediaSpec;
import androidx.camera.video.Quality;
import androidx.camera.video.QualitySelector;
import androidx.camera.video.StreamInfo;
import androidx.camera.video.VideoOutput;
import androidx.camera.video.impl.VideoCaptureConfig;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiresApi(value=21)
public final class VideoCapture<T extends VideoOutput>
extends UseCase {
    private static final String TAG = "VideoCapture";
    private static final String SURFACE_UPDATE_KEY = "androidx.camera.video.VideoCapture.streamUpdate";
    private static final Defaults DEFAULT_CONFIG = new Defaults();
    DeferrableSurface mDeferrableSurface;
    StreamInfo mStreamInfo = StreamInfo.STREAM_INFO_ANY_INACTIVE;
    @NonNull
    SessionConfig.Builder mSessionConfigBuilder = new SessionConfig.Builder();
    ListenableFuture<Void> mSurfaceUpdateFuture = null;
    private SurfaceRequest mSurfaceRequest;
    VideoOutput.SourceState mSourceState = VideoOutput.SourceState.INACTIVE;
    private final Observable.Observer<StreamInfo> mStreamInfoObserver = new Observable.Observer<StreamInfo>(){

        public void onNewData(@Nullable StreamInfo streamInfo) {
            if (streamInfo == null) {
                throw new IllegalArgumentException("StreamInfo can't be null");
            }
            if (VideoCapture.this.mSourceState == VideoOutput.SourceState.INACTIVE) {
                return;
            }
            Logger.d((String)VideoCapture.TAG, (String)("Stream info update: old: " + VideoCapture.this.mStreamInfo + " new: " + streamInfo));
            StreamInfo currentStreamInfo = VideoCapture.this.mStreamInfo;
            VideoCapture.this.mStreamInfo = streamInfo;
            if (!StreamInfo.NON_SURFACE_STREAM_ID.contains(currentStreamInfo.getId()) && !StreamInfo.NON_SURFACE_STREAM_ID.contains(streamInfo.getId()) && currentStreamInfo.getId() != streamInfo.getId()) {
                VideoCapture.this.resetPipeline(VideoCapture.this.getCameraId(), (VideoCaptureConfig)VideoCapture.this.getCurrentConfig(), (Size)Preconditions.checkNotNull((Object)VideoCapture.this.getAttachedSurfaceResolution()));
            } else if (currentStreamInfo.getId() != -1 && streamInfo.getId() == -1 || currentStreamInfo.getId() == -1 && streamInfo.getId() != -1) {
                VideoCapture.this.applyStreamInfoToSessionConfigBuilder(VideoCapture.this.mSessionConfigBuilder, streamInfo);
                VideoCapture.this.updateSessionConfig(VideoCapture.this.mSessionConfigBuilder.build());
                VideoCapture.this.notifyReset();
            } else if (currentStreamInfo.getStreamState() != streamInfo.getStreamState()) {
                VideoCapture.this.applyStreamInfoToSessionConfigBuilder(VideoCapture.this.mSessionConfigBuilder, streamInfo);
                VideoCapture.this.updateSessionConfig(VideoCapture.this.mSessionConfigBuilder.build());
                VideoCapture.this.notifyUpdated();
            }
        }

        public void onError(@NonNull Throwable t) {
            Logger.w((String)VideoCapture.TAG, (String)"Receive onError from StreamState observer", (Throwable)t);
        }
    };

    @NonNull
    public static <T extends VideoOutput> VideoCapture<T> withOutput(@NonNull T videoOutput) {
        return new Builder<VideoOutput>((VideoOutput)Preconditions.checkNotNull(videoOutput)).build();
    }

    VideoCapture(@NonNull VideoCaptureConfig<T> config) {
        super(config);
    }

    @NonNull
    public T getOutput() {
        return ((VideoCaptureConfig)this.getCurrentConfig()).getVideoOutput();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getTargetRotation() {
        return this.getTargetRotationInternal();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setTargetRotation(int rotation) {
        if (this.setTargetRotationInternal(rotation)) {
            this.sendTransformationInfoIfReady(this.getAttachedSurfaceResolution());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onStateAttached() {
        super.onStateAttached();
        this.getOutput().getStreamInfo().addObserver((Executor)CameraXExecutors.mainThreadExecutor(), this.mStreamInfoObserver);
        this.setSourceState(VideoOutput.SourceState.ACTIVE_NON_STREAMING);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected Size onSuggestedResolutionUpdated(@NonNull Size suggestedResolution) {
        Logger.d((String)TAG, (String)("suggestedResolution = " + suggestedResolution));
        String cameraId = this.getCameraId();
        VideoCaptureConfig config = (VideoCaptureConfig)this.getCurrentConfig();
        Size[] supportedResolutions = null;
        List supportedResolutionsPairs = config.getSupportedResolutions(null);
        if (supportedResolutionsPairs != null) {
            for (Pair pair : supportedResolutionsPairs) {
                if (((Integer)pair.first).intValue() != this.getImageFormat() || pair.second == null) continue;
                supportedResolutions = (Size[])pair.second;
                break;
            }
        }
        Size finalSelectedResolution = suggestedResolution;
        if (supportedResolutions != null) {
            int suggestedSize = suggestedResolution.getWidth() * suggestedResolution.getHeight();
            for (void var11_12 : supportedResolutions) {
                if (Objects.equals(var11_12, suggestedResolution)) break;
                if (var11_12.getWidth() * var11_12.getHeight() >= suggestedSize) continue;
                Logger.d((String)TAG, (String)("Find a higher priority resolution: " + var11_12));
                finalSelectedResolution = var11_12;
                break;
            }
        }
        this.mStreamInfo = VideoCapture.fetchObservableValue(this.getOutput().getStreamInfo(), StreamInfo.STREAM_INFO_ANY_INACTIVE);
        this.mSessionConfigBuilder = this.createPipeline(cameraId, config, finalSelectedResolution);
        this.applyStreamInfoToSessionConfigBuilder(this.mSessionConfigBuilder, this.mStreamInfo);
        this.updateSessionConfig(this.mSessionConfigBuilder.build());
        this.notifyActive();
        return finalSelectedResolution;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setViewPortCropRect(@NonNull Rect viewPortCropRect) {
        super.setViewPortCropRect(viewPortCropRect);
        this.sendTransformationInfoIfReady(this.getAttachedSurfaceResolution());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onDetached() {
        this.clearPipeline();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onStateDetached() {
        Preconditions.checkState((boolean)Threads.isMainThread(), (String)"VideoCapture can only be detached on the main thread.");
        this.setSourceState(VideoOutput.SourceState.INACTIVE);
        this.getOutput().getStreamInfo().removeObserver(this.mStreamInfoObserver);
        if (this.mSurfaceUpdateFuture != null && this.mSurfaceUpdateFuture.cancel(false)) {
            Logger.d((String)TAG, (String)"VideoCapture is detached from the camera. Surface update cancelled.");
        }
    }

    @NonNull
    public String toString() {
        return "VideoCapture:" + this.getName();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public UseCaseConfig<?> getDefaultConfig(boolean applyDefaultConfig, @NonNull UseCaseConfigFactory factory) {
        Config captureConfig = factory.getConfig(UseCaseConfigFactory.CaptureType.VIDEO_CAPTURE, 1);
        if (applyDefaultConfig) {
            captureConfig = Config.mergeConfigs((Config)captureConfig, DEFAULT_CONFIG.getConfig());
        }
        return captureConfig == null ? null : this.getUseCaseConfigBuilder(captureConfig).getUseCaseConfig();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        this.updateSupportedResolutionsByQuality(cameraInfo, builder);
        return builder.getUseCaseConfig();
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config config) {
        return Builder.fromConfig(config);
    }

    private void sendTransformationInfoIfReady(@Nullable Size resolution) {
        CameraInternal cameraInternal = this.getCamera();
        SurfaceRequest surfaceRequest = this.mSurfaceRequest;
        Rect cropRect = this.getCropRect(resolution);
        if (cameraInternal != null && surfaceRequest != null && cropRect != null) {
            surfaceRequest.updateTransformationInfo(SurfaceRequest.TransformationInfo.of((Rect)cropRect, (int)this.getRelativeRotation(cameraInternal), (int)this.getTargetRotationInternal()));
        }
    }

    @Nullable
    private Rect getCropRect(@Nullable Size surfaceResolution) {
        if (this.getViewPortCropRect() != null) {
            return this.getViewPortCropRect();
        }
        if (surfaceResolution != null) {
            return new Rect(0, 0, surfaceResolution.getWidth(), surfaceResolution.getHeight());
        }
        return null;
    }

    @MainThread
    @NonNull
    private SessionConfig.Builder createPipeline(@NonNull String cameraId, @NonNull VideoCaptureConfig<T> config, @NonNull Size resolution) {
        Threads.checkMainThread();
        this.mSurfaceRequest = new SurfaceRequest(resolution, (CameraInternal)Preconditions.checkNotNull((Object)this.getCamera()), false);
        config.getVideoOutput().onSurfaceRequested(this.mSurfaceRequest);
        this.sendTransformationInfoIfReady(resolution);
        this.mDeferrableSurface = this.mSurfaceRequest.getDeferrableSurface();
        this.mDeferrableSurface.setContainerClass(MediaCodec.class);
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config);
        sessionConfigBuilder.addErrorListener((sessionConfig, error) -> this.resetPipeline(cameraId, config, resolution));
        return sessionConfigBuilder;
    }

    @MainThread
    private void clearPipeline() {
        Threads.checkMainThread();
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
            this.mDeferrableSurface = null;
        }
        this.mSurfaceRequest = null;
        this.mStreamInfo = StreamInfo.STREAM_INFO_ANY_INACTIVE;
    }

    @MainThread
    void resetPipeline(@NonNull String cameraId, @NonNull VideoCaptureConfig<T> config, @NonNull Size resolution) {
        this.clearPipeline();
        if (this.isCurrentCamera(cameraId)) {
            this.mSessionConfigBuilder = this.createPipeline(cameraId, config, resolution);
            this.applyStreamInfoToSessionConfigBuilder(this.mSessionConfigBuilder, this.mStreamInfo);
            this.updateSessionConfig(this.mSessionConfigBuilder.build());
            this.notifyReset();
        }
    }

    @Nullable
    private MediaSpec getMediaSpec() {
        return VideoCapture.fetchObservableValue(this.getOutput().getMediaSpec(), null);
    }

    @MainThread
    void applyStreamInfoToSessionConfigBuilder(@NonNull SessionConfig.Builder sessionConfigBuilder, @NonNull StreamInfo streamInfo) {
        boolean isStreamActive;
        boolean isStreamError = streamInfo.getId() == -1;
        boolean bl = isStreamActive = streamInfo.getStreamState() == StreamInfo.StreamState.ACTIVE;
        if (isStreamError && isStreamActive) {
            throw new IllegalStateException("Unexpected stream state, stream is error but active");
        }
        sessionConfigBuilder.clearSurfaces();
        if (!isStreamError) {
            if (isStreamActive) {
                sessionConfigBuilder.addSurface(this.mDeferrableSurface);
            } else {
                sessionConfigBuilder.addNonRepeatingSurface(this.mDeferrableSurface);
            }
        }
        this.setupSurfaceUpdateNotifier(sessionConfigBuilder, isStreamActive);
    }

    @MainThread
    private void setupSurfaceUpdateNotifier(final @NonNull SessionConfig.Builder sessionConfigBuilder, final boolean isStreamActive) {
        if (this.mSurfaceUpdateFuture != null && this.mSurfaceUpdateFuture.cancel(false)) {
            Logger.d((String)TAG, (String)"A newer surface update is requested. Previous surface update cancelled.");
        }
        final ListenableFuture surfaceUpdateFuture = this.mSurfaceUpdateFuture = CallbackToFutureAdapter.getFuture(completer -> {
            sessionConfigBuilder.addTag(SURFACE_UPDATE_KEY, (Object)completer.hashCode());
            final AtomicBoolean surfaceUpdateComplete = new AtomicBoolean(false);
            CameraCaptureCallback cameraCaptureCallback = new CameraCaptureCallback(){

                public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
                    Object tag;
                    super.onCaptureCompleted(cameraCaptureResult);
                    if (!surfaceUpdateComplete.get() && (tag = cameraCaptureResult.getTagBundle().getTag(VideoCapture.SURFACE_UPDATE_KEY)) != null && ((Integer)tag).intValue() == completer.hashCode() && completer.set(null) && !surfaceUpdateComplete.getAndSet(true)) {
                        CameraXExecutors.mainThreadExecutor().execute(() -> sessionConfigBuilder.removeCameraCaptureCallback((CameraCaptureCallback)this));
                    }
                }
            };
            completer.addCancellationListener(() -> {
                Preconditions.checkState((boolean)Threads.isMainThread(), (String)"Surface update cancellation should only occur on main thread.");
                surfaceUpdateComplete.set(true);
                sessionConfigBuilder.removeCameraCaptureCallback(cameraCaptureCallback);
            }, CameraXExecutors.directExecutor());
            sessionConfigBuilder.addRepeatingCameraCaptureCallback(cameraCaptureCallback);
            return String.format("%s[0x%x]", SURFACE_UPDATE_KEY, completer.hashCode());
        });
        Futures.addCallback((ListenableFuture)surfaceUpdateFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                if (surfaceUpdateFuture == VideoCapture.this.mSurfaceUpdateFuture && VideoCapture.this.mSourceState != VideoOutput.SourceState.INACTIVE) {
                    VideoCapture.this.setSourceState(isStreamActive ? VideoOutput.SourceState.ACTIVE_STREAMING : VideoOutput.SourceState.ACTIVE_NON_STREAMING);
                }
            }

            public void onFailure(Throwable t) {
                if (!(t instanceof CancellationException)) {
                    Logger.e((String)VideoCapture.TAG, (String)"Surface update completed with unexpected exception", (Throwable)t);
                }
            }
        }, (Executor)CameraXExecutors.mainThreadExecutor());
    }

    private void updateSupportedResolutionsByQuality(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) throws IllegalArgumentException {
        MediaSpec mediaSpec = this.getMediaSpec();
        Preconditions.checkArgument((mediaSpec != null ? 1 : 0) != 0, (Object)"Unable to update target resolution by null MediaSpec.");
        List<Quality> supportedQualities = QualitySelector.getSupportedQualities((CameraInfo)cameraInfo);
        if (supportedQualities.isEmpty()) {
            Logger.w((String)TAG, (String)"Can't find any supported quality on the device.");
            return;
        }
        QualitySelector qualitySelector = mediaSpec.getVideoSpec().getQualitySelector();
        List<Quality> selectedQualities = qualitySelector.getPrioritizedQualities((CameraInfo)cameraInfo);
        Logger.d((String)TAG, (String)("Found selectedQualities " + selectedQualities + " by " + qualitySelector));
        if (selectedQualities.isEmpty()) {
            throw new IllegalArgumentException("Unable to find supported quality by QualitySelector");
        }
        List<Size> supportedResolutions = new ArrayList<Size>();
        for (Quality selectedQuality : selectedQualities) {
            supportedResolutions.add(QualitySelector.getResolution((CameraInfo)cameraInfo, selectedQuality));
        }
        Logger.d((String)TAG, (String)("Set supported resolutions = " + supportedResolutions));
        supportedResolutions = VideoCapture.filterOutResolutions(supportedResolutions);
        Logger.d((String)TAG, (String)("supportedResolutions after filter out " + supportedResolutions));
        Preconditions.checkState((!selectedQualities.isEmpty() ? 1 : 0) != 0, (String)"No supportedResolutions after filter out");
        builder.getMutableConfig().insertOption(ImageOutputConfig.OPTION_SUPPORTED_RESOLUTIONS, Collections.singletonList(Pair.create((Object)this.getImageFormat(), (Object)supportedResolutions.toArray(new Size[0]))));
    }

    @VisibleForTesting
    @NonNull
    static List<Size> filterOutResolutions(@NonNull List<Size> prioritizedResolutions) {
        ArrayList<Size> ret = new ArrayList<Size>(prioritizedResolutions.size());
        int minArea = Integer.MAX_VALUE;
        for (Size resolution : prioritizedResolutions) {
            int area = VideoCapture.getArea(resolution);
            if (area >= minArea) continue;
            minArea = area;
            ret.add(resolution);
        }
        return ret;
    }

    private static int getArea(@NonNull Size size) {
        return size.getWidth() * size.getHeight();
    }

    @Nullable
    private static <T> T fetchObservableValue(@NonNull Observable<T> observable, @Nullable T valueIfMissing) {
        ListenableFuture future = observable.fetchData();
        if (!future.isDone()) {
            return valueIfMissing;
        }
        try {
            return (T)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @MainThread
    void setSourceState(@NonNull VideoOutput.SourceState newState) {
        VideoOutput.SourceState oldState = this.mSourceState;
        if (newState != oldState) {
            this.mSourceState = newState;
            this.getOutput().onSourceStateChanged(newState);
        }
    }

    @RequiresApi(value=21)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Builder<T extends VideoOutput>
    implements UseCaseConfig.Builder<VideoCapture<T>, VideoCaptureConfig<T>, Builder<T>>,
    ImageOutputConfig.Builder<Builder<T>>,
    ThreadConfig.Builder<Builder<T>> {
        private final MutableOptionsBundle mMutableConfig;

        Builder(@NonNull T videoOutput) {
            this(Builder.createInitialBundle(videoOutput));
        }

        private Builder(@NonNull MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            if (!this.mMutableConfig.containsOption(VideoCaptureConfig.OPTION_VIDEO_OUTPUT)) {
                throw new IllegalArgumentException("VideoOutput is required");
            }
            Class oldConfigClass = (Class)mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(VideoCapture.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass(VideoCapture.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        static Builder<? extends VideoOutput> fromConfig(@NonNull Config configuration) {
            return new Builder(MutableOptionsBundle.from((Config)configuration));
        }

        @NonNull
        public static <T extends VideoOutput> Builder<T> fromConfig(@NonNull VideoCaptureConfig<T> configuration) {
            return new Builder<T>(MutableOptionsBundle.from(configuration));
        }

        @NonNull
        private static <T extends VideoOutput> MutableOptionsBundle createInitialBundle(@NonNull T videoOutput) {
            MutableOptionsBundle bundle = MutableOptionsBundle.create();
            bundle.insertOption(VideoCaptureConfig.OPTION_VIDEO_OUTPUT, videoOutput);
            return bundle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public VideoCaptureConfig<T> getUseCaseConfig() {
            return new VideoCaptureConfig(OptionsBundle.from((Config)this.mMutableConfig));
        }

        @NonNull
        public VideoCapture<T> build() {
            return new VideoCapture(this.getUseCaseConfig());
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setTargetClass(@NonNull Class<VideoCapture<T>> targetClass) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(TargetConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @NonNull
        public Builder<T> setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_NAME, (Object)targetName);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setTargetAspectRatio(int aspectRatio) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO, (Object)aspectRatio);
            return this;
        }

        @NonNull
        public Builder<T> setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ROTATION, (Object)rotation);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setTargetResolution(@NonNull Size resolution) {
            throw new UnsupportedOperationException("setTargetResolution is not supported.");
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, (Object)resolution);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_MAX_RESOLUTION, (Object)resolution);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setBackgroundExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(ThreadConfig.OPTION_BACKGROUND_EXECUTOR, (Object)executor);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_SESSION_CONFIG, (Object)sessionConfig);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_CAPTURE_CONFIG, (Object)captureConfig);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SESSION_CONFIG_UNPACKER, (Object)optionUnpacker);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_CONFIG_UNPACKER, (Object)optionUnpacker);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, (Object)priority);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setCameraSelector(@NonNull CameraSelector cameraSelector) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAMERA_SELECTOR, (Object)cameraSelector);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setUseCaseEventCallback(@NonNull UseCase.EventCallback useCaseEventCallback) {
            this.getMutableConfig().insertOption(UseCaseEventConfig.OPTION_USE_CASE_EVENT_CALLBACK, (Object)useCaseEventCallback);
            return this;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<VideoCaptureConfig<?>> {
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 5;
        private static final VideoOutput DEFAULT_VIDEO_OUTPUT = SurfaceRequest::willNotProvideSurface;
        private static final VideoCaptureConfig<?> DEFAULT_CONFIG;

        @NonNull
        public VideoCaptureConfig<?> getConfig() {
            return DEFAULT_CONFIG;
        }

        static {
            Object builder = new Builder<VideoOutput>(DEFAULT_VIDEO_OUTPUT).setSurfaceOccupancyPriority(5);
            DEFAULT_CONFIG = ((Builder)builder).getUseCaseConfig();
        }
    }
}

