/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CamcorderProfileProvider;
import androidx.camera.core.impl.CamcorderProfileProxy;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.video.Quality;
import androidx.camera.video.internal.compat.quirk.DeviceQuirks;
import androidx.camera.video.internal.compat.quirk.ExcludeStretchedVideoQualityQuirk;
import androidx.camera.video.internal.compat.quirk.ReportedVideoQualityNotSupportedQuirk;
import androidx.camera.video.internal.compat.quirk.VideoEncoderCrashQuirk;
import androidx.camera.video.internal.compat.quirk.VideoQualityQuirk;
import androidx.core.util.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@RequiresApi(value=21)
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class VideoCapabilities {
    private static final String TAG = "VideoCapabilities";
    private final Map<Quality, CamcorderProfileProxy> mSupportedProfileMap = new LinkedHashMap<Quality, CamcorderProfileProxy>();
    private final TreeMap<Size, Quality> mAreaSortedSizeToQualityMap = new TreeMap(new CompareSizesByArea());
    private final CamcorderProfileProxy mHighestProfile;
    private final CamcorderProfileProxy mLowestProfile;

    VideoCapabilities(@NonNull CameraInfoInternal cameraInfoInternal) {
        CamcorderProfileProvider camcorderProfileProvider = cameraInfoInternal.getCamcorderProfileProvider();
        for (Quality quality : Quality.getSortedQualities()) {
            Preconditions.checkState((boolean)(quality instanceof Quality.ConstantQuality), (String)"Currently only support ConstantQuality");
            int qualityValue = ((Quality.ConstantQuality)quality).getValue();
            if (!camcorderProfileProvider.hasProfile(qualityValue) || !this.isDeviceValidQuality(quality)) continue;
            CamcorderProfileProxy profile = (CamcorderProfileProxy)Preconditions.checkNotNull((Object)camcorderProfileProvider.get(qualityValue));
            Size profileSize = new Size(profile.getVideoFrameWidth(), profile.getVideoFrameHeight());
            Logger.d((String)TAG, (String)("profile = " + profile));
            this.mSupportedProfileMap.put(quality, profile);
            this.mAreaSortedSizeToQualityMap.put(profileSize, quality);
        }
        if (this.mSupportedProfileMap.isEmpty()) {
            Logger.e((String)TAG, (String)"No supported CamcorderProfile");
            this.mLowestProfile = null;
            this.mHighestProfile = null;
        } else {
            ArrayDeque<CamcorderProfileProxy> profileQueue = new ArrayDeque<CamcorderProfileProxy>(this.mSupportedProfileMap.values());
            this.mHighestProfile = (CamcorderProfileProxy)profileQueue.peekFirst();
            this.mLowestProfile = (CamcorderProfileProxy)profileQueue.peekLast();
        }
    }

    @NonNull
    public static VideoCapabilities from(@NonNull CameraInfo cameraInfo) {
        return new VideoCapabilities((CameraInfoInternal)cameraInfo);
    }

    @NonNull
    public List<Quality> getSupportedQualities() {
        return new ArrayList<Quality>(this.mSupportedProfileMap.keySet());
    }

    public boolean isQualitySupported(@NonNull Quality quality) {
        VideoCapabilities.checkQualityConstantsOrThrow(quality);
        return this.getProfile(quality) != null;
    }

    @Nullable
    public CamcorderProfileProxy getProfile(@NonNull Quality quality) {
        VideoCapabilities.checkQualityConstantsOrThrow(quality);
        if (quality == Quality.HIGHEST) {
            return this.mHighestProfile;
        }
        if (quality == Quality.LOWEST) {
            return this.mLowestProfile;
        }
        return this.mSupportedProfileMap.get(quality);
    }

    @NonNull
    public Quality findHighestSupportedQualityFor(@NonNull Size size) {
        Map.Entry<Size, Quality> ceilEntry = this.mAreaSortedSizeToQualityMap.ceilingEntry(size);
        if (ceilEntry != null) {
            return ceilEntry.getValue();
        }
        Map.Entry<Size, Quality> floorEntry = this.mAreaSortedSizeToQualityMap.floorEntry(size);
        if (floorEntry != null) {
            return floorEntry.getValue();
        }
        return Quality.NONE;
    }

    private static void checkQualityConstantsOrThrow(@NonNull Quality quality) {
        Preconditions.checkArgument((boolean)Quality.containsQuality(quality), (Object)("Unknown quality: " + quality));
    }

    private boolean isDeviceValidQuality(@NonNull Quality quality) {
        List<Class> quirkList = Arrays.asList(ExcludeStretchedVideoQualityQuirk.class, ReportedVideoQualityNotSupportedQuirk.class, VideoEncoderCrashQuirk.class);
        for (Class quirkClass : quirkList) {
            VideoQualityQuirk quirk = (VideoQualityQuirk)DeviceQuirks.get(quirkClass);
            if (quirk == null || !quirk.isProblematicVideoQuality(quality)) continue;
            return false;
        }
        return true;
    }
}

