/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.video.AutoValue_Quality_ConstantQuality;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@RequiresApi(value=21)
public class Quality {
    public static final Quality SD = ConstantQuality.of(4, "SD");
    public static final Quality HD = ConstantQuality.of(5, "HD");
    public static final Quality FHD = ConstantQuality.of(6, "FHD");
    public static final Quality UHD = ConstantQuality.of(8, "UHD");
    public static final Quality LOWEST = ConstantQuality.of(0, "LOWEST");
    public static final Quality HIGHEST = ConstantQuality.of(1, "HIGHEST");
    static final Quality NONE = ConstantQuality.of(-1, "NONE");
    private static final Set<Quality> QUALITIES = new HashSet<Quality>(Arrays.asList(LOWEST, HIGHEST, SD, HD, FHD, UHD));
    private static final List<Quality> QUALITIES_ORDER_BY_SIZE = Arrays.asList(UHD, FHD, HD, SD);

    private Quality() {
    }

    static boolean containsQuality(@NonNull Quality quality) {
        return QUALITIES.contains(quality);
    }

    @NonNull
    static List<Quality> getSortedQualities() {
        return new ArrayList<Quality>(QUALITIES_ORDER_BY_SIZE);
    }

    @AutoValue
    static abstract class ConstantQuality
    extends Quality {
        ConstantQuality() {
        }

        @NonNull
        static ConstantQuality of(int value, @NonNull String name) {
            return new AutoValue_Quality_ConstantQuality(value, name);
        }

        abstract int getValue();

        @NonNull
        abstract String getName();
    }
}

