/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.os.ParcelFileDescriptor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.video.AutoValue_FileDescriptorOutputOptions_FileDescriptorOutputOptionsInternal;
import androidx.camera.video.OutputOptions;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;

@RequiresApi(value=21)
public final class FileDescriptorOutputOptions
extends OutputOptions {
    private final FileDescriptorOutputOptionsInternal mFileDescriptorOutputOptionsInternal;

    FileDescriptorOutputOptions(@NonNull FileDescriptorOutputOptionsInternal fileDescriptorOutputOptionsInternal) {
        Preconditions.checkNotNull((Object)fileDescriptorOutputOptionsInternal, (Object)"FileDescriptorOutputOptionsInternal can't be null.");
        this.mFileDescriptorOutputOptionsInternal = fileDescriptorOutputOptionsInternal;
    }

    @NonNull
    public ParcelFileDescriptor getParcelFileDescriptor() {
        return this.mFileDescriptorOutputOptionsInternal.getParcelFileDescriptor();
    }

    @Override
    public long getFileSizeLimit() {
        return this.mFileDescriptorOutputOptionsInternal.getFileSizeLimit();
    }

    @NonNull
    public String toString() {
        return this.mFileDescriptorOutputOptionsInternal.toString().replaceFirst("FileDescriptorOutputOptionsInternal", "FileDescriptorOutputOptions");
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileDescriptorOutputOptions)) {
            return false;
        }
        return this.mFileDescriptorOutputOptionsInternal.equals(((FileDescriptorOutputOptions)o).mFileDescriptorOutputOptionsInternal);
    }

    public int hashCode() {
        return this.mFileDescriptorOutputOptionsInternal.hashCode();
    }

    @AutoValue
    static abstract class FileDescriptorOutputOptionsInternal {
        FileDescriptorOutputOptionsInternal() {
        }

        @NonNull
        abstract ParcelFileDescriptor getParcelFileDescriptor();

        abstract long getFileSizeLimit();

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            @NonNull
            abstract Builder setParcelFileDescriptor(@NonNull ParcelFileDescriptor var1);

            @NonNull
            abstract Builder setFileSizeLimit(long var1);

            @NonNull
            abstract FileDescriptorOutputOptionsInternal build();
        }
    }

    @RequiresApi(value=21)
    public static final class Builder
    implements OutputOptions.Builder<FileDescriptorOutputOptions, Builder> {
        private final FileDescriptorOutputOptionsInternal.Builder mInternalBuilder = new AutoValue_FileDescriptorOutputOptions_FileDescriptorOutputOptionsInternal.Builder().setFileSizeLimit(0L);

        public Builder(@NonNull ParcelFileDescriptor fileDescriptor) {
            Preconditions.checkNotNull((Object)fileDescriptor, (Object)"File descriptor can't be null.");
            this.mInternalBuilder.setParcelFileDescriptor(fileDescriptor);
        }

        @Override
        @NonNull
        public Builder setFileSizeLimit(long fileSizeLimitBytes) {
            this.mInternalBuilder.setFileSizeLimit(fileSizeLimitBytes);
            return this;
        }

        @Override
        @NonNull
        public FileDescriptorOutputOptions build() {
            return new FileDescriptorOutputOptions(this.mInternalBuilder.build());
        }
    }
}

