/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.video.AutoValue_AudioStats;
import com.google.auto.value.AutoValue;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@RequiresApi(value=21)
@AutoValue
public abstract class AudioStats {
    public static final int AUDIO_STATE_ACTIVE = 0;
    public static final int AUDIO_STATE_DISABLED = 1;
    public static final int AUDIO_STATE_SOURCE_SILENCED = 2;
    public static final int AUDIO_STATE_ENCODER_ERROR = 3;
    private static final Set<Integer> ERROR_STATES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(2, 3)));

    AudioStats() {
    }

    @NonNull
    static AudioStats of(int state, @Nullable Throwable errorCause) {
        return new AutoValue_AudioStats(state, errorCause);
    }

    public boolean hasAudio() {
        return this.getAudioState() == 0;
    }

    public boolean hasError() {
        return ERROR_STATES.contains(this.getAudioState());
    }

    public abstract int getAudioState();

    @Nullable
    public abstract Throwable getErrorCause();

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface AudioState {
    }
}

