/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.graphics.drawable.AnimatedStateListDrawableCompat;
import androidx.appcompat.resources.R;
import androidx.appcompat.widget.DrawableUtils;
import androidx.appcompat.widget.TintInfo;
import androidx.appcompat.widget.VectorEnabledTintResources;
import androidx.collection.LongSparseArray;
import androidx.collection.LruCache;
import androidx.collection.SimpleArrayMap;
import androidx.collection.SparseArrayCompat;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public final class ResourceManagerInternal {
    private static final String TAG = "ResourceManagerInternal";
    private static final boolean DEBUG = false;
    private static final PorterDuff.Mode DEFAULT_MODE = PorterDuff.Mode.SRC_IN;
    private static final String SKIP_DRAWABLE_TAG = "appcompat_skip_skip";
    private static final String PLATFORM_VD_CLAZZ = "android.graphics.drawable.VectorDrawable";
    private static ResourceManagerInternal INSTANCE;
    private static final ColorFilterLruCache COLOR_FILTER_CACHE;
    private WeakHashMap<Context, SparseArrayCompat<ColorStateList>> mTintLists;
    private SimpleArrayMap<String, InflateDelegate> mDelegates;
    private SparseArrayCompat<String> mKnownDrawableIdTags;
    private final WeakHashMap<Context, LongSparseArray<WeakReference<Drawable.ConstantState>>> mDrawableCaches = new WeakHashMap(0);
    private TypedValue mTypedValue;
    private boolean mHasCheckedVectorDrawableSetup;
    private ResourceManagerHooks mHooks;

    public static synchronized ResourceManagerInternal get() {
        if (INSTANCE == null) {
            INSTANCE = new ResourceManagerInternal();
            ResourceManagerInternal.installDefaultInflateDelegates(INSTANCE);
        }
        return INSTANCE;
    }

    private static void installDefaultInflateDelegates(@NonNull ResourceManagerInternal manager) {
        if (Build.VERSION.SDK_INT < 24) {
            manager.addDelegate("vector", new VdcInflateDelegate());
            manager.addDelegate("animated-vector", new AvdcInflateDelegate());
            manager.addDelegate("animated-selector", new AsldcInflateDelegate());
            manager.addDelegate("drawable", new DrawableDelegate());
        }
    }

    public synchronized void setHooks(ResourceManagerHooks hooks) {
        this.mHooks = hooks;
    }

    public synchronized Drawable getDrawable(@NonNull Context context, @DrawableRes int resId) {
        return this.getDrawable(context, resId, false);
    }

    synchronized Drawable getDrawable(@NonNull Context context, @DrawableRes int resId, boolean failIfNotKnown) {
        this.checkVectorDrawableSetup(context);
        Drawable drawable2 = this.loadDrawableFromDelegates(context, resId);
        if (drawable2 == null) {
            drawable2 = this.createDrawableIfNeeded(context, resId);
        }
        if (drawable2 == null) {
            drawable2 = ContextCompat.getDrawable((Context)context, (int)resId);
        }
        if (drawable2 != null) {
            drawable2 = this.tintDrawable(context, resId, failIfNotKnown, drawable2);
        }
        if (drawable2 != null) {
            DrawableUtils.fixDrawable(drawable2);
        }
        return drawable2;
    }

    public synchronized void onConfigurationChanged(@NonNull Context context) {
        LongSparseArray<WeakReference<Drawable.ConstantState>> cache = this.mDrawableCaches.get(context);
        if (cache != null) {
            cache.clear();
        }
    }

    private static long createCacheKey(TypedValue tv) {
        return (long)tv.assetCookie << 32 | (long)tv.data;
    }

    private Drawable createDrawableIfNeeded(@NonNull Context context, @DrawableRes int resId) {
        if (this.mTypedValue == null) {
            this.mTypedValue = new TypedValue();
        }
        TypedValue tv = this.mTypedValue;
        context.getResources().getValue(resId, tv, true);
        long key = ResourceManagerInternal.createCacheKey(tv);
        Drawable dr = this.getCachedDrawable(context, key);
        if (dr != null) {
            return dr;
        }
        Drawable drawable2 = dr = this.mHooks == null ? null : this.mHooks.createDrawableFor(this, context, resId);
        if (dr != null) {
            dr.setChangingConfigurations(tv.changingConfigurations);
            this.addDrawableToCache(context, key, dr);
        }
        return dr;
    }

    private Drawable tintDrawable(@NonNull Context context, @DrawableRes int resId, boolean failIfNotKnown, @NonNull Drawable drawable2) {
        boolean tinted;
        ColorStateList tintList = this.getTintList(context, resId);
        if (tintList != null) {
            if (DrawableUtils.canSafelyMutateDrawable(drawable2)) {
                drawable2 = drawable2.mutate();
            }
            drawable2 = DrawableCompat.wrap((Drawable)drawable2);
            DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)tintList);
            PorterDuff.Mode tintMode = this.getTintMode(resId);
            if (tintMode != null) {
                DrawableCompat.setTintMode((Drawable)drawable2, (PorterDuff.Mode)tintMode);
            }
        } else if (!(this.mHooks != null && this.mHooks.tintDrawable(context, resId, drawable2) || (tinted = this.tintDrawableUsingColorFilter(context, resId, drawable2)) || !failIfNotKnown)) {
            drawable2 = null;
        }
        return drawable2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable loadDrawableFromDelegates(@NonNull Context context, @DrawableRes int resId) {
        if (this.mDelegates != null && !this.mDelegates.isEmpty()) {
            if (this.mKnownDrawableIdTags != null) {
                String cachedTagName = (String)this.mKnownDrawableIdTags.get(resId);
                if (SKIP_DRAWABLE_TAG.equals(cachedTagName) || cachedTagName != null && this.mDelegates.get((Object)cachedTagName) == null) {
                    return null;
                }
            } else {
                this.mKnownDrawableIdTags = new SparseArrayCompat();
            }
            if (this.mTypedValue == null) {
                this.mTypedValue = new TypedValue();
            }
            TypedValue tv = this.mTypedValue;
            Resources res = context.getResources();
            res.getValue(resId, tv, true);
            long key = ResourceManagerInternal.createCacheKey(tv);
            Drawable dr = this.getCachedDrawable(context, key);
            if (dr != null) {
                return dr;
            }
            if (tv.string != null && tv.string.toString().endsWith(".xml")) {
                try {
                    int type;
                    XmlResourceParser parser = res.getXml(resId);
                    AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
                    while ((type = parser.next()) != 2 && type != 1) {
                    }
                    if (type != 2) {
                        throw new XmlPullParserException("No start tag found");
                    }
                    String tagName = parser.getName();
                    this.mKnownDrawableIdTags.append(resId, (Object)tagName);
                    InflateDelegate delegate = (InflateDelegate)this.mDelegates.get((Object)tagName);
                    if (delegate != null) {
                        dr = delegate.createFromXmlInner(context, (XmlPullParser)parser, attrs, context.getTheme());
                    }
                    if (dr != null) {
                        dr.setChangingConfigurations(tv.changingConfigurations);
                        if (!this.addDrawableToCache(context, key, dr)) {
                            // empty if block
                        }
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Exception while inflating drawable", (Throwable)e);
                }
            }
            if (dr == null) {
                this.mKnownDrawableIdTags.append(resId, (Object)SKIP_DRAWABLE_TAG);
            }
            return dr;
        }
        return null;
    }

    private synchronized Drawable getCachedDrawable(@NonNull Context context, long key) {
        LongSparseArray<WeakReference<Drawable.ConstantState>> cache = this.mDrawableCaches.get(context);
        if (cache == null) {
            return null;
        }
        WeakReference wr = (WeakReference)cache.get(key);
        if (wr != null) {
            Drawable.ConstantState entry = (Drawable.ConstantState)wr.get();
            if (entry != null) {
                return entry.newDrawable(context.getResources());
            }
            cache.remove(key);
        }
        return null;
    }

    private synchronized boolean addDrawableToCache(@NonNull Context context, long key, @NonNull Drawable drawable2) {
        Drawable.ConstantState cs = drawable2.getConstantState();
        if (cs != null) {
            LongSparseArray cache = this.mDrawableCaches.get(context);
            if (cache == null) {
                cache = new LongSparseArray();
                this.mDrawableCaches.put(context, (LongSparseArray<WeakReference<Drawable.ConstantState>>)cache);
            }
            cache.put(key, new WeakReference<Drawable.ConstantState>(cs));
            return true;
        }
        return false;
    }

    synchronized Drawable onDrawableLoadedFromResources(@NonNull Context context, @NonNull VectorEnabledTintResources resources, @DrawableRes int resId) {
        Drawable drawable2 = this.loadDrawableFromDelegates(context, resId);
        if (drawable2 == null) {
            drawable2 = resources.getDrawableCanonical(resId);
        }
        if (drawable2 != null) {
            return this.tintDrawable(context, resId, false, drawable2);
        }
        return null;
    }

    boolean tintDrawableUsingColorFilter(@NonNull Context context, @DrawableRes int resId, @NonNull Drawable drawable2) {
        return this.mHooks != null && this.mHooks.tintDrawableUsingColorFilter(context, resId, drawable2);
    }

    private void addDelegate(@NonNull String tagName, @NonNull InflateDelegate delegate) {
        if (this.mDelegates == null) {
            this.mDelegates = new SimpleArrayMap();
        }
        this.mDelegates.put((Object)tagName, (Object)delegate);
    }

    PorterDuff.Mode getTintMode(int resId) {
        return this.mHooks == null ? null : this.mHooks.getTintModeForDrawableRes(resId);
    }

    synchronized ColorStateList getTintList(@NonNull Context context, @DrawableRes int resId) {
        ColorStateList tint = this.getTintListFromCache(context, resId);
        if (tint == null) {
            ColorStateList colorStateList = tint = this.mHooks == null ? null : this.mHooks.getTintListForDrawableRes(context, resId);
            if (tint != null) {
                this.addTintListToCache(context, resId, tint);
            }
        }
        return tint;
    }

    private ColorStateList getTintListFromCache(@NonNull Context context, @DrawableRes int resId) {
        if (this.mTintLists != null) {
            SparseArrayCompat<ColorStateList> tints = this.mTintLists.get(context);
            return tints != null ? (ColorStateList)tints.get(resId) : null;
        }
        return null;
    }

    private void addTintListToCache(@NonNull Context context, @DrawableRes int resId, @NonNull ColorStateList tintList) {
        SparseArrayCompat themeTints;
        if (this.mTintLists == null) {
            this.mTintLists = new WeakHashMap();
        }
        if ((themeTints = this.mTintLists.get(context)) == null) {
            themeTints = new SparseArrayCompat();
            this.mTintLists.put(context, (SparseArrayCompat<ColorStateList>)themeTints);
        }
        themeTints.append(resId, (Object)tintList);
    }

    static void tintDrawable(Drawable drawable2, TintInfo tint, int[] state) {
        if (DrawableUtils.canSafelyMutateDrawable(drawable2) && drawable2.mutate() != drawable2) {
            Log.d((String)TAG, (String)"Mutated drawable is not the same instance as the input.");
            return;
        }
        if (tint.mHasTintList || tint.mHasTintMode) {
            drawable2.setColorFilter((ColorFilter)ResourceManagerInternal.createTintFilter(tint.mHasTintList ? tint.mTintList : null, tint.mHasTintMode ? tint.mTintMode : DEFAULT_MODE, state));
        } else {
            drawable2.clearColorFilter();
        }
        if (Build.VERSION.SDK_INT <= 23) {
            drawable2.invalidateSelf();
        }
    }

    private static PorterDuffColorFilter createTintFilter(ColorStateList tint, PorterDuff.Mode tintMode, int[] state) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color = tint.getColorForState(state, 0);
        return ResourceManagerInternal.getPorterDuffColorFilter(color, tintMode);
    }

    public static synchronized PorterDuffColorFilter getPorterDuffColorFilter(int color, PorterDuff.Mode mode) {
        PorterDuffColorFilter filter = COLOR_FILTER_CACHE.get(color, mode);
        if (filter == null) {
            filter = new PorterDuffColorFilter(color, mode);
            COLOR_FILTER_CACHE.put(color, mode, filter);
        }
        return filter;
    }

    private void checkVectorDrawableSetup(@NonNull Context context) {
        if (this.mHasCheckedVectorDrawableSetup) {
            return;
        }
        this.mHasCheckedVectorDrawableSetup = true;
        Drawable d = this.getDrawable(context, R.drawable.abc_vector_test);
        if (d == null || !ResourceManagerInternal.isVectorDrawable(d)) {
            this.mHasCheckedVectorDrawableSetup = false;
            throw new IllegalStateException("This app has been built with an incorrect configuration. Please configure your build for VectorDrawableCompat.");
        }
    }

    private static boolean isVectorDrawable(@NonNull Drawable d) {
        return d instanceof VectorDrawableCompat || PLATFORM_VD_CLAZZ.equals(d.getClass().getName());
    }

    static {
        COLOR_FILTER_CACHE = new ColorFilterLruCache(6);
    }

    static class DrawableDelegate
    implements InflateDelegate {
        DrawableDelegate() {
        }

        @Override
        public Drawable createFromXmlInner(@NonNull Context context, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) {
            String className = attrs.getClassAttribute();
            if (className != null) {
                try {
                    Class<Drawable> drawableClass = DrawableDelegate.class.getClassLoader().loadClass(className).asSubclass(Drawable.class);
                    Drawable drawable2 = drawableClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (Build.VERSION.SDK_INT >= 21) {
                        drawable2.inflate(context.getResources(), parser, attrs, theme);
                    } else {
                        drawable2.inflate(context.getResources(), parser, attrs);
                    }
                    return drawable2;
                }
                catch (Exception e) {
                    Log.e((String)"DrawableDelegate", (String)"Exception while inflating <drawable>", (Throwable)e);
                    return null;
                }
            }
            return null;
        }
    }

    static class AsldcInflateDelegate
    implements InflateDelegate {
        AsldcInflateDelegate() {
        }

        @Override
        public Drawable createFromXmlInner(@NonNull Context context, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) {
            try {
                return AnimatedStateListDrawableCompat.createFromXmlInner(context, context.getResources(), parser, attrs, theme);
            }
            catch (Exception e) {
                Log.e((String)"AsldcInflateDelegate", (String)"Exception while inflating <animated-selector>", (Throwable)e);
                return null;
            }
        }
    }

    private static class AvdcInflateDelegate
    implements InflateDelegate {
        AvdcInflateDelegate() {
        }

        @Override
        public Drawable createFromXmlInner(@NonNull Context context, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) {
            try {
                return AnimatedVectorDrawableCompat.createFromXmlInner((Context)context, (Resources)context.getResources(), (XmlPullParser)parser, (AttributeSet)attrs, (Resources.Theme)theme);
            }
            catch (Exception e) {
                Log.e((String)"AvdcInflateDelegate", (String)"Exception while inflating <animated-vector>", (Throwable)e);
                return null;
            }
        }
    }

    private static class VdcInflateDelegate
    implements InflateDelegate {
        VdcInflateDelegate() {
        }

        @Override
        public Drawable createFromXmlInner(@NonNull Context context, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) {
            try {
                return VectorDrawableCompat.createFromXmlInner((Resources)context.getResources(), (XmlPullParser)parser, (AttributeSet)attrs, (Resources.Theme)theme);
            }
            catch (Exception e) {
                Log.e((String)"VdcInflateDelegate", (String)"Exception while inflating <vector>", (Throwable)e);
                return null;
            }
        }
    }

    private static class ColorFilterLruCache
    extends LruCache<Integer, PorterDuffColorFilter> {
        public ColorFilterLruCache(int maxSize) {
            super(maxSize);
        }

        PorterDuffColorFilter get(int color, PorterDuff.Mode mode) {
            return (PorterDuffColorFilter)this.get(ColorFilterLruCache.generateCacheKey(color, mode));
        }

        PorterDuffColorFilter put(int color, PorterDuff.Mode mode, PorterDuffColorFilter filter) {
            return (PorterDuffColorFilter)this.put(ColorFilterLruCache.generateCacheKey(color, mode), filter);
        }

        private static int generateCacheKey(int color, PorterDuff.Mode mode) {
            int hashCode = 1;
            hashCode = 31 * hashCode + color;
            hashCode = 31 * hashCode + mode.hashCode();
            return hashCode;
        }
    }

    private static interface InflateDelegate {
        public Drawable createFromXmlInner(@NonNull Context var1, @NonNull XmlPullParser var2, @NonNull AttributeSet var3, @Nullable Resources.Theme var4);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static interface ResourceManagerHooks {
        @Nullable
        public Drawable createDrawableFor(@NonNull ResourceManagerInternal var1, @NonNull Context var2, @DrawableRes int var3);

        public boolean tintDrawable(@NonNull Context var1, @DrawableRes int var2, @NonNull Drawable var3);

        @Nullable
        public ColorStateList getTintListForDrawableRes(@NonNull Context var1, @DrawableRes int var2);

        public boolean tintDrawableUsingColorFilter(@NonNull Context var1, @DrawableRes int var2, @NonNull Drawable var3);

        @Nullable
        public PorterDuff.Mode getTintModeForDrawableRes(int var1);
    }
}

