/*
 * Decompiled with CFR 0.152.
 */
package androidx.annotation.experimental.lint;

import androidx.annotation.experimental.lint.AnnotationRetentionDetectorKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.lang.Language;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\u000e"}, d2={"Landroidx/annotation/experimental/lint/AnnotationRetentionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UAnnotation;", "AnnotationChecker", "Companion", "annotation-experimental-lint"})
public final class AnnotationRetentionDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ISSUE_KOTLIN_USAGE = Issue.Companion.create("WrongRequiresOptIn", "Experimental annotations defined in Kotlin must use kotlin.RequiresOptIn", "\n            Experimental features defined in Kotlin source code must be annotated with the Kotlin\n            `@RequiresOptIn` annotation. Using `androidx.annotation.RequiresOptIn` will prevent the\n            Kotlin compiler from enforcing its opt-in policies.\n            ", Category.CORRECTNESS, 4, Severity.ERROR, new Implementation(AnnotationRetentionDetector.class, Scope.JAVA_FILE_SCOPE));
    @NotNull
    private static final Issue ISSUE_RETENTION = Issue.Companion.create("ExperimentalAnnotationRetention", "Experimental annotation with incorrect retention", "Experimental annotations defined in Java source should use default (`CLASS`) retention, while Kotlin-sourced annotations should use `BINARY` retention.", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(AnnotationRetentionDetector.class, Scope.JAVA_FILE_SCOPE));
    @NotNull
    private static final List<Issue> ISSUES;

    @NotNull
    public List<Class<UAnnotation>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UAnnotation.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new AnnotationChecker(context);
    }

    static {
        Object[] objectArray = new Issue[]{ISSUE_RETENTION, ISSUE_KOTLIN_USAGE};
        ISSUES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Landroidx/annotation/experimental/lint/AnnotationRetentionDetector$AnnotationChecker;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Landroidx/annotation/experimental/lint/AnnotationRetentionDetector;Lcom/android/tools/lint/detector/api/JavaContext;)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "formatRetention", "", "retention", "defaultRetention", "reportKotlinUsage", "", "annotated", "Lorg/jetbrains/uast/UAnnotated;", "reportRetention", "expected", "actual", "validateAnnotationRetention", "visitAnnotation", "node", "Lorg/jetbrains/uast/UAnnotation;", "annotation-experimental-lint"})
    private final class AnnotationChecker
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public AnnotationChecker(JavaContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        /*
         * Unable to fully structure code
         */
        public void visitAnnotation(@NotNull UAnnotation node) {
            block11: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                var4_2 = node.getUastParent();
                v0 = var4_2 instanceof UAnnotated != false ? (UAnnotated)var4_2 : null;
                if (v0 == null) {
                    return;
                }
                annotated = v0;
                isKotlin = Lint.isKotlin((Language)annotated.getLang());
                qualifiedName = node.getQualifiedName();
                if (isKotlin && Intrinsics.areEqual((Object)qualifiedName, (Object)"androidx.annotation.RequiresOptIn")) {
                    this.reportKotlinUsage(annotated);
                }
                if ((var5_5 = qualifiedName) == null) break block11;
                switch (var5_5.hashCode()) {
                    case 1943420212: {
                        if (!var5_5.equals("androidx.annotation.experimental.Experimental")) {
                            break;
                        }
                        ** GOTO lbl27
                    }
                    case 1439237597: {
                        if (!var5_5.equals("kotlin.RequiresOptIn")) {
                            break;
                        }
                        ** GOTO lbl27
                    }
                    case -1859570192: {
                        if (!var5_5.equals("androidx.annotation.RequiresOptIn")) {
                            break;
                        }
                        ** GOTO lbl27
                    }
                    case -1652642603: {
                        if (!var5_5.equals("kotlin.Experimental")) break;
lbl27:
                        // 4 sources

                        this.validateAnnotationRetention(annotated);
                    }
                }
            }
        }

        private final void validateAnnotationRetention(UAnnotated annotated) {
            String string;
            String actualRetention;
            Object v0;
            String expectedRetention;
            String defaultRetention;
            block4: {
                boolean isKotlin = Lint.isKotlin((Language)annotated.getLang());
                List annotations = this.context.getEvaluator().getAllAnnotations(annotated, false);
                String annotationClass = null;
                defaultRetention = null;
                expectedRetention = null;
                if (isKotlin) {
                    expectedRetention = "BINARY";
                    defaultRetention = "RUNTIME";
                    annotationClass = "kotlin.annotation.Retention";
                } else {
                    expectedRetention = "CLASS";
                    defaultRetention = "CLASS";
                    annotationClass = "java.lang.annotation.Retention";
                }
                Iterable iterable = annotations;
                for (Object t : iterable) {
                    UAnnotation annotation = (UAnnotation)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)annotationClass, (Object)annotation.getQualifiedName())) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            UAnnotation uAnnotation = v0;
            String string2 = actualRetention = uAnnotation != null && (string = AnnotationRetentionDetectorKt.extractAttribute$default(uAnnotation, this.context, "value", null, 4, null)) != null ? string : defaultRetention;
            if (!Intrinsics.areEqual((Object)expectedRetention, (Object)actualRetention)) {
                this.reportRetention(annotated, this.formatRetention(expectedRetention, defaultRetention), this.formatRetention(actualRetention, defaultRetention));
            }
        }

        private final String formatRetention(String retention, String defaultRetention) {
            return Intrinsics.areEqual((Object)defaultRetention, (Object)retention) ? "default (`" + retention + "`)" : "`" + retention + "`";
        }

        private final void reportRetention(UAnnotated annotated, String expected, String actual) {
            JavaContext.report$default((JavaContext)this.context, (Issue)Companion.getISSUE_RETENTION(), (UElement)((UElement)annotated), (Location)this.context.getNameLocation((UElement)annotated), (String)("Experimental annotation has " + actual + " retention, should use " + expected), null, (int)16, null);
        }

        private final void reportKotlinUsage(UAnnotated annotated) {
            JavaContext.report$default((JavaContext)this.context, (Issue)Companion.getISSUE_KOTLIN_USAGE(), (UElement)((UElement)annotated), (Location)this.context.getNameLocation((UElement)annotated), (String)"Experimental annotation should use kotlin.RequiresOptIn", null, (int)16, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Landroidx/annotation/experimental/lint/AnnotationRetentionDetector$Companion;", "", "()V", "ISSUES", "", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUES", "()Ljava/util/List;", "ISSUE_KOTLIN_USAGE", "getISSUE_KOTLIN_USAGE", "()Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_RETENTION", "getISSUE_RETENTION", "annotation-experimental-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE_KOTLIN_USAGE() {
            return ISSUE_KOTLIN_USAGE;
        }

        @NotNull
        public final Issue getISSUE_RETENTION() {
            return ISSUE_RETENTION;
        }

        @NotNull
        public final List<Issue> getISSUES() {
            return ISSUES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

