/*
 * Decompiled with CFR 0.152.
 */
package androidx.annotation.experimental.lint;

import androidx.annotation.experimental.lint.AnnotationRetentionDetectorKt;
import androidx.annotation.experimental.lint.ExperimentalDetectorKt;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0001KB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J|\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u0019H\u0002J8\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\"\u001a\u00020\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J \u0010$\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u0017H\u0002J \u0010&\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)2\u0006\u0010!\u001a\u00020\u0006H\u0002J \u0010*\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0006H\u0002JV\u0010+\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010%\u001a\u0004\u0018\u00010\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010\"\u001a\u00020\u000b2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J)\u00101\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u00102\u001a\u0002032\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020504H\u0002\u00a2\u0006\u0002\u00106J2\u00107\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u0005082\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u00102\u001a\u000203H\u0002J0\u00109\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006H\u0002J|\u0010<\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0005H\u0016J\u0018\u0010@\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010A\u001a\u00020BH\u0016J\u0018\u0010@\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010C\u001a\u00020DH\u0016J\u0012\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00190F*\u00020\u0019H\u0002J*\u0010G\u001a\u00020H*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010I\u001a\u00020\u00062\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001c\u0010J\u001a\u00020H*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010I\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Landroidx/annotation/experimental/lint/ExperimentalDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "relevantAnnotations", "", "", "getRelevantAnnotations", "()Ljava/util/List;", "visitedUsages", "", "Lorg/jetbrains/uast/UElement;", "", "applicableAnnotations", "applicableSuperClasses", "checkAnnotations", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "argument", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "method", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "Lorg/jetbrains/uast/UAnnotation;", "allMethodAnnotations", "allClassAnnotations", "packageAnnotations", "annotated", "checkExperimentalUsage", "annotation", "usage", "optInFqNames", "checkMethodOverride", "superMethod", "createAnnotateFix", "Lcom/android/tools/lint/detector/api/LintFix;", "element", "Lorg/jetbrains/uast/UDeclaration;", "createLintFix", "doCheckMethodOverride", "methodAnnotations", "classAnnotations", "pkgAnnotations", "containingClass", "Lcom/intellij/psi/PsiClass;", "filterRelevantAnnotations", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "", "Lcom/intellij/psi/PsiAnnotation;", "(Lcom/android/tools/lint/client/api/JavaEvaluator;[Lcom/intellij/psi/PsiAnnotation;)Ljava/util/List;", "getClassAndPkgAnnotations", "Lkotlin/Pair;", "report", "message", "level", "visitAnnotationUsage", "qualifiedName", "allMemberAnnotations", "allPackageAnnotations", "visitClass", "declaration", "Lorg/jetbrains/uast/UClass;", "lambda", "Lorg/jetbrains/uast/ULambdaExpression;", "asIterable", "", "isExperimentalityAccepted", "", "annotationFqName", "isExperimentalityRequired", "Companion", "annotation-experimental-lint"})
@SourceDebugExtension(value={"SMAP\nExperimentalDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExperimentalDetector.kt\nandroidx/annotation/experimental/lint/ExperimentalDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ExperimentalDetector.kt\nandroidx/annotation/experimental/lint/ExperimentalDetectorKt\n+ 6 ExperimentalDetector.kt\nandroidx/annotation/experimental/lint/ExperimentalDetectorKt$anyParentMatches$1\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,924:1\n1109#2,2:925\n13579#2:927\n13579#2,2:928\n13580#2:930\n361#3,7:931\n1#4:938\n860#5,9:939\n869#5:949\n862#6:948\n288#7,2:950\n*S KotlinDebug\n*F\n+ 1 ExperimentalDetector.kt\nandroidx/annotation/experimental/lint/ExperimentalDetector\n*L\n102#1:925,2\n114#1:927\n117#1:928,2\n114#1:930\n517#1:931,7\n619#1:939,9\n619#1:949\n619#1:948\n674#1:950,2\n*E\n"})
public final class ExperimentalDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UElement, Set<String>> visitedUsages = new LinkedHashMap();
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ExperimentalDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    public static final String KOTLIN_EXPERIMENTAL_ANNOTATION = "kotlin.Experimental";
    @NotNull
    public static final String KOTLIN_USE_EXPERIMENTAL_ANNOTATION = "kotlin.UseExperimental";
    @NotNull
    public static final String KOTLIN_OPT_IN_ANNOTATION = "kotlin.OptIn";
    @NotNull
    public static final String KOTLIN_REQUIRES_OPT_IN_ANNOTATION = "kotlin.RequiresOptIn";
    @NotNull
    public static final String JAVA_EXPERIMENTAL_ANNOTATION = "androidx.annotation.experimental.Experimental";
    @NotNull
    public static final String JAVA_USE_EXPERIMENTAL_ANNOTATION = "androidx.annotation.experimental.UseExperimental";
    @NotNull
    public static final String JAVA_REQUIRES_OPT_IN_ANNOTATION = "androidx.annotation.RequiresOptIn";
    @NotNull
    public static final String JAVA_OPT_IN_ANNOTATION = "androidx.annotation.OptIn";
    @NotNull
    public static final String ENUM_ERROR = "ERROR";
    @NotNull
    public static final String ENUM_WARNING = "WARNING";
    @NotNull
    private static final Issue ISSUE_ERROR = androidx.annotation.experimental.lint.ExperimentalDetector$Companion.access$issueForLevel(Companion, "ERROR", Severity.ERROR);
    @NotNull
    private static final Issue ISSUE_WARNING = androidx.annotation.experimental.lint.ExperimentalDetector$Companion.access$issueForLevel(Companion, "WARNING", Severity.WARNING);
    @NotNull
    private static final List<Issue> ISSUES;

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{JAVA_EXPERIMENTAL_ANNOTATION, KOTLIN_EXPERIMENTAL_ANNOTATION, JAVA_REQUIRES_OPT_IN_ANNOTATION, KOTLIN_REQUIRES_OPT_IN_ANNOTATION};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"java.lang.Object");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void visitClass(@NotNull JavaContext context, @NotNull ULambdaExpression lambda) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
            var5_3 = lambda.getFunctionalInterfaceType();
            v0 = var5_3 instanceof PsiClassReferenceType != false ? (PsiClassReferenceType)var5_3 : null;
            v1 /* !! */  = superClass = v0 != null ? v0.resolve() : null;
            if (superClass == null || (var5_3 = superClass.getAllMethods()) == null) ** GOTO lbl-1000
            var7_5 = var5_3;
            $i$f$first = false;
            var10_8 = ((void)$this$first$iv).length;
            for (var9_7 = 0; var9_7 < var10_8; ++var9_7) {
                method = element$iv = $this$first$iv[var9_7];
                $i$a$-first-ExperimentalDetector$visitClass$superMethod$1 = false;
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                if (!ExperimentalDetectorKt.access$isAbstract((PsiModifierListOwner)method)) {
                    continue;
                }
                break block5;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        var6_12 = element$iv;
        if (var6_12 != null) {
            v2 = UastContextKt.toUElement((PsiElement)((PsiElement)var6_12));
        } else lbl-1000:
        // 2 sources

        {
            v2 = superMethod = null;
        }
        if (superMethod instanceof UMethod) {
            this.checkMethodOverride(context, (UElement)lambda, (PsiMethod)superMethod);
        }
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        UMethod[] $this$forEach$iv = declaration.getMethods();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            UMethod element$iv;
            UMethod method = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            JavaEvaluator eval = context.getEvaluator();
            if (!eval.isOverride(method, true)) continue;
            PsiMethod[] psiMethodArray = method.findSuperMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"method.findSuperMethods()");
            Object[] $this$forEach$iv2 = psiMethodArray;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PsiMethod superMethod = (PsiMethod)element$iv2;
                boolean bl2 = false;
                UElement uElement = (UElement)method;
                Intrinsics.checkNotNullExpressionValue((Object)superMethod, (String)"superMethod");
                this.checkMethodOverride(context, uElement, superMethod);
            }
        }
    }

    private final void checkMethodOverride(JavaContext context, UElement usage, PsiMethod superMethod) {
        JavaEvaluator evaluator = context.getEvaluator();
        PsiAnnotation[] allAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)superMethod, true);
        List<UAnnotation> methodAnnotations = this.filterRelevantAnnotations(evaluator, allAnnotations);
        PsiClass containingClass = superMethod.getContainingClass();
        Pair<List<UAnnotation>, List<UAnnotation>> pair = this.getClassAndPkgAnnotations(containingClass, evaluator);
        List classAnnotations = (List)pair.component1();
        List pkgAnnotations = (List)pair.component2();
        this.doCheckMethodOverride(context, superMethod, methodAnnotations, classAnnotations, pkgAnnotations, usage, containingClass);
    }

    private final void doCheckMethodOverride(JavaContext context, PsiMethod superMethod, List<? extends UAnnotation> methodAnnotations, List<? extends UAnnotation> classAnnotations, List<? extends UAnnotation> pkgAnnotations, UElement usage, PsiClass containingClass) {
        if (!((Collection)methodAnnotations).isEmpty()) {
            this.checkAnnotations(context, usage, AnnotationUsageType.METHOD_CALL, superMethod, (PsiElement)superMethod, methodAnnotations, methodAnnotations, classAnnotations, pkgAnnotations, (PsiElement)superMethod);
        }
        if (containingClass != null && !((Collection)classAnnotations).isEmpty()) {
            this.checkAnnotations(context, usage, AnnotationUsageType.METHOD_CALL_CLASS, superMethod, (PsiElement)superMethod, classAnnotations, methodAnnotations, classAnnotations, pkgAnnotations, (PsiElement)containingClass);
        }
        if (!((Collection)pkgAnnotations).isEmpty()) {
            this.checkAnnotations(context, usage, AnnotationUsageType.METHOD_CALL_PACKAGE, superMethod, (PsiElement)superMethod, pkgAnnotations, methodAnnotations, classAnnotations, pkgAnnotations, null);
        }
    }

    private final void checkAnnotations(JavaContext context, UElement argument, AnnotationUsageType type, PsiMethod method, PsiElement referenced, List<? extends UAnnotation> annotations, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations, List<? extends UAnnotation> packageAnnotations, PsiElement annotated) {
        for (UAnnotation uAnnotation : annotations) {
            String signature;
            if (uAnnotation.getQualifiedName() == null) continue;
            List uAnnotations = null;
            PsiAnnotation[] psiAnnotations = null;
            if (!this.isApplicableAnnotationUsage(type)) continue;
            if (annotated != null && !this.inheritAnnotation(signature)) {
                PsiModifierListOwner owner;
                PsiElement psiElement = uAnnotation.getSourcePsi();
                PsiAnnotation psiAnnotation = psiElement instanceof PsiAnnotation ? (PsiAnnotation)psiElement : null;
                PsiAnnotationOwner annotationOwner = psiAnnotation != null ? psiAnnotation.getOwner() : null;
                PsiModifierListOwner psiModifierListOwner = owner = annotationOwner instanceof PsiElement ? (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)annotationOwner), PsiModifierListOwner.class) : null;
                if (owner != null) {
                    UElement annotatedPsi;
                    UElement uElement = annotated instanceof UElement ? (UElement)annotated : null;
                    if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
                        uElement = annotated;
                    }
                    if (!Intrinsics.areEqual((Object)owner, (Object)(annotatedPsi = uElement))) {
                        continue;
                    }
                } else {
                    boolean bl;
                    if (annotated instanceof UAnnotated) {
                        List list;
                        boolean found = false;
                        ExperimentalDetector $this$checkAnnotations_u24lambda_u243 = this;
                        bl = false;
                        uAnnotations = list = context.getEvaluator().getAllAnnotations((UAnnotated)annotated, false);
                        for (UAnnotation uAnnotation2 : list) {
                            String qualifiedName = uAnnotation2.getQualifiedName();
                            if (!Intrinsics.areEqual((Object)qualifiedName, (Object)signature)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                    if (annotated instanceof PsiModifierListOwner) {
                        PsiAnnotation[] array;
                        boolean found = false;
                        ExperimentalDetector $this$checkAnnotations_u24lambda_u244 = this;
                        bl = false;
                        psiAnnotations = array = context.getEvaluator().getAllAnnotations((PsiModifierListOwner)annotated, false);
                        for (PsiAnnotation psiAnnotation2 : array) {
                            String qualifiedName = psiAnnotation2.getQualifiedName();
                            if (!Intrinsics.areEqual((Object)qualifiedName, (Object)signature)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                }
            }
            this.visitAnnotationUsage(context, argument, type, uAnnotation, signature, method, referenced, annotations, allMethodAnnotations, allClassAnnotations, packageAnnotations);
        }
    }

    static /* synthetic */ void checkAnnotations$default(ExperimentalDetector experimentalDetector, JavaContext javaContext, UElement uElement, AnnotationUsageType annotationUsageType, PsiMethod psiMethod, PsiElement psiElement, List list, List list2, List list3, List list4, PsiElement psiElement2, int n, Object object) {
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        experimentalDetector.checkAnnotations(javaContext, uElement, annotationUsageType, psiMethod, psiElement, list, list2, list3, list4, psiElement2);
    }

    private final Pair<List<UAnnotation>, List<UAnnotation>> getClassAndPkgAnnotations(PsiClass containingClass, JavaEvaluator evaluator) {
        List<UAnnotation> classAnnotations = null;
        List pkgAnnotations = null;
        if (containingClass != null) {
            List<UAnnotation> list;
            PsiAnnotation[] annotations = evaluator.getAllAnnotations((PsiModifierListOwner)containingClass, true);
            classAnnotations = this.filterRelevantAnnotations(evaluator, annotations);
            PsiPackage pkg = evaluator.getPackage((PsiElement)containingClass);
            if (pkg != null) {
                PsiAnnotation[] annotations2 = evaluator.getAllAnnotations((PsiModifierListOwner)pkg, false);
                list = this.filterRelevantAnnotations(evaluator, annotations2);
            } else {
                list = CollectionsKt.emptyList();
            }
            pkgAnnotations = list;
        } else {
            classAnnotations = CollectionsKt.emptyList();
            pkgAnnotations = CollectionsKt.emptyList();
        }
        return new Pair((Object)classAnnotations, (Object)pkgAnnotations);
    }

    private final List<UAnnotation> filterRelevantAnnotations(JavaEvaluator evaluator, PsiAnnotation[] annotations) {
        List result = null;
        int length = annotations.length;
        if (length == 0) {
            return CollectionsKt.emptyList();
        }
        for (PsiAnnotation annotation : annotations) {
            PsiJavaCodeReferenceElement cls;
            String signature = annotation.getQualifiedName();
            if (signature == null || (StringsKt.startsWith$default((String)signature, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)signature, (String)"java.", (boolean)false, (int)2, null)) && !this.getRelevantAnnotations().contains(signature)) continue;
            if (this.getRelevantAnnotations().contains(signature)) {
                UAnnotation uAnnotation = JavaUAnnotation.Companion.wrap(annotation);
                if (length == 1) {
                    return CollectionsKt.listOf((Object)uAnnotation);
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(uAnnotation);
                continue;
            }
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annotation.getNameReferenceElement();
            if (psiJavaCodeReferenceElement == null || (psiJavaCodeReferenceElement = psiJavaCodeReferenceElement.resolve()) == null) {
                Project project;
                ExperimentalDetector $this$filterRelevantAnnotations_u24lambda_u245 = this;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)annotation.getProject(), (String)"annotation.project");
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(signature, GlobalSearchScope.projectScope((Project)project));
                if (psiClass == null) continue;
                psiJavaCodeReferenceElement = (PsiElement)psiClass;
            }
            if (!((cls = psiJavaCodeReferenceElement) instanceof PsiClass) || !((PsiClass)cls).isAnnotationType()) continue;
            for (PsiAnnotation inner : evaluator.getAllAnnotations((PsiModifierListOwner)cls, false)) {
                String a = inner.getQualifiedName();
                if (a == null || !this.getRelevantAnnotations().contains(a)) continue;
                if (result == null) {
                    result = new ArrayList(2);
                }
                UElement uElement = UastFacade.INSTANCE.convertElement((PsiElement)inner, null, UAnnotation.class);
                Intrinsics.checkNotNull((Object)uElement, (String)"null cannot be cast to non-null type org.jetbrains.uast.UAnnotation");
                UAnnotation innerU = (UAnnotation)uElement;
                result.add(innerU);
            }
        }
        List list = result;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<String> getRelevantAnnotations() {
        return this.applicableAnnotations();
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkNotNullParameter(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkNotNullParameter(allPackageAnnotations, (String)"allPackageAnnotations");
        if (referenced instanceof PsiField && type == AnnotationUsageType.ASSIGNMENT_RHS || referenced instanceof PsiMethod && type == AnnotationUsageType.ASSIGNMENT_RHS || referenced instanceof PsiMethod && type == AnnotationUsageType.FIELD_REFERENCE || referenced instanceof PsiMethod && type == AnnotationUsageType.METHOD_CALL_PARAMETER) {
            return;
        }
        switch (qualifiedName) {
            case "androidx.annotation.experimental.Experimental": 
            case "androidx.annotation.RequiresOptIn": {
                Object[] objectArray = new String[]{JAVA_USE_EXPERIMENTAL_ANNOTATION, JAVA_OPT_IN_ANNOTATION};
                this.checkExperimentalUsage(context, annotation, referenced, usage, CollectionsKt.listOf((Object[])objectArray));
                break;
            }
            case "kotlin.RequiresOptIn": 
            case "kotlin.Experimental": {
                if (Lint.isKotlin((PsiElement)usage.getSourcePsi())) break;
                Object[] objectArray = new String[]{KOTLIN_USE_EXPERIMENTAL_ANNOTATION, KOTLIN_OPT_IN_ANNOTATION, JAVA_USE_EXPERIMENTAL_ANNOTATION, JAVA_OPT_IN_ANNOTATION};
                this.checkExperimentalUsage(context, annotation, referenced, usage, CollectionsKt.listOf((Object[])objectArray));
            }
        }
    }

    private final void checkExperimentalUsage(JavaContext context, UAnnotation annotation, PsiElement referenced, UElement usage, List<String> optInFqNames) {
        Set visitedAnnotations;
        Set set;
        UElement uElement = annotation.getUastParent();
        Object object = uElement instanceof UClass ? (UClass)uElement : null;
        if (object == null || (object = object.getQualifiedName()) == null) {
            return;
        }
        Object annotationFqName = object;
        Map<UElement, Set<String>> $this$getOrPut$iv = this.visitedUsages;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(usage);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(usage, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        if (!(visitedAnnotations = set).add((String)annotationFqName)) {
            return;
        }
        UElement uElement2 = UastContextKt.toUElement((PsiElement)referenced);
        if (uElement2 == null && (uElement2 = ExperimentalDetectorKt.access$getReferencedElement(usage)) == null) {
            return;
        }
        UElement decl = uElement2;
        if (!this.isExperimentalityRequired(decl, context, (String)annotationFqName)) {
            return;
        }
        if (this.isExperimentalityAccepted(usage, context, (String)annotationFqName, optInFqNames)) {
            return;
        }
        String level = AnnotationRetentionDetectorKt.extractAttribute(annotation, context, "level", ENUM_ERROR);
        if (level != null) {
            this.report(context, usage, (String)annotationFqName, "This declaration is opt-in and its usage should be marked with `@" + (String)annotationFqName + "` or `@OptIn(markerClass = " + (String)annotationFqName + ".class)`", level);
        } else {
            this.report(context, usage, (String)annotationFqName, "Failed to read `level` from `@" + (String)annotationFqName + "` -- assuming `ERROR`. This declaration is opt-in and its usage should be marked with `@" + (String)annotationFqName + "` or `@OptIn(markerClass = " + (String)annotationFqName + ".class)`", ENUM_ERROR);
        }
    }

    private final boolean isExperimentalityRequired(UElement $this$isExperimentalityRequired, JavaContext context, String annotationFqName) {
        if (ExperimentalDetectorKt.access$isDeclarationAnnotatedWith($this$isExperimentalityRequired, annotationFqName)) {
            return true;
        }
        UElement uElement = $this$isExperimentalityRequired.getUastParent();
        UClass uClass = uElement instanceof UClass ? (UClass)uElement : null;
        boolean bl = uClass != null ? this.isExperimentalityRequired((UElement)uClass, context, annotationFqName) : false;
        if (bl) {
            return true;
        }
        PsiPackage psiPackage = context.getEvaluator().getPackage($this$isExperimentalityRequired);
        if ((psiPackage != null ? psiPackage.getAnnotation(annotationFqName) : null) != null) {
            return true;
        }
        if ($this$isExperimentalityRequired.getSourcePsi() instanceof KtProperty && $this$isExperimentalityRequired instanceof UMethod) {
            UField backingField;
            UField uField;
            block8: {
                UElement uElement2 = $this$isExperimentalityRequired.getUastParent();
                UField[] uFieldArray = uElement2 instanceof UClass ? (UField[])uElement2 : null;
                if (uFieldArray != null && (uFieldArray = uFieldArray.getFields()) != null) {
                    UField[] uFieldArray2 = uFieldArray;
                    int n = uFieldArray2.length;
                    for (int i = 0; i < n; ++i) {
                        UField uField2;
                        UField it = uField2 = uFieldArray2[i];
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getSourcePsi(), (Object)$this$isExperimentalityRequired.getSourcePsi())) continue;
                        uField = uField2;
                        break block8;
                    }
                    uField = null;
                } else {
                    uField = null;
                }
            }
            UField uField3 = backingField = uField;
            boolean bl3 = uField3 != null ? ExperimentalDetectorKt.access$isDeclarationAnnotatedWith((UElement)uField3, annotationFqName) : false;
            if (bl3) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExperimentalityAccepted(UElement $this$isExperimentalityAccepted, JavaContext context, String annotationFqName, List<String> optInFqNames) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Configuration config = context.getConfiguration();
        String string = Configuration.getOption$default((Configuration)config, (Issue)ISSUE_ERROR, (String)"opt-in", null, (int)4, null);
        if (string != null) {
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)annotationFqName, (boolean)false, (int)2, null)) {
                return true;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return true;
        String string2 = Configuration.getOption$default((Configuration)config, (Issue)ISSUE_WARNING, (String)"opt-in", null, (int)4, null);
        if (string2 != null) {
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)annotationFqName, (boolean)false, (int)2, null)) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        UElement $this$anyParentMatches_u24default$iv = $this$isExperimentalityAccepted;
        boolean defaultValue$iv = false;
        boolean $i$f$anyParentMatches = false;
        UElement element$iv = $this$anyParentMatches_u24default$iv;
        while (true) {
            UElement element = element$iv;
            boolean bl4 = false;
            if (ExperimentalDetectorKt.access$isDeclarationAnnotatedWith(element, annotationFqName)) return true;
            if (ExperimentalDetectorKt.access$isDeclarationAnnotatedWithOptInOf(element, annotationFqName, optInFqNames)) {
                return true;
            }
            boolean bl5 = false;
            if (bl5) {
                return true;
            }
            element = element$iv;
            boolean bl6 = false;
            UElement it = element;
            if (false) {
                bl = false;
                break;
            }
            if (element$iv.getUastParent() != null) continue;
            bl = defaultValue$iv;
            break;
        }
        if (bl) return true;
        PsiPackage psiPackage = context.getEvaluator().getPackage($this$isExperimentalityAccepted);
        if (psiPackage == null) return false;
        PsiPackage element = psiPackage;
        boolean bl7 = false;
        if (ExperimentalDetectorKt.access$isAnnotatedWith(element, annotationFqName)) return true;
        if (!ExperimentalDetectorKt.access$isAnnotatedWithOptInOf(element, annotationFqName, optInFqNames)) return false;
        return true;
    }

    private final LintFix createLintFix(JavaContext context, UElement usage, String annotation) {
        LintFix.GroupBuilder lintFixes;
        block2: {
            String propagateAnnotation = "@" + annotation;
            lintFixes = this.fix().alternatives();
            boolean addedFix = false;
            UMethod uMethod = UastUtils.getContainingUMethod((UElement)usage);
            if (uMethod != null) {
                UMethod containingMethod = uMethod;
                boolean bl = false;
                boolean isKotlin = Lint.isKotlin((PsiElement)usage.getSourcePsi());
                String optInAnnotation = isKotlin ? "@androidx.annotation.OptIn(" + annotation + "::class)" : "@androidx.annotation.OptIn(markerClass = " + annotation + ".class)";
                lintFixes.add(this.createAnnotateFix(context, (UDeclaration)containingMethod, optInAnnotation));
                lintFixes.add(this.createAnnotateFix(context, (UDeclaration)containingMethod, propagateAnnotation));
                addedFix = true;
            }
            if (addedFix) break block2;
            UClass uClass = UastUtils.getContainingUClass((UElement)usage);
            if (uClass != null) {
                UClass containingClass = uClass;
                boolean bl = false;
                lintFixes.add(this.createAnnotateFix(context, (UDeclaration)containingClass, propagateAnnotation));
            }
        }
        return lintFixes.build();
    }

    private final LintFix createAnnotateFix(JavaContext context, UDeclaration element, String annotation) {
        PsiElement psiElement;
        Object object;
        UDeclaration uDeclaration = element;
        if (uDeclaration instanceof UMethod) {
            object = "'" + ((UMethod)element).getName() + "'";
        } else if (uDeclaration instanceof UClass) {
            object = "containing class '" + ((UClass)element).getName() + "'";
        } else if (uDeclaration instanceof UAnonymousClass) {
            object = "containing anonymous class";
        } else {
            throw new IllegalArgumentException("Unsupported element type");
        }
        String elementLabel = object;
        PsiElement elementSourcePsi = element.getSourcePsi();
        if (elementSourcePsi instanceof PsiModifierListOwner) {
            PsiElement psiElement2;
            block10: {
                Iterable<PsiElement> $this$firstOrNull$iv = this.asIterable(elementSourcePsi);
                boolean $i$f$firstOrNull = false;
                Iterator<PsiElement> iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    PsiElement element$iv;
                    PsiElement child = element$iv = iterator2.next();
                    boolean bl = false;
                    if (!(!(child instanceof PsiWhiteSpace) && !(child instanceof PsiComment))) continue;
                    psiElement2 = element$iv;
                    break block10;
                }
                psiElement2 = null;
            }
            if ((psiElement = (PsiElement)psiElement2) == null) {
                throw new IllegalArgumentException("Failed to locate element declaration");
            }
        } else {
            psiElement = (PsiElement)element;
        }
        PsiElement elementForInsert = psiElement;
        return this.fix().name("Add '" + annotation + "' annotation to " + elementLabel).annotate(annotation, true).range(context.getLocation(elementForInsert)).build();
    }

    private final Iterable<PsiElement> asIterable(PsiElement $this$asIterable) {
        return new Iterable<PsiElement>($this$asIterable){
            final /* synthetic */ PsiElement $this_asIterable;
            {
                this.$this_asIterable = $receiver;
            }

            @NotNull
            public Iterator<PsiElement> iterator() {
                return new Iterator<PsiElement>(this.$this_asIterable){
                    private PsiElement current;
                    {
                        this.current = $receiver.getFirstChild();
                    }

                    public boolean hasNext() {
                        return this.current != null;
                    }

                    @NotNull
                    public PsiElement next() {
                        PsiElement psiElement;
                        PsiElement $this$next_u24lambda_u240 = psiElement = this.current;
                        boolean bl = false;
                        this.current = $this$next_u24lambda_u240.getNextSibling();
                        PsiElement psiElement2 = psiElement;
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"current.apply { current = nextSibling }");
                        return psiElement2;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    private final void report(JavaContext context, UElement usage, String annotation, String message, String level) {
        block7: {
            Issue issue;
            String string = level;
            if (Intrinsics.areEqual((Object)string, (Object)ENUM_ERROR)) {
                issue = ISSUE_ERROR;
            } else if (Intrinsics.areEqual((Object)string, (Object)ENUM_WARNING)) {
                issue = ISSUE_WARNING;
            } else {
                throw new IllegalArgumentException("Level was \"" + level + "\" but must be one of: ERROR, WARNING");
            }
            Issue issue2 = issue;
            try {
                String string2 = Configuration.getOption$default((Configuration)context.getConfiguration(), (Issue)issue2, (String)"opt-in", null, (int)4, null);
                if (!(string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)annotation, (boolean)false, (int)2, null) : false)) {
                    context.report(issue2, usage, context.getNameLocation(usage), StringsKt.trimIndent((String)message), this.createLintFix(context, usage, annotation));
                }
            }
            catch (UnsupportedOperationException e) {
                if (Intrinsics.areEqual((Object)"Method not implemented", (Object)e.getMessage())) break block7;
                throw e;
            }
        }
    }

    static {
        Object[] objectArray = new Issue[]{ISSUE_ERROR, ISSUE_WARNING};
        ISSUES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/annotation/experimental/lint/ExperimentalDetector$Companion;", "", "()V", "ENUM_ERROR", "", "ENUM_WARNING", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUES", "", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUES", "()Ljava/util/List;", "ISSUE_ERROR", "getISSUE_ERROR", "()Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_WARNING", "getISSUE_WARNING", "JAVA_EXPERIMENTAL_ANNOTATION", "JAVA_OPT_IN_ANNOTATION", "JAVA_REQUIRES_OPT_IN_ANNOTATION", "JAVA_USE_EXPERIMENTAL_ANNOTATION", "KOTLIN_EXPERIMENTAL_ANNOTATION", "KOTLIN_OPT_IN_ANNOTATION", "KOTLIN_REQUIRES_OPT_IN_ANNOTATION", "KOTLIN_USE_EXPERIMENTAL_ANNOTATION", "issueForLevel", "levelEnum", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "annotation-experimental-lint"})
    public static final class Companion {
        private Companion() {
        }

        private final Issue issueForLevel(String levelEnum, Severity severity) {
            String levelText = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)levelEnum);
            String issueId = "UnsafeOptInUsage" + CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)levelText);
            return Issue.Companion.create(issueId, "Unsafe opt-in usage intended to be " + levelText + "-level severity", "\n                This API has been flagged as opt-in with " + levelText + "-level severity.\n\n                Any declaration annotated with this marker is considered part of an unstable or\n                otherwise non-standard API surface and its call sites should accept the opt-in\n                aspect of it by using the `@OptIn` annotation, using the marker annotation --\n                effectively causing further propagation of the opt-in aspect -- or configuring\n                the `" + issueId + "` check's options for project-wide opt-in.\n\n                To configure project-wide opt-in, specify the `opt-in` option value in `lint.xml`\n                as a comma-delimited list of opted-in annotations:\n\n                ```\n                <lint>\n                    <issue id=\"" + issueId + "\">\n                        <option name=\"opt-in\" value=\"com.foo.ExperimentalBarAnnotation\" />\n                    </issue>\n                </lint>\n                ```\n                ", Category.CORRECTNESS, 4, severity, IMPLEMENTATION);
        }

        @NotNull
        public final Issue getISSUE_ERROR() {
            return ISSUE_ERROR;
        }

        @NotNull
        public final Issue getISSUE_WARNING() {
            return ISSUE_WARNING;
        }

        @NotNull
        public final List<Issue> getISSUES() {
            return ISSUES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Issue access$issueForLevel(Companion $this, String levelEnum, Severity severity) {
            return $this.issueForLevel(levelEnum, severity);
        }
    }
}

