/*
 * Decompiled with CFR 0.152.
 */
package androidx.annotation.experimental.lint;

import androidx.annotation.experimental.lint.AnnotationRetentionDetectorKt;
import androidx.annotation.experimental.lint.ExperimentalDetectorKt;
import com.android.tools.lint.client.api.AnnotationLookup;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0001KB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J|\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\b\u0010!\u001a\u0004\u0018\u00010\u001bH\u0002J8\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J \u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u0019H\u0002J\"\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+2\u0006\u0010#\u001a\u00020\bH\u0002J \u0010,\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\r2\u0006\u0010#\u001a\u00020\bH\u0002JV\u0010-\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010'\u001a\u0004\u0018\u00010\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u0006\u0010$\u001a\u00020\r2\b\u00101\u001a\u0004\u0018\u000102H\u0002J5\u00103\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u0006\u00104\u001a\u0002052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u000207062\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u00108J:\u00109\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00070:2\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00104\u001a\u0002052\u0006\u0010\u0013\u001a\u00020\rH\u0002J0\u0010;\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\r2\u0006\u0010#\u001a\u00020\b2\u0006\u0010<\u001a\u00020\b2\u0006\u0010=\u001a\u00020\bH\u0002J|\u0010>\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0007H\u0016J\u0018\u0010B\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010C\u001a\u00020DH\u0016J\u0018\u0010B\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010E\u001a\u00020FH\u0016J*\u0010G\u001a\u00020H*\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010I\u001a\u00020\b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010J\u001a\u00020H*\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010I\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Landroidx/annotation/experimental/lint/ExperimentalDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "annotationLookup", "Lcom/android/tools/lint/client/api/AnnotationLookup;", "relevantAnnotations", "", "", "getRelevantAnnotations", "()Ljava/util/List;", "visitedUsages", "", "Lorg/jetbrains/uast/UElement;", "", "applicableAnnotations", "applicableSuperClasses", "checkAnnotations", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "argument", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "method", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "Lorg/jetbrains/uast/UAnnotation;", "allMethodAnnotations", "allClassAnnotations", "packageAnnotations", "annotated", "checkExperimentalUsage", "annotation", "usage", "optInFqNames", "checkMethodOverride", "superMethod", "createAnnotateFix", "Lcom/android/tools/lint/detector/api/LintFix;", "element", "Lorg/jetbrains/uast/UDeclaration;", "createLintFix", "doCheckMethodOverride", "methodAnnotations", "classAnnotations", "pkgAnnotations", "containingClass", "Lcom/intellij/psi/PsiClass;", "filterRelevantAnnotations", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "", "Lcom/intellij/psi/PsiAnnotation;", "(Lcom/android/tools/lint/client/api/JavaEvaluator;[Lcom/intellij/psi/PsiAnnotation;Lorg/jetbrains/uast/UElement;)Ljava/util/List;", "getClassAndPkgAnnotations", "Lkotlin/Pair;", "report", "message", "level", "visitAnnotationUsage", "qualifiedName", "allMemberAnnotations", "allPackageAnnotations", "visitClass", "declaration", "Lorg/jetbrains/uast/UClass;", "lambda", "Lorg/jetbrains/uast/ULambdaExpression;", "isExperimentalityAccepted", "", "annotationFqName", "isExperimentalityRequired", "Companion", "annotation-experimental-lint"})
public final class ExperimentalDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UElement, Set<String>> visitedUsages = new LinkedHashMap();
    @NotNull
    private final AnnotationLookup annotationLookup = new AnnotationLookup();
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ExperimentalDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    public static final String KOTLIN_EXPERIMENTAL_ANNOTATION = "kotlin.Experimental";
    @NotNull
    public static final String KOTLIN_USE_EXPERIMENTAL_ANNOTATION = "kotlin.UseExperimental";
    @NotNull
    public static final String KOTLIN_OPT_IN_ANNOTATION = "kotlin.OptIn";
    @NotNull
    public static final String KOTLIN_REQUIRES_OPT_IN_ANNOTATION = "kotlin.RequiresOptIn";
    @NotNull
    public static final String JAVA_EXPERIMENTAL_ANNOTATION = "androidx.annotation.experimental.Experimental";
    @NotNull
    public static final String JAVA_USE_EXPERIMENTAL_ANNOTATION = "androidx.annotation.experimental.UseExperimental";
    @NotNull
    public static final String JAVA_REQUIRES_OPT_IN_ANNOTATION = "androidx.annotation.RequiresOptIn";
    @NotNull
    public static final String JAVA_OPT_IN_ANNOTATION = "androidx.annotation.OptIn";
    @NotNull
    public static final String ENUM_ERROR = "ERROR";
    @NotNull
    public static final String ENUM_WARNING = "WARNING";
    @NotNull
    private static final Issue ISSUE_ERROR = androidx.annotation.experimental.lint.ExperimentalDetector$Companion.access$issueForLevel(Companion, "ERROR", Severity.ERROR);
    @NotNull
    private static final Issue ISSUE_WARNING = androidx.annotation.experimental.lint.ExperimentalDetector$Companion.access$issueForLevel(Companion, "WARNING", Severity.WARNING);
    @NotNull
    private static final List<Issue> ISSUES;

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{JAVA_EXPERIMENTAL_ANNOTATION, KOTLIN_EXPERIMENTAL_ANNOTATION, JAVA_REQUIRES_OPT_IN_ANNOTATION, KOTLIN_REQUIRES_OPT_IN_ANNOTATION};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"java.lang.Object");
    }

    /*
     * WARNING - void declaration
     */
    public void visitClass(@NotNull JavaContext context, @NotNull ULambdaExpression lambda) {
        UElement superMethod;
        UElement uElement;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        PsiType psiType = lambda.getFunctionalInterfaceType();
        PsiClassReferenceType psiClassReferenceType = psiType instanceof PsiClassReferenceType ? (PsiClassReferenceType)psiType : null;
        PsiClass superClass = psiClassReferenceType == null ? null : psiClassReferenceType.resolve();
        psiType = superClass;
        if (psiType == null) {
            uElement = null;
        } else {
            PsiMethod[] psiMethodArray = psiType.getAllMethods();
            if (psiMethodArray == null) {
                uElement = null;
            } else {
                void element$iv2;
                block6: {
                    void $this$first$iv;
                    PsiMethod[] psiMethodArray2 = psiMethodArray;
                    boolean $i$f$first = false;
                    for (void element$iv2 : $this$first$iv) {
                        void method = element$iv2;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                        if (!ExperimentalDetectorKt.access$isAbstract((PsiModifierListOwner)method)) continue;
                        break block6;
                    }
                    throw new NoSuchElementException("Array contains no element matching the predicate.");
                }
                void var7_14 = element$iv2;
                uElement = superMethod = var7_14 == null ? null : UastContextKt.toUElement((PsiElement)((PsiElement)var7_14));
            }
        }
        if (superMethod instanceof UMethod) {
            this.checkMethodOverride(context, (UElement)lambda, (PsiMethod)superMethod);
        }
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        UMethod[] $this$forEach$iv = declaration.getMethods();
        boolean $i$f$forEach = false;
        UMethod[] uMethodArray = $this$forEach$iv;
        int n = 0;
        int n2 = uMethodArray.length;
        while (n < n2) {
            UMethod element$iv = uMethodArray[n];
            ++n;
            UMethod method = element$iv;
            boolean bl = false;
            JavaEvaluator eval = context.getEvaluator();
            if (!eval.isOverride(method, true)) continue;
            PsiMethod[] psiMethodArray = method.findSuperMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"method.findSuperMethods()");
            Object[] $this$forEach$iv2 = psiMethodArray;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PsiMethod superMethod = (PsiMethod)element$iv2;
                boolean bl2 = false;
                UElement uElement = (UElement)method;
                Intrinsics.checkNotNullExpressionValue((Object)superMethod, (String)"superMethod");
                this.checkMethodOverride(context, uElement, superMethod);
            }
        }
    }

    private final void checkMethodOverride(JavaContext context, UElement usage, PsiMethod superMethod) {
        JavaEvaluator evaluator = context.getEvaluator();
        PsiAnnotation[] allAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)superMethod, true);
        List<UAnnotation> methodAnnotations = this.filterRelevantAnnotations(evaluator, allAnnotations, usage);
        PsiClass containingClass = superMethod.getContainingClass();
        Pair<List<UAnnotation>, List<UAnnotation>> pair = this.getClassAndPkgAnnotations(containingClass, evaluator, usage);
        List classAnnotations = (List)pair.component1();
        List pkgAnnotations = (List)pair.component2();
        this.doCheckMethodOverride(context, superMethod, methodAnnotations, classAnnotations, pkgAnnotations, usage, containingClass);
    }

    private final void doCheckMethodOverride(JavaContext context, PsiMethod superMethod, List<? extends UAnnotation> methodAnnotations, List<? extends UAnnotation> classAnnotations, List<? extends UAnnotation> pkgAnnotations, UElement usage, PsiClass containingClass) {
        if (!((Collection)methodAnnotations).isEmpty()) {
            this.checkAnnotations(context, usage, AnnotationUsageType.METHOD_CALL, superMethod, (PsiElement)superMethod, methodAnnotations, methodAnnotations, classAnnotations, pkgAnnotations, (PsiElement)superMethod);
        }
        if (containingClass != null && !((Collection)classAnnotations).isEmpty()) {
            this.checkAnnotations(context, usage, AnnotationUsageType.METHOD_CALL_CLASS, superMethod, (PsiElement)superMethod, classAnnotations, methodAnnotations, classAnnotations, pkgAnnotations, (PsiElement)containingClass);
        }
        if (!((Collection)pkgAnnotations).isEmpty()) {
            this.checkAnnotations(context, usage, AnnotationUsageType.METHOD_CALL_PACKAGE, superMethod, (PsiElement)superMethod, pkgAnnotations, methodAnnotations, classAnnotations, pkgAnnotations, null);
        }
    }

    private final void checkAnnotations(JavaContext context, UElement argument, AnnotationUsageType type, PsiMethod method, PsiElement referenced, List<? extends UAnnotation> annotations, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations, List<? extends UAnnotation> packageAnnotations, PsiElement annotated) {
        for (UAnnotation uAnnotation : annotations) {
            String signature;
            if (uAnnotation.getQualifiedName() == null) continue;
            List uAnnotations = null;
            PsiAnnotation[] psiAnnotations = null;
            if (!this.isApplicableAnnotationUsage(type)) continue;
            if (annotated != null && !this.inheritAnnotation(signature)) {
                PsiModifierListOwner owner;
                PsiElement psiElement = uAnnotation.getSourcePsi();
                PsiAnnotation psiAnnotation = psiElement instanceof PsiAnnotation ? (PsiAnnotation)psiElement : null;
                PsiAnnotationOwner annotationOwner = psiAnnotation == null ? null : psiAnnotation.getOwner();
                PsiModifierListOwner psiModifierListOwner = owner = annotationOwner instanceof PsiElement ? (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)annotationOwner), PsiModifierListOwner.class) : (PsiModifierListOwner)null;
                if (owner != null) {
                    PsiElement annotatedPsi;
                    PsiElement psiElement2;
                    UElement uElement = annotated instanceof UElement ? (UElement)annotated : null;
                    if (uElement == null) {
                        psiElement2 = annotated;
                    } else {
                        psiElement2 = uElement.getSourcePsi();
                        if (psiElement2 == null) {
                            psiElement2 = annotatedPsi = annotated;
                        }
                    }
                    if (!Intrinsics.areEqual((Object)owner, (Object)annotatedPsi)) {
                        continue;
                    }
                } else {
                    boolean bl;
                    if (annotated instanceof UAnnotated) {
                        List list;
                        boolean found = false;
                        ExperimentalDetector $this$checkAnnotations_u24lambda_u2d3 = this;
                        bl = false;
                        uAnnotations = list = context.getEvaluator().getAllAnnotations((UAnnotated)annotated, false);
                        for (UAnnotation uAnnotation2 : list) {
                            String qualifiedName = uAnnotation2.getQualifiedName();
                            if (!Intrinsics.areEqual((Object)qualifiedName, (Object)signature)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                    if (annotated instanceof PsiModifierListOwner) {
                        PsiAnnotation[] array;
                        boolean found = false;
                        ExperimentalDetector $this$checkAnnotations_u24lambda_u2d4 = this;
                        bl = false;
                        psiAnnotations = array = context.getEvaluator().getAllAnnotations((PsiModifierListOwner)annotated, false);
                        for (PsiAnnotation psiAnnotation2 : array) {
                            String qualifiedName = psiAnnotation2.getQualifiedName();
                            if (!Intrinsics.areEqual((Object)qualifiedName, (Object)signature)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                }
            }
            this.visitAnnotationUsage(context, argument, type, uAnnotation, signature, method, referenced, annotations, allMethodAnnotations, allClassAnnotations, packageAnnotations);
        }
    }

    static /* synthetic */ void checkAnnotations$default(ExperimentalDetector experimentalDetector, JavaContext javaContext, UElement uElement, AnnotationUsageType annotationUsageType, PsiMethod psiMethod, PsiElement psiElement, List list, List list2, List list3, List list4, PsiElement psiElement2, int n, Object object) {
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        experimentalDetector.checkAnnotations(javaContext, uElement, annotationUsageType, psiMethod, psiElement, list, list2, list3, list4, psiElement2);
    }

    private final Pair<List<UAnnotation>, List<UAnnotation>> getClassAndPkgAnnotations(PsiClass containingClass, JavaEvaluator evaluator, UElement context) {
        List<UAnnotation> classAnnotations = null;
        List pkgAnnotations = null;
        if (containingClass != null) {
            List list;
            PsiAnnotation[] annotations = evaluator.getAllAnnotations((PsiModifierListOwner)containingClass, true);
            classAnnotations = this.filterRelevantAnnotations(evaluator, annotations, context);
            PsiPackage pkg = evaluator.getPackage((PsiElement)containingClass);
            if (pkg != null) {
                PsiAnnotation[] annotations2 = evaluator.getAllAnnotations((PsiModifierListOwner)pkg, false);
                list = ExperimentalDetector.filterRelevantAnnotations$default(this, evaluator, annotations2, null, 4, null);
            } else {
                list = CollectionsKt.emptyList();
            }
            pkgAnnotations = list;
        } else {
            classAnnotations = CollectionsKt.emptyList();
            pkgAnnotations = CollectionsKt.emptyList();
        }
        return new Pair((Object)classAnnotations, (Object)pkgAnnotations);
    }

    private final List<UAnnotation> filterRelevantAnnotations(JavaEvaluator evaluator, PsiAnnotation[] annotations, UElement context) {
        List result = null;
        int length = annotations.length;
        if (length == 0) {
            return CollectionsKt.emptyList();
        }
        int n = 0;
        int n2 = annotations.length;
        while (n < n2) {
            PsiElement cls;
            PsiAnnotation annotation = annotations[n];
            ++n;
            String signature = annotation.getQualifiedName();
            if (signature == null || (StringsKt.startsWith$default((String)signature, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)signature, (String)"java.", (boolean)false, (int)2, null)) && !this.getRelevantAnnotations().contains(signature)) continue;
            if (this.getRelevantAnnotations().contains(signature)) {
                UAnnotation uAnnotation = JavaUAnnotation.Companion.wrap(annotation);
                if (length == 1) {
                    return CollectionsKt.listOf((Object)uAnnotation);
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(uAnnotation);
                continue;
            }
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annotation.getNameReferenceElement();
            Object object = psiJavaCodeReferenceElement == null ? null : psiJavaCodeReferenceElement.resolve();
            if (object == null) {
                ExperimentalDetector $this$filterRelevantAnnotations_u24lambda_u2d5 = this;
                boolean bl = false;
                Project project = annotation.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"annotation.project");
                Project project2 = project;
                PsiElement psiElement = (PsiElement)JavaPsiFacade.getInstance((Project)project2).findClass(signature, GlobalSearchScope.projectScope((Project)project2));
                if (psiElement == null) continue;
                object = psiElement;
            }
            if (!((cls = object) instanceof PsiClass) || !((PsiClass)cls).isAnnotationType()) continue;
            PsiAnnotation[] innerAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false);
            int n3 = 0;
            int n4 = innerAnnotations.length;
            while (n3 < n4) {
                int j;
                PsiAnnotation inner;
                String a;
                if ((a = (inner = innerAnnotations[j = n3++]).getQualifiedName()) == null || !this.getRelevantAnnotations().contains(a)) continue;
                if (result == null) {
                    result = new ArrayList(2);
                }
                UAnnotation innerU = this.annotationLookup.findRealAnnotation(inner, (PsiClass)cls, context);
                result.add(innerU);
            }
        }
        List list = result;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static /* synthetic */ List filterRelevantAnnotations$default(ExperimentalDetector experimentalDetector, JavaEvaluator javaEvaluator, PsiAnnotation[] psiAnnotationArray, UElement uElement, int n, Object object) {
        if ((n & 4) != 0) {
            uElement = null;
        }
        return experimentalDetector.filterRelevantAnnotations(javaEvaluator, psiAnnotationArray, uElement);
    }

    private final List<String> getRelevantAnnotations() {
        return this.applicableAnnotations();
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkNotNullParameter(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkNotNullParameter(allPackageAnnotations, (String)"allPackageAnnotations");
        if (Lint.isKotlin((PsiElement)usage.getSourcePsi()) && type == AnnotationUsageType.FIELD_REFERENCE && referenced instanceof PsiMethod) {
            return;
        }
        switch (qualifiedName) {
            case "androidx.annotation.experimental.Experimental": 
            case "androidx.annotation.RequiresOptIn": {
                Object[] objectArray = new String[]{JAVA_USE_EXPERIMENTAL_ANNOTATION, JAVA_OPT_IN_ANNOTATION};
                this.checkExperimentalUsage(context, annotation, referenced, usage, CollectionsKt.listOf((Object[])objectArray));
                break;
            }
            case "kotlin.RequiresOptIn": 
            case "kotlin.Experimental": {
                if (Lint.isKotlin((PsiElement)usage.getSourcePsi())) break;
                Object[] objectArray = new String[]{KOTLIN_USE_EXPERIMENTAL_ANNOTATION, KOTLIN_OPT_IN_ANNOTATION, JAVA_USE_EXPERIMENTAL_ANNOTATION, JAVA_OPT_IN_ANNOTATION};
                this.checkExperimentalUsage(context, annotation, referenced, usage, CollectionsKt.listOf((Object[])objectArray));
            }
        }
    }

    private final void checkExperimentalUsage(JavaContext context, UAnnotation annotation, PsiElement referenced, UElement usage, List<String> optInFqNames) {
        Set visitedAnnotations;
        Set set;
        UElement uElement = annotation.getUastParent();
        UClass uClass = uElement instanceof UClass ? (UClass)uElement : null;
        String string = uClass == null ? null : uClass.getQualifiedName();
        if (string == null) {
            return;
        }
        String annotationFqName = string;
        Map<UElement, Set<String>> $this$getOrPut$iv = this.visitedUsages;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(usage);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(usage, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        if (!(visitedAnnotations = set).add((String)annotationFqName)) {
            return;
        }
        UElement uElement2 = UastContextKt.toUElement((PsiElement)referenced);
        if (uElement2 == null && (uElement2 = ExperimentalDetectorKt.access$getReferencedElement(usage)) == null) {
            return;
        }
        UElement decl = uElement2;
        if (!this.isExperimentalityRequired(decl, context, annotationFqName)) {
            return;
        }
        if (this.isExperimentalityAccepted(usage, context, annotationFqName, optInFqNames)) {
            return;
        }
        String level = AnnotationRetentionDetectorKt.extractAttribute(annotation, context, "level", ENUM_ERROR);
        if (level != null) {
            this.report(context, usage, annotationFqName, "This declaration is opt-in and its usage should be marked with `@" + annotationFqName + "` or `@OptIn(markerClass = " + annotationFqName + ".class)`", level);
        } else {
            this.report(context, usage, annotationFqName, "Failed to read `level` from `@" + annotationFqName + "` -- assuming `ERROR`. This declaration is opt-in and its usage should be marked with `@" + annotationFqName + "` or `@OptIn(markerClass = " + annotationFqName + ".class)`", ENUM_ERROR);
        }
    }

    private final boolean isExperimentalityRequired(UElement $this$isExperimentalityRequired, JavaContext context, String annotationFqName) {
        if (ExperimentalDetectorKt.access$isDeclarationAnnotatedWith($this$isExperimentalityRequired, annotationFqName)) {
            return true;
        }
        UElement uElement = $this$isExperimentalityRequired.getUastParent();
        UClass uClass = uElement instanceof UClass ? (UClass)uElement : null;
        if (uClass == null ? false : this.isExperimentalityRequired((UElement)uClass, context, annotationFqName)) {
            return true;
        }
        PsiPackage psiPackage = context.getEvaluator().getPackage($this$isExperimentalityRequired);
        return (psiPackage == null ? null : psiPackage.getAnnotation(annotationFqName)) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExperimentalityAccepted(UElement $this$isExperimentalityAccepted, JavaContext context, String annotationFqName, List<String> optInFqNames) {
        boolean bl;
        boolean bl2;
        Configuration config = context.getConfiguration();
        String string = Configuration.getOption$default((Configuration)config, (Issue)ISSUE_ERROR, (String)"opt-in", null, (int)4, null);
        if (string == null) {
            bl2 = false;
        } else {
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)annotationFqName, (boolean)false, (int)2, null)) {
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        String string2 = Configuration.getOption$default((Configuration)config, (Issue)ISSUE_WARNING, (String)"opt-in", null, (int)4, null);
        if (string2 == null) {
            bl = false;
        } else {
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)annotationFqName, (boolean)false, (int)2, null)) {
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        UElement $this$anyParentMatches_u24default$iv = $this$isExperimentalityAccepted;
        boolean defaultValue$iv = false;
        boolean $i$f$anyParentMatches = false;
        UElement element$iv = $this$anyParentMatches_u24default$iv;
        while (true) {
            UElement element = element$iv;
            boolean bl3 = false;
            if (ExperimentalDetectorKt.access$isDeclarationAnnotatedWith(element, annotationFqName)) return true;
            if (ExperimentalDetectorKt.access$isDeclarationAnnotatedWithOptInOf(element, annotationFqName, optInFqNames)) {
                return true;
            }
            boolean bl4 = false;
            if (bl4) {
                return true;
            }
            UElement it = element$iv;
            if (false) {
                return false;
            }
            if (element$iv.getUastParent() == null) break;
        }
        boolean bl5 = defaultValue$iv;
        if (!bl5) return false;
        return true;
    }

    private final LintFix createLintFix(JavaContext context, UElement usage, String annotation) {
        String propagateAnnotation = Intrinsics.stringPlus((String)"@", (Object)annotation);
        LintFix.GroupBuilder lintFixes = this.fix().alternatives();
        UMethod uMethod = UastUtils.getContainingUMethod((UElement)usage);
        if (uMethod != null) {
            UMethod containingMethod = uMethod;
            boolean bl = false;
            boolean isKotlin = Lint.isKotlin((PsiElement)usage.getSourcePsi());
            String optInAnnotation = isKotlin ? "@androidx.annotation.OptIn(" + annotation + "::class)" : "@androidx.annotation.OptIn(markerClass = " + annotation + ".class)";
            lintFixes.add(this.createAnnotateFix(context, (UDeclaration)containingMethod, optInAnnotation));
            lintFixes.add(this.createAnnotateFix(context, (UDeclaration)containingMethod, propagateAnnotation));
        }
        UClass uClass = UastUtils.getContainingUClass((UElement)usage);
        if (uClass != null) {
            UClass containingClass = uClass;
            boolean bl = false;
            lintFixes.add(this.createAnnotateFix(context, (UDeclaration)containingClass, propagateAnnotation));
        }
        LintFix lintFix = lintFixes.build();
        Intrinsics.checkNotNullExpressionValue((Object)lintFix, (String)"lintFixes.build()");
        return lintFix;
    }

    private final LintFix createAnnotateFix(JavaContext context, UDeclaration element, String annotation) {
        String string;
        UDeclaration uDeclaration = element;
        if (uDeclaration instanceof UMethod) {
            string = '\'' + ((UMethod)element).getName() + '\'';
        } else if (uDeclaration instanceof UClass) {
            string = "containing class '" + ((UClass)element).getName() + '\'';
        } else {
            throw new IllegalArgumentException("Unsupported element type");
        }
        String elementLabel = string;
        return this.fix().name("Add '" + annotation + "' annotation to " + elementLabel).replace().range(context.getLocation((UElement)element)).beginning().with(Intrinsics.stringPlus((String)annotation, (Object)" ")).shortenNames().build();
    }

    private final void report(JavaContext context, UElement usage, String annotation, String message, String level) {
        block7: {
            Issue issue;
            String string = level;
            if (Intrinsics.areEqual((Object)string, (Object)ENUM_ERROR)) {
                issue = ISSUE_ERROR;
            } else if (Intrinsics.areEqual((Object)string, (Object)ENUM_WARNING)) {
                issue = ISSUE_WARNING;
            } else {
                throw new IllegalArgumentException("Level was \"" + level + "\" but must be one of: ERROR, WARNING");
            }
            Issue issue2 = issue;
            try {
                String string2 = Configuration.getOption$default((Configuration)context.getConfiguration(), (Issue)issue2, (String)"opt-in", null, (int)4, null);
                if (!(string2 == null ? false : StringsKt.contains$default((CharSequence)string2, (CharSequence)annotation, (boolean)false, (int)2, null))) {
                    context.report(issue2, usage, context.getNameLocation(usage), StringsKt.trimIndent((String)message), this.createLintFix(context, usage, annotation));
                }
            }
            catch (UnsupportedOperationException e) {
                if (Intrinsics.areEqual((Object)"Method not implemented", (Object)e.getMessage())) break block7;
                throw e;
            }
        }
    }

    static {
        Object[] objectArray = new Issue[]{ISSUE_ERROR, ISSUE_WARNING};
        ISSUES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/annotation/experimental/lint/ExperimentalDetector$Companion;", "", "()V", "ENUM_ERROR", "", "ENUM_WARNING", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUES", "", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUES", "()Ljava/util/List;", "ISSUE_ERROR", "getISSUE_ERROR", "()Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_WARNING", "getISSUE_WARNING", "JAVA_EXPERIMENTAL_ANNOTATION", "JAVA_OPT_IN_ANNOTATION", "JAVA_REQUIRES_OPT_IN_ANNOTATION", "JAVA_USE_EXPERIMENTAL_ANNOTATION", "KOTLIN_EXPERIMENTAL_ANNOTATION", "KOTLIN_OPT_IN_ANNOTATION", "KOTLIN_REQUIRES_OPT_IN_ANNOTATION", "KOTLIN_USE_EXPERIMENTAL_ANNOTATION", "issueForLevel", "levelEnum", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "annotation-experimental-lint"})
    public static final class Companion {
        private Companion() {
        }

        private final Issue issueForLevel(String levelEnum, Severity severity) {
            String levelText = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)levelEnum);
            String issueId = Intrinsics.stringPlus((String)"UnsafeOptInUsage", (Object)CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)levelText));
            return Issue.Companion.create(issueId, "Unsafe opt-in usage intended to be " + levelText + "-level severity", "\n                This API has been flagged as opt-in with " + levelText + "-level severity.\n\n                Any declaration annotated with this marker is considered part of an unstable or\n                otherwise non-standard API surface and its call sites should accept the opt-in\n                aspect of it by using the `@OptIn` annotation, using the marker annotation --\n                effectively causing further propagation of the opt-in aspect -- or configuring\n                the `" + issueId + "` check's options for project-wide opt-in.\n\n                To configure project-wide opt-in, specify the `opt-in` option value in `lint.xml`\n                as a comma-delimited list of opted-in annotations:\n\n                ```\n                <lint>\n                    <issue id=\"" + issueId + "\">\n                        <option name=\"opt-in\" value=\"com.foo.ExperimentalBarAnnotation\" />\n                    </issue>\n                </lint>\n                ```\n                ", Category.CORRECTNESS, 4, severity, IMPLEMENTATION);
        }

        @NotNull
        public final Issue getISSUE_ERROR() {
            return ISSUE_ERROR;
        }

        @NotNull
        public final Issue getISSUE_WARNING() {
            return ISSUE_WARNING;
        }

        @NotNull
        public final List<Issue> getISSUES() {
            return ISSUES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Issue access$issueForLevel(Companion $this, String levelEnum, Severity severity) {
            return $this.issueForLevel(levelEnum, severity);
        }
    }
}

