/*
 * Decompiled with CFR 0.152.
 */
package androidx.annotation.experimental.lint;

import androidx.annotation.experimental.lint.AnnotationRetentionDetectorKt;
import androidx.annotation.experimental.lint.ExperimentalDetectorKt;
import com.android.tools.lint.client.api.AnnotationLookup;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.java.JavaUAnnotation;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0001FB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J|\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\b\u0010!\u001a\u0004\u0018\u00010\u001bH\u0002J8\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J \u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u0019H\u0002JV\u0010(\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010'\u001a\u0004\u0018\u00010\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u0006\u0010$\u001a\u00020\r2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J5\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u0006\u0010/\u001a\u0002002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u000202012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u00103J:\u00104\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u0007052\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0013\u001a\u00020\rH\u0002J0\u00106\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\r2\u0006\u0010#\u001a\u00020\b2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bH\u0002J|\u00109\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0007H\u0016J\u0018\u0010=\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010>\u001a\u00020?H\u0016J\u0018\u0010=\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010@\u001a\u00020AH\u0016J*\u0010B\u001a\u00020C*\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010E\u001a\u00020C*\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Landroidx/annotation/experimental/lint/ExperimentalDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "annotationLookup", "Lcom/android/tools/lint/client/api/AnnotationLookup;", "relevantAnnotations", "", "", "getRelevantAnnotations", "()Ljava/util/List;", "visitedUsages", "", "Lorg/jetbrains/uast/UElement;", "", "applicableAnnotations", "applicableSuperClasses", "checkAnnotations", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "argument", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "method", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "Lorg/jetbrains/uast/UAnnotation;", "allMethodAnnotations", "allClassAnnotations", "packageAnnotations", "annotated", "checkExperimentalUsage", "annotation", "usage", "optInFqNames", "checkMethodOverride", "superMethod", "doCheckMethodOverride", "methodAnnotations", "classAnnotations", "pkgAnnotations", "containingClass", "Lcom/intellij/psi/PsiClass;", "filterRelevantAnnotations", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "", "Lcom/intellij/psi/PsiAnnotation;", "(Lcom/android/tools/lint/client/api/JavaEvaluator;[Lcom/intellij/psi/PsiAnnotation;Lorg/jetbrains/uast/UElement;)Ljava/util/List;", "getClassAndPkgAnnotations", "Lkotlin/Pair;", "report", "message", "level", "visitAnnotationUsage", "qualifiedName", "allMemberAnnotations", "allPackageAnnotations", "visitClass", "declaration", "Lorg/jetbrains/uast/UClass;", "lambda", "Lorg/jetbrains/uast/ULambdaExpression;", "isExperimentalityAccepted", "", "annotationFqName", "isExperimentalityRequired", "Companion", "annotation-experimental-lint"})
public final class ExperimentalDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UElement, Set<String>> visitedUsages;
    @NotNull
    private final AnnotationLookup annotationLookup;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ExperimentalDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    public static final String KOTLIN_EXPERIMENTAL_ANNOTATION = "kotlin.Experimental";
    @NotNull
    public static final String KOTLIN_USE_EXPERIMENTAL_ANNOTATION = "kotlin.UseExperimental";
    @NotNull
    public static final String KOTLIN_OPT_IN_ANNOTATION = "kotlin.OptIn";
    @NotNull
    public static final String KOTLIN_REQUIRES_OPT_IN_ANNOTATION = "kotlin.RequiresOptIn";
    @NotNull
    public static final String JAVA_EXPERIMENTAL_ANNOTATION = "androidx.annotation.experimental.Experimental";
    @NotNull
    public static final String JAVA_USE_EXPERIMENTAL_ANNOTATION = "androidx.annotation.experimental.UseExperimental";
    @NotNull
    public static final String JAVA_REQUIRES_OPT_IN_ANNOTATION = "androidx.annotation.RequiresOptIn";
    @NotNull
    public static final String JAVA_OPT_IN_ANNOTATION = "androidx.annotation.OptIn";
    @NotNull
    public static final String ENUM_ERROR = "ERROR";
    @NotNull
    public static final String ENUM_WARNING = "WARNING";
    @NotNull
    private static final Issue ISSUE_ERROR = androidx.annotation.experimental.lint.ExperimentalDetector$Companion.access$issueForLevel(Companion, "ERROR", Severity.ERROR);
    @NotNull
    private static final Issue ISSUE_WARNING = androidx.annotation.experimental.lint.ExperimentalDetector$Companion.access$issueForLevel(Companion, "WARNING", Severity.WARNING);
    @NotNull
    private static final List<Issue> ISSUES;

    public ExperimentalDetector() {
        boolean bl = false;
        this.visitedUsages = new LinkedHashMap();
        this.annotationLookup = new AnnotationLookup();
    }

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{JAVA_EXPERIMENTAL_ANNOTATION, KOTLIN_EXPERIMENTAL_ANNOTATION, JAVA_REQUIRES_OPT_IN_ANNOTATION, KOTLIN_REQUIRES_OPT_IN_ANNOTATION};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"java.lang.Object");
    }

    /*
     * WARNING - void declaration
     */
    public void visitClass(@NotNull JavaContext context, @NotNull ULambdaExpression lambda) {
        UElement superMethod;
        UElement uElement;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        PsiType psiType = lambda.getFunctionalInterfaceType();
        PsiClassReferenceType psiClassReferenceType = psiType instanceof PsiClassReferenceType ? (PsiClassReferenceType)psiType : null;
        PsiClass superClass = psiClassReferenceType == null ? null : psiClassReferenceType.resolve();
        psiType = superClass;
        if (psiType == null) {
            uElement = null;
        } else {
            PsiMethod[] psiMethodArray = psiType.getAllMethods();
            if (psiMethodArray == null) {
                uElement = null;
            } else {
                void element$iv;
                block7: {
                    void $this$first$iv;
                    PsiMethod[] psiMethodArray2 = psiMethodArray;
                    boolean $i$f$first = false;
                    void var10_9 = $this$first$iv;
                    int n = ((void)var10_9).length;
                    for (int i = 0; i < n; ++i) {
                        void method = element$iv = var10_9[i];
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                        if (!ExperimentalDetectorKt.access$isAbstract((PsiModifierListOwner)method)) {
                            continue;
                        }
                        break block7;
                    }
                    throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
                }
                void var7_15 = element$iv;
                uElement = superMethod = var7_15 == null ? null : UastContextKt.toUElement((PsiElement)((PsiElement)var7_15));
            }
        }
        if (superMethod instanceof UMethod) {
            this.checkMethodOverride(context, (UElement)lambda, (PsiMethod)superMethod);
        }
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        UMethod[] $this$forEach$iv = declaration.getMethods();
        boolean $i$f$forEach = false;
        UMethod[] uMethodArray = $this$forEach$iv;
        int n = uMethodArray.length;
        for (int i = 0; i < n; ++i) {
            UMethod element$iv;
            UMethod method = element$iv = uMethodArray[i];
            boolean bl = false;
            JavaEvaluator eval = context.getEvaluator();
            if (!eval.isOverride(method, true)) continue;
            PsiMethod[] psiMethodArray = method.findSuperMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"method.findSuperMethods()");
            Object[] $this$forEach$iv2 = psiMethodArray;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PsiMethod superMethod = (PsiMethod)element$iv2;
                boolean bl2 = false;
                UElement uElement = (UElement)method;
                Intrinsics.checkNotNullExpressionValue((Object)superMethod, (String)"superMethod");
                this.checkMethodOverride(context, uElement, superMethod);
            }
        }
    }

    private final void checkMethodOverride(JavaContext context, UElement usage, PsiMethod superMethod) {
        JavaEvaluator evaluator = context.getEvaluator();
        PsiAnnotation[] allAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)superMethod, true);
        List<UAnnotation> methodAnnotations = this.filterRelevantAnnotations(evaluator, allAnnotations, usage);
        PsiClass containingClass = superMethod.getContainingClass();
        Pair<List<UAnnotation>, List<UAnnotation>> pair = this.getClassAndPkgAnnotations(containingClass, evaluator, usage);
        List classAnnotations = (List)pair.component1();
        List pkgAnnotations = (List)pair.component2();
        this.doCheckMethodOverride(context, superMethod, methodAnnotations, classAnnotations, pkgAnnotations, usage, containingClass);
    }

    private final void doCheckMethodOverride(JavaContext context, PsiMethod superMethod, List<? extends UAnnotation> methodAnnotations, List<? extends UAnnotation> classAnnotations, List<? extends UAnnotation> pkgAnnotations, UElement usage, PsiClass containingClass) {
        Collection collection = methodAnnotations;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.checkAnnotations(context, usage, AnnotationUsageType.METHOD_CALL, superMethod, (PsiElement)superMethod, methodAnnotations, methodAnnotations, classAnnotations, pkgAnnotations, (PsiElement)superMethod);
        }
        if (containingClass != null) {
            collection = classAnnotations;
            bl = false;
            if (!collection.isEmpty()) {
                this.checkAnnotations(context, usage, AnnotationUsageType.METHOD_CALL_CLASS, superMethod, (PsiElement)superMethod, classAnnotations, methodAnnotations, classAnnotations, pkgAnnotations, (PsiElement)containingClass);
            }
        }
        collection = pkgAnnotations;
        bl = false;
        if (!collection.isEmpty()) {
            this.checkAnnotations(context, usage, AnnotationUsageType.METHOD_CALL_PACKAGE, superMethod, (PsiElement)superMethod, pkgAnnotations, methodAnnotations, classAnnotations, pkgAnnotations, null);
        }
    }

    private final void checkAnnotations(JavaContext context, UElement argument, AnnotationUsageType type, PsiMethod method, PsiElement referenced, List<? extends UAnnotation> annotations, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations, List<? extends UAnnotation> packageAnnotations, PsiElement annotated) {
        for (UAnnotation uAnnotation : annotations) {
            String string = uAnnotation.getQualifiedName();
            if (string == null) continue;
            String signature = string;
            List uAnnotations = null;
            PsiAnnotation[] psiAnnotations = null;
            if (!this.isApplicableAnnotationUsage(type)) continue;
            if (annotated != null && !this.inheritAnnotation(signature)) {
                Object object;
                PsiModifierListOwner owner;
                PsiElement psiElement = uAnnotation.getSourcePsi();
                PsiAnnotation psiAnnotation = psiElement instanceof PsiAnnotation ? (PsiAnnotation)psiElement : null;
                PsiAnnotationOwner annotationOwner = psiAnnotation == null ? null : psiAnnotation.getOwner();
                PsiModifierListOwner psiModifierListOwner = owner = annotationOwner instanceof PsiElement ? (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)annotationOwner), PsiModifierListOwner.class) : (PsiModifierListOwner)null;
                if (owner != null) {
                    PsiElement psiElement2;
                    PsiElement annotatedPsi;
                    Object object2 = object = annotated instanceof UElement ? (UElement)annotated : null;
                    PsiElement psiElement3 = object == null ? annotated : (annotatedPsi = (psiElement2 = object.getSourcePsi()) == null ? annotated : psiElement2);
                    if (!Intrinsics.areEqual((Object)owner, (Object)annotatedPsi)) {
                        continue;
                    }
                } else {
                    boolean bl;
                    boolean bl2;
                    ExperimentalDetector experimentalDetector;
                    if (annotated instanceof UAnnotated) {
                        List list;
                        boolean found = false;
                        List list2 = uAnnotations;
                        experimentalDetector = this;
                        bl2 = false;
                        bl = false;
                        ExperimentalDetector $this$checkAnnotations_u24lambda_u2d3 = experimentalDetector;
                        boolean bl3 = false;
                        uAnnotations = list = context.getEvaluator().getAllAnnotations((UAnnotated)annotated, false);
                        object = list.iterator();
                        while (object.hasNext()) {
                            UAnnotation uAnnotation2 = (UAnnotation)object.next();
                            String qualifiedName = uAnnotation2.getQualifiedName();
                            if (!Intrinsics.areEqual((Object)qualifiedName, (Object)signature)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                    if (annotated instanceof PsiModifierListOwner) {
                        PsiAnnotation[] array;
                        boolean found = false;
                        PsiAnnotation[] psiAnnotationArray = psiAnnotations;
                        experimentalDetector = this;
                        bl2 = false;
                        bl = false;
                        ExperimentalDetector $this$checkAnnotations_u24lambda_u2d4 = experimentalDetector;
                        boolean bl4 = false;
                        psiAnnotations = array = context.getEvaluator().getAllAnnotations((PsiModifierListOwner)annotated, false);
                        object = array;
                        int n = ((Object)object).length;
                        for (int i = 0; i < n; ++i) {
                            Object psiAnnotation2 = object[i];
                            String qualifiedName = psiAnnotation2.getQualifiedName();
                            if (!Intrinsics.areEqual((Object)qualifiedName, (Object)signature)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                }
            }
            this.visitAnnotationUsage(context, argument, type, uAnnotation, signature, method, referenced, annotations, allMethodAnnotations, allClassAnnotations, packageAnnotations);
        }
    }

    static /* synthetic */ void checkAnnotations$default(ExperimentalDetector experimentalDetector, JavaContext javaContext, UElement uElement, AnnotationUsageType annotationUsageType, PsiMethod psiMethod, PsiElement psiElement, List list, List list2, List list3, List list4, PsiElement psiElement2, int n, Object object) {
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        experimentalDetector.checkAnnotations(javaContext, uElement, annotationUsageType, psiMethod, psiElement, list, list2, list3, list4, psiElement2);
    }

    private final Pair<List<UAnnotation>, List<UAnnotation>> getClassAndPkgAnnotations(PsiClass containingClass, JavaEvaluator evaluator, UElement context) {
        List<UAnnotation> classAnnotations = null;
        List pkgAnnotations = null;
        if (containingClass != null) {
            List list;
            PsiAnnotation[] annotations = evaluator.getAllAnnotations((PsiModifierListOwner)containingClass, true);
            classAnnotations = this.filterRelevantAnnotations(evaluator, annotations, context);
            PsiPackage pkg = evaluator.getPackage((PsiElement)containingClass);
            if (pkg != null) {
                PsiAnnotation[] annotations2 = evaluator.getAllAnnotations((PsiModifierListOwner)pkg, false);
                list = ExperimentalDetector.filterRelevantAnnotations$default(this, evaluator, annotations2, null, 4, null);
            } else {
                list = CollectionsKt.emptyList();
            }
            pkgAnnotations = list;
        } else {
            classAnnotations = CollectionsKt.emptyList();
            pkgAnnotations = CollectionsKt.emptyList();
        }
        return new Pair((Object)classAnnotations, (Object)pkgAnnotations);
    }

    private final List<UAnnotation> filterRelevantAnnotations(JavaEvaluator evaluator, PsiAnnotation[] annotations, UElement context) {
        List result = null;
        int length = annotations.length;
        if (length == 0) {
            return CollectionsKt.emptyList();
        }
        Object object = annotations;
        int n = 0;
        int n2 = ((PsiAnnotation[])object).length;
        while (n < n2) {
            PsiAnnotation[] innerAnnotations;
            int n3;
            int n4;
            PsiElement psiElement;
            PsiElement cls;
            PsiElement psiElement2;
            PsiElement psiElement3;
            PsiAnnotation annotation = object[n];
            ++n;
            String signature = annotation.getQualifiedName();
            if (signature == null || (StringsKt.startsWith$default((String)signature, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)signature, (String)"java.", (boolean)false, (int)2, null)) && !this.getRelevantAnnotations().contains(signature)) continue;
            if (this.getRelevantAnnotations().contains(signature)) {
                UAnnotation uAnnotation = JavaUAnnotation.Companion.wrap(annotation);
                if (length == 1) {
                    return CollectionsKt.listOf((Object)uAnnotation);
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(uAnnotation);
                continue;
            }
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annotation.getNameReferenceElement();
            PsiElement psiElement4 = psiElement3 = psiJavaCodeReferenceElement == null ? null : psiJavaCodeReferenceElement.resolve();
            if (psiElement3 == null) {
                ExperimentalDetector experimentalDetector = this;
                boolean bl = false;
                boolean bl2 = false;
                ExperimentalDetector $this$filterRelevantAnnotations_u24lambda_u2d5 = experimentalDetector;
                boolean bl3 = false;
                Project project = annotation.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"annotation.project");
                Project project2 = project;
                psiJavaCodeReferenceElement = (PsiElement)JavaPsiFacade.getInstance((Project)project2).findClass(signature, GlobalSearchScope.projectScope((Project)project2));
                if (psiJavaCodeReferenceElement == null) continue;
                psiElement2 = psiJavaCodeReferenceElement;
            } else {
                psiElement2 = psiElement3;
            }
            if (!((cls = (psiElement = psiElement2)) instanceof PsiClass) || !((PsiClass)cls).isAnnotationType() || (n4 = 0) > (n3 = (innerAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false)).length + -1)) continue;
            do {
                int j;
                PsiAnnotation inner;
                String a;
                if ((a = (inner = innerAnnotations[j = n4++]).getQualifiedName()) == null || !this.getRelevantAnnotations().contains(a)) continue;
                if (result == null) {
                    result = new ArrayList(2);
                }
                UAnnotation innerU = this.annotationLookup.findRealAnnotation(inner, (PsiClass)cls, context);
                result.add(innerU);
            } while (n4 <= n3);
        }
        object = result;
        return object == null ? CollectionsKt.emptyList() : object;
    }

    static /* synthetic */ List filterRelevantAnnotations$default(ExperimentalDetector experimentalDetector, JavaEvaluator javaEvaluator, PsiAnnotation[] psiAnnotationArray, UElement uElement, int n, Object object) {
        if ((n & 4) != 0) {
            uElement = null;
        }
        return experimentalDetector.filterRelevantAnnotations(javaEvaluator, psiAnnotationArray, uElement);
    }

    private final List<String> getRelevantAnnotations() {
        return this.applicableAnnotations();
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkNotNullParameter(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkNotNullParameter(allPackageAnnotations, (String)"allPackageAnnotations");
        if (Lint.isKotlin((PsiElement)usage.getSourcePsi()) && type == AnnotationUsageType.FIELD_REFERENCE && referenced instanceof PsiMethod) {
            return;
        }
        switch (qualifiedName) {
            case "androidx.annotation.experimental.Experimental": 
            case "androidx.annotation.RequiresOptIn": {
                Object[] objectArray = new String[]{JAVA_USE_EXPERIMENTAL_ANNOTATION, JAVA_OPT_IN_ANNOTATION};
                this.checkExperimentalUsage(context, annotation, referenced, usage, CollectionsKt.listOf((Object[])objectArray));
                break;
            }
            case "kotlin.RequiresOptIn": 
            case "kotlin.Experimental": {
                if (Lint.isKotlin((PsiElement)usage.getSourcePsi())) break;
                Object[] objectArray = new String[]{KOTLIN_USE_EXPERIMENTAL_ANNOTATION, KOTLIN_OPT_IN_ANNOTATION, JAVA_USE_EXPERIMENTAL_ANNOTATION, JAVA_OPT_IN_ANNOTATION};
                this.checkExperimentalUsage(context, annotation, referenced, usage, CollectionsKt.listOf((Object[])objectArray));
            }
        }
    }

    private final void checkExperimentalUsage(JavaContext context, UAnnotation annotation, PsiElement referenced, UElement usage, List<String> optInFqNames) {
        UElement decl;
        UElement uElement;
        Set visitedAnnotations;
        Set set;
        String string;
        UElement uElement2 = annotation.getUastParent();
        UClass uClass = uElement2 instanceof UClass ? (UClass)uElement2 : null;
        String string2 = string = uClass == null ? null : uClass.getQualifiedName();
        if (string == null) {
            return;
        }
        String annotationFqName = string;
        Map<UElement, Set<String>> $this$getOrPut$iv = this.visitedUsages;
        boolean $i$f$getOrPut22 = false;
        Set value$iv = $this$getOrPut$iv.get(usage);
        if (value$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(usage, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        if (!(visitedAnnotations = set).add((String)annotationFqName)) {
            return;
        }
        UElement $i$f$getOrPut22 = UastContextKt.toUElement((PsiElement)referenced);
        if ($i$f$getOrPut22 == null) {
            UElement uElement3 = ExperimentalDetectorKt.access$getReferencedElement(usage);
            if (uElement3 == null) {
                return;
            }
            uElement = uElement3;
        } else {
            uElement = decl = $i$f$getOrPut22;
        }
        if (!this.isExperimentalityRequired(decl, context, annotationFqName)) {
            return;
        }
        if (this.isExperimentalityAccepted(usage, context, annotationFqName, optInFqNames)) {
            return;
        }
        String level = AnnotationRetentionDetectorKt.extractAttribute(annotation, context, "level", ENUM_ERROR);
        if (level != null) {
            this.report(context, usage, annotationFqName, "This declaration is opt-in and its usage should be marked with `@" + annotationFqName + "` or `@OptIn(markerClass = " + annotationFqName + ".class)`", level);
        } else {
            this.report(context, usage, annotationFqName, "Failed to read `level` from `@" + annotationFqName + "` -- assuming `ERROR`. This declaration is opt-in and its usage should be marked with `@" + annotationFqName + "` or `@OptIn(markerClass = " + annotationFqName + ".class)`", ENUM_ERROR);
        }
    }

    private final boolean isExperimentalityRequired(UElement $this$isExperimentalityRequired, JavaContext context, String annotationFqName) {
        UClass uClass;
        if (ExperimentalDetectorKt.access$isDeclarationAnnotatedWith($this$isExperimentalityRequired, annotationFqName)) {
            return true;
        }
        UElement uElement = $this$isExperimentalityRequired.getUastParent();
        UClass uClass2 = uClass = uElement instanceof UClass ? (UClass)uElement : null;
        if (uClass == null ? false : this.isExperimentalityRequired((UElement)uClass, context, annotationFqName)) {
            return true;
        }
        uClass = context.getEvaluator().getPackage($this$isExperimentalityRequired);
        return (uClass == null ? null : uClass.getAnnotation(annotationFqName)) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExperimentalityAccepted(UElement $this$isExperimentalityAccepted, JavaContext context, String annotationFqName, List<String> optInFqNames) {
        boolean bl;
        boolean bl2;
        Configuration config = context.getConfiguration();
        String string = Configuration.getOption$default((Configuration)config, (Issue)ISSUE_ERROR, (String)"opt-in", null, (int)4, null);
        if (string == null) {
            bl2 = false;
        } else {
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)annotationFqName, (boolean)false, (int)2, null)) {
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        string = Configuration.getOption$default((Configuration)config, (Issue)ISSUE_WARNING, (String)"opt-in", null, (int)4, null);
        if (string == null) {
            bl = false;
        } else {
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)annotationFqName, (boolean)false, (int)2, null)) {
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        UElement $this$anyParentMatches_u24default$iv = $this$isExperimentalityAccepted;
        boolean defaultValue$iv = false;
        boolean $i$f$anyParentMatches = false;
        UElement element$iv = $this$anyParentMatches_u24default$iv;
        while (true) {
            UElement element = element$iv;
            boolean bl3 = false;
            if (ExperimentalDetectorKt.access$isDeclarationAnnotatedWith(element, annotationFqName)) return true;
            if (ExperimentalDetectorKt.access$isDeclarationAnnotatedWithOptInOf(element, annotationFqName, optInFqNames)) {
                return true;
            }
            boolean bl4 = false;
            if (bl4) {
                return true;
            }
            UElement it = element$iv;
            if (false) {
                return false;
            }
            UElement uElement = element$iv.getUastParent();
            if (uElement == null) break;
            element$iv = uElement;
        }
        boolean bl5 = defaultValue$iv;
        if (!bl5) return false;
        return true;
    }

    private final void report(JavaContext context, UElement usage, String annotation, String message, String level) {
        block7: {
            Issue issue;
            String string = level;
            if (Intrinsics.areEqual((Object)string, (Object)ENUM_ERROR)) {
                issue = ISSUE_ERROR;
            } else if (Intrinsics.areEqual((Object)string, (Object)ENUM_WARNING)) {
                issue = ISSUE_WARNING;
            } else {
                throw new IllegalArgumentException("Level was \"" + level + "\" but must be one of: ERROR, WARNING");
            }
            Issue issue2 = issue;
            try {
                string = Configuration.getOption$default((Configuration)context.getConfiguration(), (Issue)issue2, (String)"opt-in", null, (int)4, null);
                if (!(string == null ? false : StringsKt.contains$default((CharSequence)string, (CharSequence)annotation, (boolean)false, (int)2, null))) {
                    JavaContext.report$default((JavaContext)context, (Issue)issue2, (UElement)usage, (Location)context.getNameLocation(usage), (String)StringsKt.trimIndent((String)message), null, (int)16, null);
                }
            }
            catch (UnsupportedOperationException e) {
                if (Intrinsics.areEqual((Object)"Method not implemented", (Object)e.getMessage())) break block7;
                throw e;
            }
        }
    }

    static {
        Object[] objectArray = new Issue[]{ISSUE_ERROR, ISSUE_WARNING};
        ISSUES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/annotation/experimental/lint/ExperimentalDetector$Companion;", "", "()V", "ENUM_ERROR", "", "ENUM_WARNING", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUES", "", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUES", "()Ljava/util/List;", "ISSUE_ERROR", "getISSUE_ERROR", "()Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_WARNING", "getISSUE_WARNING", "JAVA_EXPERIMENTAL_ANNOTATION", "JAVA_OPT_IN_ANNOTATION", "JAVA_REQUIRES_OPT_IN_ANNOTATION", "JAVA_USE_EXPERIMENTAL_ANNOTATION", "KOTLIN_EXPERIMENTAL_ANNOTATION", "KOTLIN_OPT_IN_ANNOTATION", "KOTLIN_REQUIRES_OPT_IN_ANNOTATION", "KOTLIN_USE_EXPERIMENTAL_ANNOTATION", "issueForLevel", "levelEnum", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "annotation-experimental-lint"})
    public static final class Companion {
        private Companion() {
        }

        private final Issue issueForLevel(String levelEnum, Severity severity) {
            String levelText = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)levelEnum);
            String issueId = Intrinsics.stringPlus((String)"UnsafeOptInUsage", (Object)CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)levelText));
            return Issue.Companion.create(issueId, "Unsafe opt-in usage intended to be " + levelText + "-level severity", "\n                This API has been flagged as opt-in with " + levelText + "-level severity.\n\n                Any declaration annotated with this marker is considered part of an unstable or\n                otherwise non-standard API surface and its call sites should accept the opt-in\n                aspect of it by using the `@OptIn` annotation, using the marker annotation --\n                effectively causing further propagation of the opt-in aspect -- or configuring\n                the `" + issueId + "` check's options for project-wide opt-in.\n\n                To configure project-wide opt-in, specify the `opt-in` option value in `lint.xml`\n                as a comma-delimited list of opted-in annotations:\n\n                ```\n                <lint>\n                    <issue id=\"" + issueId + "\">\n                        <option name=\"opt-in\" value=\"com.foo.ExperimentalBarAnnotation\" />\n                    </issue>\n                </lint>\n                ```\n                ", Category.CORRECTNESS, 4, severity, IMPLEMENTATION);
        }

        @NotNull
        public final Issue getISSUE_ERROR() {
            return ISSUE_ERROR;
        }

        @NotNull
        public final Issue getISSUE_WARNING() {
            return ISSUE_WARNING;
        }

        @NotNull
        public final List<Issue> getISSUES() {
            return ISSUES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Issue access$issueForLevel(Companion $this, String levelEnum, Severity severity) {
            return $this.issueForLevel(levelEnum, severity);
        }
    }
}

