/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.util;

import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class StringUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static StringBuilder newStringBuilder() {
        return new StringBuilder();
    }

    public static void appendPlaceholders(StringBuilder builder, int count) {
        for (int i = 0; i < count; ++i) {
            builder.append("?");
            if (i >= count - 1) continue;
            builder.append(",");
        }
    }

    @Nullable
    public static List<Integer> splitToIntList(@Nullable String input) {
        if (input == null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(input, ",");
        while (tokenizer.hasMoreElements()) {
            String item = tokenizer.nextToken();
            try {
                result.add(Integer.parseInt(item));
            }
            catch (NumberFormatException ex) {
                Log.e((String)"ROOM", (String)"Malformed integer list", (Throwable)ex);
            }
        }
        return result;
    }

    @Nullable
    public static String joinIntoString(@Nullable List<Integer> input) {
        if (input == null) {
            return null;
        }
        int size = input.size();
        if (size == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(Integer.toString(input.get(i)));
            if (i >= size - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

