/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room;

import android.arch.persistence.db.SimpleSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.room.DatabaseConfiguration;
import android.arch.persistence.room.RoomMasterTable;
import android.arch.persistence.room.migration.Migration;
import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RoomOpenHelper
extends SupportSQLiteOpenHelper.Callback {
    @Nullable
    private DatabaseConfiguration mConfiguration;
    @NonNull
    private final Delegate mDelegate;
    @NonNull
    private final String mIdentityHash;

    public RoomOpenHelper(@NonNull DatabaseConfiguration configuration, @NonNull Delegate delegate, @NonNull String identityHash) {
        super(delegate.version);
        this.mConfiguration = configuration;
        this.mDelegate = delegate;
        this.mIdentityHash = identityHash;
    }

    public void onConfigure(SupportSQLiteDatabase db) {
        super.onConfigure(db);
    }

    public void onCreate(SupportSQLiteDatabase db) {
        this.updateIdentity(db);
        this.mDelegate.createAllTables(db);
        this.mDelegate.onCreate(db);
    }

    public void onUpgrade(SupportSQLiteDatabase db, int oldVersion, int newVersion) {
        List<Migration> migrations;
        boolean migrated = false;
        if (this.mConfiguration != null && (migrations = this.mConfiguration.migrationContainer.findMigrationPath(oldVersion, newVersion)) != null) {
            for (Migration migration : migrations) {
                migration.migrate(db);
            }
            this.mDelegate.validateMigration(db);
            this.updateIdentity(db);
            migrated = true;
        }
        if (!migrated) {
            if (this.mConfiguration == null || this.mConfiguration.requireMigration) {
                throw new IllegalStateException("A migration from " + oldVersion + " to " + newVersion + " is necessary. Please provide a Migration in the builder or call" + " fallbackToDestructiveMigration in the builder in which case Room will" + " re-create all of the tables.");
            }
            this.mDelegate.dropAllTables(db);
            this.mDelegate.createAllTables(db);
        }
    }

    public void onDowngrade(SupportSQLiteDatabase db, int oldVersion, int newVersion) {
        this.onUpgrade(db, oldVersion, newVersion);
    }

    public void onOpen(SupportSQLiteDatabase db) {
        super.onOpen(db);
        this.checkIdentity(db);
        this.mDelegate.onOpen(db);
        this.mConfiguration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIdentity(SupportSQLiteDatabase db) {
        this.createMasterTableIfNotExists(db);
        String identityHash = "";
        try (Cursor cursor = db.query((SupportSQLiteQuery)new SimpleSQLiteQuery("SELECT identity_hash FROM room_master_table WHERE id = 42 LIMIT 1"));){
            if (cursor.moveToFirst()) {
                identityHash = cursor.getString(0);
            }
        }
        if (!this.mIdentityHash.equals(identityHash)) {
            throw new IllegalStateException("Room cannot verify the data integrity. Looks like you've changed schema but forgot to update the version number. You can simply fix this by increasing the version number.");
        }
    }

    private void updateIdentity(SupportSQLiteDatabase db) {
        this.createMasterTableIfNotExists(db);
        db.execSQL(RoomMasterTable.createInsertQuery((String)this.mIdentityHash));
    }

    private void createMasterTableIfNotExists(SupportSQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static abstract class Delegate {
        public final int version;

        public Delegate(int version) {
            this.version = version;
        }

        protected abstract void dropAllTables(SupportSQLiteDatabase var1);

        protected abstract void createAllTables(SupportSQLiteDatabase var1);

        protected abstract void onOpen(SupportSQLiteDatabase var1);

        protected abstract void onCreate(SupportSQLiteDatabase var1);

        protected abstract void validateMigration(SupportSQLiteDatabase var1);
    }
}

