/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service.web_search;

import ai.z.openapi.AbstractAiClient;
import ai.z.openapi.api.tools.ToolsApi;
import ai.z.openapi.api.web_search.WebSearchApi;
import ai.z.openapi.service.tools.WebSearchApiResponse;
import ai.z.openapi.service.tools.WebSearchParamsRequest;
import ai.z.openapi.service.tools.WebSearchPro;
import ai.z.openapi.service.web_search.WebSearchRequest;
import ai.z.openapi.service.web_search.WebSearchResponse;
import ai.z.openapi.service.web_search.WebSearchService;
import ai.z.openapi.utils.FlowableRequestSupplier;
import ai.z.openapi.utils.RequestSupplier;
import retrofit2.Call;

public class WebSearchServiceImpl
implements WebSearchService {
    private final AbstractAiClient zAiClient;
    private final ToolsApi toolsApi;
    private final WebSearchApi webSearchApi;

    public WebSearchServiceImpl(AbstractAiClient zAiClient) {
        this.zAiClient = zAiClient;
        this.toolsApi = (ToolsApi)zAiClient.retrofit().create(ToolsApi.class);
        this.webSearchApi = (WebSearchApi)zAiClient.retrofit().create(WebSearchApi.class);
    }

    @Override
    public WebSearchApiResponse createWebSearchProStream(WebSearchParamsRequest request) {
        FlowableRequestSupplier<WebSearchParamsRequest, Call> supplier = this.toolsApi::webSearchStreaming;
        return this.zAiClient.streamRequest(request, supplier, WebSearchApiResponse.class, WebSearchPro.class);
    }

    @Override
    public WebSearchApiResponse createWebSearchPro(WebSearchParamsRequest request) {
        RequestSupplier supplier = this.toolsApi::webSearch;
        return this.zAiClient.executeRequest(request, supplier, WebSearchApiResponse.class);
    }

    @Override
    public WebSearchResponse createWebSearch(WebSearchRequest request) {
        RequestSupplier supplier = this.webSearchApi::webSearch;
        return this.zAiClient.executeRequest(request, supplier, WebSearchResponse.class);
    }
}

