/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service.realtime.object;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Objects;

@JsonSerialize(using=ToolChoiceObjSerializer.class)
@JsonDeserialize(using=ToolChoiceObjDeserializer.class)
public class ToolChoiceObj {
    private final String optStr;
    private final ToolObj optObj;

    private ToolChoiceObj(String optStr, ToolObj optObj) {
        this.optStr = optStr;
        this.optObj = optObj;
    }

    public static ToolChoiceObj of(String strValue) {
        if (!(strValue == null || "none".equalsIgnoreCase(strValue) || "auto".equalsIgnoreCase(strValue) || "required".equalsIgnoreCase(strValue))) {
            return null;
        }
        return new ToolChoiceObj(strValue, null);
    }

    public static ToolChoiceObj of(ToolObj objValue) {
        if (objValue != null && objValue.getType() == null) {
            return null;
        }
        return new ToolChoiceObj(null, objValue);
    }

    public String toString() {
        if (this.optStr != null) {
            return this.optStr;
        }
        if (this.optObj != null) {
            return this.optObj.toString();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolChoiceObj that = (ToolChoiceObj)o;
        return Objects.equals(this.optStr, that.optStr) && Objects.equals(this.optObj, that.optObj);
    }

    public int hashCode() {
        return Objects.hash(this.optStr, this.optObj);
    }

    public String getOptStr() {
        return this.optStr;
    }

    public ToolObj getOptObj() {
        return this.optObj;
    }

    public static class ToolChoiceObjDeserializer
    extends JsonDeserializer<ToolChoiceObj> {
        public ToolChoiceObj deserialize(JsonParser p, DeserializationContext context) {
            JsonToken token = p.currentToken();
            if (token == JsonToken.VALUE_NULL) {
                return null;
            }
            try {
                if (token == JsonToken.VALUE_STRING) {
                    String text = p.getText().toLowerCase();
                    if ("none".equals(text) || "auto".equals(text) || "required".equals(text)) {
                        return ToolChoiceObj.of(text);
                    }
                    return null;
                }
                if (token == JsonToken.START_OBJECT) {
                    ToolObj tool = new ToolObj();
                    while (p.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = p.currentName();
                        p.nextToken();
                        if ("type".equals(fieldName)) {
                            tool.setType(p.getText());
                            continue;
                        }
                        if (!"function".equals(fieldName) || p.currentToken() != JsonToken.START_OBJECT) continue;
                        tool.setType("function");
                        while (p.nextToken() != JsonToken.END_OBJECT) {
                            if (!"name".equals(p.currentName())) continue;
                            p.nextToken();
                            tool.setFunctionName(p.getText());
                        }
                    }
                    return tool.getType() != null ? ToolChoiceObj.of(tool) : null;
                }
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }
    }

    public static class ToolChoiceObjSerializer
    extends JsonSerializer<ToolChoiceObj> {
        public void serialize(ToolChoiceObj value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value.getOptStr() != null) {
                gen.writeString(value.getOptStr());
            } else if (value.getOptObj() != null) {
                gen.writeRawValue(value.getOptObj().toString());
            } else {
                gen.writeNull();
            }
        }
    }

    public static class ToolObj {
        private String type;
        private String functionName;

        public String toString() {
            if ("function".equalsIgnoreCase(this.type)) {
                return "{\"type\": \"function\", \"function\": {\"name\": \"" + this.functionName + "\"}}";
            }
            return "{\"type\": \"" + this.type + "\"}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ToolObj tool = (ToolObj)o;
            return Objects.equals(this.type, tool.type) && Objects.equals(this.functionName, tool.functionName);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.functionName);
        }

        public String getType() {
            return this.type;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setFunctionName(String functionName) {
            this.functionName = functionName;
        }
    }
}

