/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service.model;

import ai.z.openapi.service.model.Audio;
import ai.z.openapi.service.model.ToolCalls;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class ChatMessage {
    private String role;
    private Object content;
    @JsonProperty(value="reasoning_content")
    private String reasoningContent;
    private Audio audio;
    private String name;
    @JsonProperty(value="tool_calls")
    private List<ToolCalls> toolCalls;
    @JsonProperty(value="tool_call_id")
    private String toolCallId;

    public ChatMessage(String role, Object content) {
        this.setRole(role);
        this.setContent(content);
    }

    public static ChatMessageBuilder builder() {
        return new ChatMessageBuilder();
    }

    public String getRole() {
        return this.role;
    }

    public Object getContent() {
        return this.content;
    }

    public String getReasoningContent() {
        return this.reasoningContent;
    }

    public Audio getAudio() {
        return this.audio;
    }

    public String getName() {
        return this.name;
    }

    public List<ToolCalls> getToolCalls() {
        return this.toolCalls;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    @JsonProperty(value="reasoning_content")
    public void setReasoningContent(String reasoningContent) {
        this.reasoningContent = reasoningContent;
    }

    public void setAudio(Audio audio) {
        this.audio = audio;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="tool_calls")
    public void setToolCalls(List<ToolCalls> toolCalls) {
        this.toolCalls = toolCalls;
    }

    @JsonProperty(value="tool_call_id")
    public void setToolCallId(String toolCallId) {
        this.toolCallId = toolCallId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        Object this$content = this.getContent();
        Object other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$reasoningContent = this.getReasoningContent();
        String other$reasoningContent = other.getReasoningContent();
        if (this$reasoningContent == null ? other$reasoningContent != null : !this$reasoningContent.equals(other$reasoningContent)) {
            return false;
        }
        Audio this$audio = this.getAudio();
        Audio other$audio = other.getAudio();
        if (this$audio == null ? other$audio != null : !((Object)this$audio).equals(other$audio)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ToolCalls> this$toolCalls = this.getToolCalls();
        List<ToolCalls> other$toolCalls = other.getToolCalls();
        if (this$toolCalls == null ? other$toolCalls != null : !((Object)this$toolCalls).equals(other$toolCalls)) {
            return false;
        }
        String this$toolCallId = this.getToolCallId();
        String other$toolCallId = other.getToolCallId();
        return !(this$toolCallId == null ? other$toolCallId != null : !this$toolCallId.equals(other$toolCallId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        Object $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $reasoningContent = this.getReasoningContent();
        result = result * 59 + ($reasoningContent == null ? 43 : $reasoningContent.hashCode());
        Audio $audio = this.getAudio();
        result = result * 59 + ($audio == null ? 43 : ((Object)$audio).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ToolCalls> $toolCalls = this.getToolCalls();
        result = result * 59 + ($toolCalls == null ? 43 : ((Object)$toolCalls).hashCode());
        String $toolCallId = this.getToolCallId();
        result = result * 59 + ($toolCallId == null ? 43 : $toolCallId.hashCode());
        return result;
    }

    public String toString() {
        return "ChatMessage(role=" + this.getRole() + ", content=" + this.getContent() + ", reasoningContent=" + this.getReasoningContent() + ", audio=" + this.getAudio() + ", name=" + this.getName() + ", toolCalls=" + this.getToolCalls() + ", toolCallId=" + this.getToolCallId() + ")";
    }

    public ChatMessage(String role, Object content, String reasoningContent, Audio audio, String name, List<ToolCalls> toolCalls, String toolCallId) {
        this.role = role;
        this.content = content;
        this.reasoningContent = reasoningContent;
        this.audio = audio;
        this.name = name;
        this.toolCalls = toolCalls;
        this.toolCallId = toolCallId;
    }

    public ChatMessage() {
    }

    public static class ChatMessageBuilder {
        private String role;
        private Object content;
        private String reasoningContent;
        private Audio audio;
        private String name;
        private List<ToolCalls> toolCalls;
        private String toolCallId;

        ChatMessageBuilder() {
        }

        public ChatMessageBuilder role(String role) {
            this.role = role;
            return this;
        }

        public ChatMessageBuilder content(Object content) {
            this.content = content;
            return this;
        }

        @JsonProperty(value="reasoning_content")
        public ChatMessageBuilder reasoningContent(String reasoningContent) {
            this.reasoningContent = reasoningContent;
            return this;
        }

        public ChatMessageBuilder audio(Audio audio) {
            this.audio = audio;
            return this;
        }

        public ChatMessageBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="tool_calls")
        public ChatMessageBuilder toolCalls(List<ToolCalls> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        @JsonProperty(value="tool_call_id")
        public ChatMessageBuilder toolCallId(String toolCallId) {
            this.toolCallId = toolCallId;
            return this;
        }

        public ChatMessage build() {
            return new ChatMessage(this.role, this.content, this.reasoningContent, this.audio, this.name, this.toolCalls, this.toolCallId);
        }

        public String toString() {
            return "ChatMessage.ChatMessageBuilder(role=" + this.role + ", content=" + this.content + ", reasoningContent=" + this.reasoningContent + ", audio=" + this.audio + ", name=" + this.name + ", toolCalls=" + this.toolCalls + ", toolCallId=" + this.toolCallId + ")";
        }
    }
}

