/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service.file;

import ai.z.openapi.AbstractAiClient;
import ai.z.openapi.api.file.FileApi;
import ai.z.openapi.core.response.HttpxBinaryResponseContent;
import ai.z.openapi.service.file.FileApiResponse;
import ai.z.openapi.service.file.FileListParams;
import ai.z.openapi.service.file.FileService;
import ai.z.openapi.service.file.FileUploadParams;
import ai.z.openapi.service.file.QueryFileApiResponse;
import ai.z.openapi.utils.RequestSupplier;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class FileServiceImpl
implements FileService {
    private final AbstractAiClient zAiClient;
    private final FileApi fileApi;

    public FileServiceImpl(AbstractAiClient zAiClient) {
        this.zAiClient = zAiClient;
        this.fileApi = (FileApi)zAiClient.retrofit().create(FileApi.class);
    }

    @Override
    public FileApiResponse uploadFile(FileUploadParams request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getFilePath() == null) {
            throw new IllegalArgumentException("request path cannot be null");
        }
        RequestSupplier supplier = params -> {
            try {
                File file = new File(params.getFilePath());
                if (!file.exists()) {
                    throw new RuntimeException("file not found");
                }
                MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file));
                MultipartBody.Builder formBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
                formBodyBuilder.addPart(filePart);
                formBodyBuilder.addFormDataPart("purpose", params.getPurpose());
                if (params.getExtraJson() != null) {
                    for (String s : params.getExtraJson().keySet()) {
                        if (params.getExtraJson().get(s) instanceof String || params.getExtraJson().get(s) instanceof Number || params.getExtraJson().get(s) instanceof Boolean || params.getExtraJson().get(s) instanceof Character) {
                            formBodyBuilder.addFormDataPart(s, params.getExtraJson().get(s).toString());
                            continue;
                        }
                        if (!(params.getExtraJson().get(s) instanceof Date)) continue;
                        Date date = (Date)params.getExtraJson().get(s);
                        formBodyBuilder.addFormDataPart(s, String.valueOf(date.getTime()));
                    }
                }
                MultipartBody multipartBody = formBodyBuilder.build();
                return this.fileApi.uploadFile(multipartBody);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        return this.zAiClient.executeRequest(request, supplier, FileApiResponse.class);
    }

    @Override
    public QueryFileApiResponse listFiles(FileListParams queryFilesRequest) {
        RequestSupplier supplier = params -> this.fileApi.queryFileList(params.getAfter(), params.getPurpose(), params.getOrder(), params.getLimit());
        return this.zAiClient.executeRequest(queryFilesRequest, supplier, QueryFileApiResponse.class);
    }

    @Override
    public HttpxBinaryResponseContent retrieveFileContent(String fileId) throws IOException {
        return this.fileWrapper(this.fileApi.fileContent(fileId));
    }

    private HttpxBinaryResponseContent fileWrapper(Call<ResponseBody> response) throws IOException {
        Response execute = response.execute();
        if (!execute.isSuccessful() || execute.body() == null) {
            throw new IOException("Failed to get the file content");
        }
        return new HttpxBinaryResponseContent((Response<ResponseBody>)execute);
    }
}

