/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service.deserialize.assistant.message;

import ai.z.openapi.service.assistant.message.MessageContent;
import ai.z.openapi.service.assistant.message.TextContentBlock;
import ai.z.openapi.service.assistant.message.tools.ToolsType;
import ai.z.openapi.service.deserialize.JsonTypeField;
import ai.z.openapi.service.deserialize.JsonTypeMapping;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.List;

public class MessageContentDeserializer
extends JsonDeserializer<MessageContent> {
    public MessageContent deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        JsonTypeMapping mapping = MessageContent.class.getAnnotation(JsonTypeMapping.class);
        if (mapping == null) {
            throw new IllegalStateException("Missing JsonTypeMapping annotation on MessageContent class");
        }
        for (Class<?> clazz : mapping.value()) {
            JsonTypeField typeField = clazz.getAnnotation(JsonTypeField.class);
            if (typeField == null || !node.has(typeField.value())) continue;
            try {
                Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Field field : clazz.getDeclaredFields()) {
                    field.setAccessible(true);
                    JsonProperty annotation = field.getAnnotation(JsonProperty.class);
                    String name = null;
                    name = annotation == null ? field.getName() : annotation.value();
                    if (!node.has(name)) continue;
                    if (field.getType().equals(String.class)) {
                        field.set(obj, node.get(name).asText());
                        continue;
                    }
                    if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
                        field.set(obj, node.get(name).asInt());
                        continue;
                    }
                    if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                        field.set(obj, node.get(name).asBoolean());
                        continue;
                    }
                    if (List.class.isAssignableFrom(field.getType())) {
                        ParameterizedType listType = (ParameterizedType)field.getGenericType();
                        Class listGenericType = (Class)listType.getActualTypeArguments()[0];
                        if (listGenericType.equals(ToolsType.class)) {
                            List list = (List)new ObjectMapper().readerForListOf(ToolsType.class).readValue(node.get(name));
                            field.set(obj, list);
                            continue;
                        }
                        throw new IllegalArgumentException("Unsupported generic list type: " + listGenericType);
                    }
                    throw new IllegalArgumentException("Unsupported field type: " + field.getType());
                }
                return (MessageContent)obj;
            }
            catch (Exception e) {
                throw new RuntimeException("Error while creating instance of " + clazz.getName(), e);
            }
        }
        try {
            MessageContent obj = (MessageContent)TextContentBlock.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : TextContentBlock.class.getDeclaredFields()) {
                field.setAccessible(true);
                JsonProperty annotation = field.getAnnotation(JsonProperty.class);
                String name = null;
                name = annotation == null ? field.getName() : annotation.value();
                if (!node.has(name)) continue;
                if (field.getType().equals(String.class)) {
                    field.set(obj, node.get(name).asText());
                    continue;
                }
                if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
                    field.set(obj, node.get(name).asInt());
                    continue;
                }
                if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                    field.set(obj, node.get(name).asBoolean());
                    continue;
                }
                Object o = new ObjectMapper().treeToValue((TreeNode)node.get(name), field.getType());
                field.set(obj, o);
            }
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating instance of " + TextContentBlock.class.getName(), e);
        }
    }
}

