/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service.chat;

import ai.z.openapi.AbstractAiClient;
import ai.z.openapi.api.chat.ChatApi;
import ai.z.openapi.service.chat.ChatService;
import ai.z.openapi.service.model.AsyncResultRetrieveParams;
import ai.z.openapi.service.model.ChatCompletionCreateParams;
import ai.z.openapi.service.model.ChatCompletionResponse;
import ai.z.openapi.service.model.ChatRequestWithHeaders;
import ai.z.openapi.service.model.ModelData;
import ai.z.openapi.service.model.QueryModelResultResponse;
import ai.z.openapi.utils.FlowableRequestSupplier;
import ai.z.openapi.utils.RequestSupplier;
import java.util.Map;
import java.util.Objects;
import retrofit2.Call;

public class ChatServiceImpl
implements ChatService {
    private final AbstractAiClient zAiClient;
    private final ChatApi chatApi;

    public ChatServiceImpl(AbstractAiClient zAiClient) {
        this.zAiClient = zAiClient;
        this.chatApi = (ChatApi)this.zAiClient.retrofit().create(ChatApi.class);
    }

    @Override
    public ChatCompletionResponse createChatCompletion(ChatCompletionCreateParams request) {
        this.validateParams(request);
        if (Objects.nonNull(request.getStream()) && request.getStream().booleanValue()) {
            return this.streamChatCompletion(request);
        }
        return this.syncChatCompletion(request);
    }

    @Override
    public ChatCompletionResponse asyncChatCompletion(ChatCompletionCreateParams request) {
        RequestSupplier supplier = this.chatApi::createChatCompletionAsync;
        return this.zAiClient.executeRequest(request, supplier, ChatCompletionResponse.class);
    }

    @Override
    public QueryModelResultResponse retrieveAsyncResult(AsyncResultRetrieveParams request) {
        RequestSupplier supplier = params -> this.chatApi.queryAsyncResult(params.getTaskId());
        return this.zAiClient.executeRequest(request, supplier, QueryModelResultResponse.class);
    }

    private ChatCompletionResponse streamChatCompletion(ChatCompletionCreateParams request) {
        FlowableRequestSupplier<ChatCompletionCreateParams, Call> supplier = this.chatApi::createChatCompletionStream;
        return this.zAiClient.streamRequest(request, supplier, ChatCompletionResponse.class, ModelData.class);
    }

    private ChatCompletionResponse syncChatCompletion(ChatCompletionCreateParams request) {
        RequestSupplier supplier = this.chatApi::createChatCompletion;
        return this.zAiClient.executeRequest(request, supplier, ChatCompletionResponse.class);
    }

    @Override
    public ChatCompletionResponse createChatCompletion(ChatCompletionCreateParams request, Map<String, String> customHeaders) {
        if (Objects.isNull(customHeaders)) {
            throw new IllegalArgumentException("customHeaders can not be null");
        }
        this.validateParams(request);
        if (Objects.nonNull(request.getStream()) && request.getStream().booleanValue()) {
            return this.streamChatCompletionWithHeaders(request, customHeaders);
        }
        return this.syncChatCompletionWithHeaders(request, customHeaders);
    }

    private ChatCompletionResponse streamChatCompletionWithHeaders(ChatCompletionCreateParams request, Map<String, String> customHeaders) {
        ChatRequestWithHeaders requestWithHeaders = new ChatRequestWithHeaders(request, customHeaders);
        FlowableRequestSupplier<ChatRequestWithHeaders, Call> supplier = wrapper -> this.chatApi.createChatCompletionStream(wrapper.getRequest(), wrapper.getCustomHeaders());
        return this.zAiClient.streamRequest(requestWithHeaders, supplier, ChatCompletionResponse.class, ModelData.class);
    }

    private ChatCompletionResponse syncChatCompletionWithHeaders(ChatCompletionCreateParams request, Map<String, String> customHeaders) {
        ChatRequestWithHeaders requestWithHeaders = new ChatRequestWithHeaders(request, customHeaders);
        RequestSupplier supplier = wrapper -> this.chatApi.createChatCompletion(wrapper.getRequest(), wrapper.getCustomHeaders());
        return this.zAiClient.executeRequest(requestWithHeaders, supplier, ChatCompletionResponse.class);
    }

    private void validateParams(ChatCompletionCreateParams request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getMessages() == null || request.getMessages().isEmpty()) {
            throw new IllegalArgumentException("request messages cannot be null or empty");
        }
        if (request.getModel() == null) {
            throw new IllegalArgumentException("request model cannot be null");
        }
    }
}

