/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service.assistant;

import ai.z.openapi.AbstractAiClient;
import ai.z.openapi.api.assistant.AssistantApi;
import ai.z.openapi.service.assistant.AssistantApiResponse;
import ai.z.openapi.service.assistant.AssistantCompletion;
import ai.z.openapi.service.assistant.AssistantParameters;
import ai.z.openapi.service.assistant.AssistantService;
import ai.z.openapi.service.assistant.conversation.ConversationParameters;
import ai.z.openapi.service.assistant.conversation.ConversationUsageListResponse;
import ai.z.openapi.service.assistant.query_support.AssistantSupportResponse;
import ai.z.openapi.service.assistant.query_support.QuerySupportParams;
import ai.z.openapi.utils.FlowableRequestSupplier;
import ai.z.openapi.utils.RequestSupplier;
import retrofit2.Call;

public class AssistantServiceImpl
implements AssistantService {
    private final AbstractAiClient zAiClient;
    private final AssistantApi assistantApi;

    public AssistantServiceImpl(AbstractAiClient zAiClient) {
        this.zAiClient = zAiClient;
        this.assistantApi = (AssistantApi)zAiClient.retrofit().create(AssistantApi.class);
    }

    @Override
    public AssistantApiResponse assistantCompletionStream(AssistantParameters request) {
        FlowableRequestSupplier<AssistantParameters, Call> supplier = this.assistantApi::assistantCompletionStream;
        return this.zAiClient.streamRequest(request, supplier, AssistantApiResponse.class, AssistantCompletion.class);
    }

    @Override
    public AssistantApiResponse assistantCompletion(AssistantParameters request) {
        RequestSupplier supplier = this.assistantApi::assistantCompletion;
        return this.zAiClient.executeRequest(request, supplier, AssistantApiResponse.class);
    }

    @Override
    public AssistantSupportResponse querySupport(QuerySupportParams request) {
        RequestSupplier supplier = this.assistantApi::querySupport;
        return this.zAiClient.executeRequest(request, supplier, AssistantSupportResponse.class);
    }

    @Override
    public ConversationUsageListResponse queryConversationUsage(ConversationParameters request) {
        RequestSupplier supplier = this.assistantApi::queryConversationUsage;
        return this.zAiClient.executeRequest(request, supplier, ConversationUsageListResponse.class);
    }
}

