/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service.agents;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AgentContent {
    private String type;
    private String text;
    @JsonProperty(value="image_url")
    private String imageUrl;
    @JsonProperty(value="video_url")
    private String videoUrl;
    @JsonProperty(value="object")
    private Object object;

    public static AgentContent ofText(String text) {
        return AgentContent.builder().type("text").text(text).build();
    }

    public static AgentContent ofImageUrl(String imageUrl) {
        return AgentContent.builder().type("image_url").imageUrl(imageUrl).build();
    }

    public static AgentContent ofVideoUrl(String videoUrl) {
        return AgentContent.builder().type("video_url").videoUrl(videoUrl).build();
    }

    public static AgentContent ofObject(Object object) {
        return AgentContent.builder().type("object").object(object).build();
    }

    public static AgentContentBuilder builder() {
        return new AgentContentBuilder();
    }

    public String getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getVideoUrl() {
        return this.videoUrl;
    }

    public Object getObject() {
        return this.object;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setText(String text) {
        this.text = text;
    }

    @JsonProperty(value="image_url")
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @JsonProperty(value="video_url")
    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    @JsonProperty(value="object")
    public void setObject(Object object) {
        this.object = object;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentContent)) {
            return false;
        }
        AgentContent other = (AgentContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        String this$videoUrl = this.getVideoUrl();
        String other$videoUrl = other.getVideoUrl();
        if (this$videoUrl == null ? other$videoUrl != null : !this$videoUrl.equals(other$videoUrl)) {
            return false;
        }
        Object this$object = this.getObject();
        Object other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgentContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        String $videoUrl = this.getVideoUrl();
        result = result * 59 + ($videoUrl == null ? 43 : $videoUrl.hashCode());
        Object $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    public String toString() {
        return "AgentContent(type=" + this.getType() + ", text=" + this.getText() + ", imageUrl=" + this.getImageUrl() + ", videoUrl=" + this.getVideoUrl() + ", object=" + this.getObject() + ")";
    }

    public AgentContent() {
    }

    public AgentContent(String type, String text, String imageUrl, String videoUrl, Object object) {
        this.type = type;
        this.text = text;
        this.imageUrl = imageUrl;
        this.videoUrl = videoUrl;
        this.object = object;
    }

    public static class AgentContentBuilder {
        private String type;
        private String text;
        private String imageUrl;
        private String videoUrl;
        private Object object;

        AgentContentBuilder() {
        }

        public AgentContentBuilder type(String type) {
            this.type = type;
            return this;
        }

        public AgentContentBuilder text(String text) {
            this.text = text;
            return this;
        }

        @JsonProperty(value="image_url")
        public AgentContentBuilder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        @JsonProperty(value="video_url")
        public AgentContentBuilder videoUrl(String videoUrl) {
            this.videoUrl = videoUrl;
            return this;
        }

        @JsonProperty(value="object")
        public AgentContentBuilder object(Object object) {
            this.object = object;
            return this;
        }

        public AgentContent build() {
            return new AgentContent(this.type, this.text, this.imageUrl, this.videoUrl, this.object);
        }

        public String toString() {
            return "AgentContent.AgentContentBuilder(type=" + this.type + ", text=" + this.text + ", imageUrl=" + this.imageUrl + ", videoUrl=" + this.videoUrl + ", object=" + this.object + ")";
        }
    }
}

