/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service;

import ai.z.openapi.core.model.BiFlowableClientResponse;
import ai.z.openapi.core.model.ClientRequest;
import ai.z.openapi.core.model.ClientResponse;
import ai.z.openapi.core.model.FlowableClientResponse;
import ai.z.openapi.service.deserialize.MessageDeserializeFactory;
import ai.z.openapi.service.model.ResponseBodyCallback;
import ai.z.openapi.service.model.SSE;
import ai.z.openapi.service.model.ZAiError;
import ai.z.openapi.service.model.ZAiHttpException;
import ai.z.openapi.utils.FlowableRequestSupplier;
import ai.z.openapi.utils.RequestSupplier;
import ai.z.openapi.utils.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Single;
import java.io.IOException;
import java.util.Objects;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;

public abstract class AbstractClientBaseService {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractClientBaseService.class);
    protected static final ObjectMapper mapper = MessageDeserializeFactory.defaultObjectMapper();

    public abstract <Data, Param, TReq extends ClientRequest<Param>, TResp extends ClientResponse<Data>> TResp executeRequest(TReq var1, RequestSupplier<Param, Data> var2, Class<TResp> var3);

    public abstract <Data, F, Param, TReq extends ClientRequest<Param>, TResp extends BiFlowableClientResponse<Data, F>> TResp biStreamRequest(TReq var1, FlowableRequestSupplier<Param, Call<ResponseBody>> var2, Class<TResp> var3, Class<F> var4);

    public <T, Param, TReq extends ClientRequest<Param>, TResp extends FlowableClientResponse<T>> TResp streamRequest(TReq request, FlowableRequestSupplier<Param, Call<ResponseBody>> requestSupplier, Class<TResp> tRespClass, Class<T> tClass) {
        return (TResp)((FlowableClientResponse)this.biStreamRequest(request, requestSupplier, tRespClass, tClass));
    }

    public static <T> T execute(Single<T> apiCall) {
        try {
            Object response = apiCall.blockingGet();
            if (response instanceof Response) {
                AbstractClientBaseService.handleResponse((Response)response);
            }
            return (T)response;
        }
        catch (HttpException e) {
            logger.error("HTTP exception: {}", (Object)e.getMessage());
            if (e.response() == null || e.response().errorBody() == null) {
                throw e;
            }
            try {
                ResponseBody responseBody = Objects.requireNonNull(e.response()).errorBody();
                Throwable throwable = null;
                try {
                    try {
                        if (responseBody == null) {
                            throw e;
                        }
                        String errorBody = responseBody.string();
                        if (StringUtils.isEmpty(errorBody)) {
                            throw e;
                        }
                        ZAiError error = (ZAiError)mapper.readValue(errorBody, ZAiError.class);
                        throw new ZAiHttpException(error, (Exception)((Object)e), e.code());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (responseBody != null) {
                        if (throwable != null) {
                            try {
                                responseBody.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            responseBody.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (IOException ex) {
                throw e;
            }
        }
    }

    private static void handleResponse(Response<?> response) {
        if (!response.isSuccessful()) {
            throw new HttpException(response);
        }
    }

    public <T> Flowable<T> stream(Call<ResponseBody> apiCall, Class<T> cl) {
        return AbstractClientBaseService.stream(apiCall).map(sse -> mapper.readValue(sse.getData(), cl));
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall) {
        return AbstractClientBaseService.stream(apiCall, false);
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall, boolean emitDone) {
        return Flowable.create(emitter -> apiCall.enqueue((Callback)new ResponseBodyCallback((FlowableEmitter<SSE>)emitter, emitDone)), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }
}

