/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.core.token;

import ai.z.openapi.core.cache.ICache;
import ai.z.openapi.core.config.ZaiConfig;
import ai.z.openapi.utils.StringUtils;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenManager {
    private static final Logger logger = LoggerFactory.getLogger(TokenManager.class);
    private final ICache cache;
    private static final String TOKEN_KEY_PREFIX = "zai_oapi_token";
    private static final Long DELAY_EXPIRE_TIME = 300000L;

    public TokenManager(ICache cache) {
        this.cache = cache;
    }

    public String getToken(ZaiConfig config) {
        String tokenCacheKey = this.genTokenCacheKey(config.getApiId());
        String cacheToken = this.cache.get(tokenCacheKey);
        if (StringUtils.isNotEmpty(cacheToken)) {
            return cacheToken;
        }
        String newToken = TokenManager.createJwt(config);
        this.cache.set(tokenCacheKey, newToken, config.getExpireMillis(), TimeUnit.MILLISECONDS);
        return newToken;
    }

    private static String createJwt(ZaiConfig config) {
        Algorithm alg;
        String algId = config.getAlg();
        if ("HS256".equals(algId)) {
            try {
                alg = Algorithm.HMAC256((byte[])config.getApiSecret().getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                logger.error("Failed to create HMAC256 algorithm", (Throwable)e);
                return null;
            }
        } else {
            logger.error("Algorithm: {} not supported", (Object)algId);
            return null;
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("api_key", config.getApiId());
        payload.put("exp", System.currentTimeMillis() + (long)config.getExpireMillis() + DELAY_EXPIRE_TIME);
        payload.put("timestamp", Calendar.getInstance().getTimeInMillis());
        HashMap<String, String> headerClaims = new HashMap<String, String>();
        headerClaims.put("alg", "HS256");
        headerClaims.put("sign_type", "SIGN");
        return JWT.create().withPayload(payload).withHeader(headerClaims).sign(alg);
    }

    private String genTokenCacheKey(String apiKey) {
        return String.format("%s-%s", TOKEN_KEY_PREFIX, apiKey);
    }
}

