/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.core.token;

import ai.z.openapi.core.config.ZaiConfig;
import ai.z.openapi.core.token.GlobalTokenManager;
import ai.z.openapi.core.token.TokenManager;
import ai.z.openapi.utils.StringUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HttpRequestInterceptor
implements Interceptor {
    private final ZaiConfig config;

    public HttpRequestInterceptor(ZaiConfig config) {
        Objects.requireNonNull(config.getApiKey(), "Z.ai token required");
        this.config = config;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String accessToken;
        if (this.config.isDisableTokenCache()) {
            accessToken = this.config.getApiKey();
        } else {
            TokenManager tokenManager = GlobalTokenManager.getTokenManagerV4();
            accessToken = tokenManager.getToken(this.config);
        }
        String source_channel = "z-ai-sdk-java";
        if (StringUtils.isNotEmpty(this.config.getSource_channel())) {
            source_channel = this.config.getSource_channel();
        }
        Request.Builder request = chain.request().newBuilder().header("Authorization", "Bearer " + accessToken).header("x-source-channel", source_channel).header("Zai-SDK-Ver", "0.0.3").header("Accept-Language", "en-US,en");
        if (Objects.nonNull(this.config.getCustomHeaders())) {
            for (Map.Entry<String, String> entry : this.config.getCustomHeaders().entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return chain.proceed(request.build());
    }
}

