/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.core.config;

import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ZaiConfig {
    private static final String ENV_BASE_URL = "ZAI_BASE_URL";
    private static final String ENV_API_KEY = "ZAI_API_KEY";
    private static final String ENV_EXPIRE_MILLIS = "ZAI_EXPIRE_MILLIS";
    private static final String ENV_ALG = "ZAI_ALG";
    private static final String ENV_DISABLE_TOKEN_CACHE = "ZAI_DISABLE_TOKEN_CACHE";
    private static final String ENV_CONNECTION_POOL_MAX_IDLE = "ZAI_CONNECTION_POOL_MAX_IDLE";
    private static final String ENV_CONNECTION_POOL_KEEP_ALIVE = "ZAI_CONNECTION_POOL_KEEP_ALIVE";
    private static final String ENV_REQUEST_TIMEOUT = "ZAI_REQUEST_TIMEOUT";
    private static final String ENV_CONNECT_TIMEOUT = "ZAI_CONNECT_TIMEOUT";
    private static final String ENV_READ_TIMEOUT = "ZAI_READ_TIMEOUT";
    private static final String ENV_WRITE_TIMEOUT = "ZAI_WRITE_TIMEOUT";
    private String baseUrl;
    private String apiKey;
    private String apiId;
    private String apiSecret;
    private Map<String, String> customHeaders;
    private int expireMillis;
    private String alg;
    private boolean disableTokenCache;
    private int connectionPoolMaxIdleConnections;
    private long connectionPoolKeepAliveDuration;
    private TimeUnit connectionPoolTimeUnit;
    private int requestTimeOut;
    private int connectTimeout;
    private int readTimeout;
    private int writeTimeout;
    private TimeUnit timeOutTimeUnit;
    private String source_channel;

    public ZaiConfig(String apiKey) {
        this.apiKey = apiKey;
        String[] arrStr = apiKey.split("\\.");
        if (arrStr.length != 2) {
            throw new RuntimeException("invalid apiSecretKey");
        }
        this.apiId = arrStr[0];
        this.apiSecret = arrStr[1];
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
        String[] arrStr = apiKey.split("\\.");
        if (arrStr.length != 2) {
            throw new RuntimeException("invalid api Key");
        }
        this.apiId = arrStr[0];
        this.apiSecret = arrStr[1];
    }

    public String getBaseUrl() {
        if (this.baseUrl != null) {
            return this.baseUrl;
        }
        String propValue = System.getProperty(ENV_BASE_URL);
        propValue = propValue != null ? propValue : System.getenv(ENV_BASE_URL);
        return propValue != null ? propValue : "https://api.z.ai/api/paas/v4/";
    }

    public String getApiKey() {
        String value;
        if (this.apiKey != null && !this.apiKey.isEmpty()) {
            return this.apiKey;
        }
        String propValue = System.getProperty(ENV_API_KEY);
        String string = value = propValue != null ? propValue : System.getenv(ENV_API_KEY);
        if (value != null && !value.isEmpty()) {
            this.apiKey = value;
            String[] arrStr = value.split("\\.");
            if (arrStr.length == 2) {
                this.apiId = arrStr[0];
                this.apiSecret = arrStr[1];
            }
            return value;
        }
        return this.apiKey;
    }

    public String getApiId() {
        if (this.apiId != null && !this.apiId.isEmpty()) {
            return this.apiId;
        }
        this.getApiKey();
        return this.apiId;
    }

    public String getApiSecret() {
        if (this.apiSecret != null && !this.apiSecret.isEmpty()) {
            return this.apiSecret;
        }
        this.getApiKey();
        return this.apiSecret;
    }

    public int getExpireMillis() {
        String value;
        if (this.expireMillis != 1800000) {
            return this.expireMillis;
        }
        String propValue = System.getProperty(ENV_EXPIRE_MILLIS);
        String string = value = propValue != null ? propValue : System.getenv(ENV_EXPIRE_MILLIS);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.expireMillis;
    }

    public String getAlg() {
        if (!"HS256".equals(this.alg)) {
            return this.alg;
        }
        String propValue = System.getProperty(ENV_ALG);
        String value = propValue != null ? propValue : System.getenv(ENV_ALG);
        return value != null ? value : this.alg;
    }

    public boolean isDisableTokenCache() {
        if (this.disableTokenCache) {
            return true;
        }
        String propValue = System.getProperty(ENV_DISABLE_TOKEN_CACHE);
        String value = propValue != null ? propValue : System.getenv(ENV_DISABLE_TOKEN_CACHE);
        return Boolean.parseBoolean(value);
    }

    public int getConnectionPoolMaxIdleConnections() {
        String value;
        if (this.connectionPoolMaxIdleConnections != 5) {
            return this.connectionPoolMaxIdleConnections;
        }
        String propValue = System.getProperty(ENV_CONNECTION_POOL_MAX_IDLE);
        String string = value = propValue != null ? propValue : System.getenv(ENV_CONNECTION_POOL_MAX_IDLE);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.connectionPoolMaxIdleConnections;
    }

    public long getConnectionPoolKeepAliveDuration() {
        String value;
        if (this.connectionPoolKeepAliveDuration != 1L) {
            return this.connectionPoolKeepAliveDuration;
        }
        String propValue = System.getProperty(ENV_CONNECTION_POOL_KEEP_ALIVE);
        String string = value = propValue != null ? propValue : System.getenv(ENV_CONNECTION_POOL_KEEP_ALIVE);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.connectionPoolKeepAliveDuration;
    }

    public TimeUnit getConnectionPoolTimeUnit() {
        return this.connectionPoolTimeUnit != null ? this.connectionPoolTimeUnit : TimeUnit.SECONDS;
    }

    public int getRequestTimeOut() {
        String value;
        if (this.requestTimeOut != 300) {
            return this.requestTimeOut;
        }
        String propValue = System.getProperty(ENV_REQUEST_TIMEOUT);
        String string = value = propValue != null ? propValue : System.getenv(ENV_REQUEST_TIMEOUT);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.requestTimeOut;
    }

    public int getConnectTimeout() {
        String value;
        if (this.connectTimeout != 100) {
            return this.connectTimeout;
        }
        String propValue = System.getProperty(ENV_CONNECT_TIMEOUT);
        String string = value = propValue != null ? propValue : System.getenv(ENV_CONNECT_TIMEOUT);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        String value;
        if (this.readTimeout != 100) {
            return this.readTimeout;
        }
        String propValue = System.getProperty(ENV_READ_TIMEOUT);
        String string = value = propValue != null ? propValue : System.getenv(ENV_READ_TIMEOUT);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        String value;
        if (this.writeTimeout != 100) {
            return this.writeTimeout;
        }
        String propValue = System.getProperty(ENV_WRITE_TIMEOUT);
        String string = value = propValue != null ? propValue : System.getenv(ENV_WRITE_TIMEOUT);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.writeTimeout;
    }

    public TimeUnit getTimeOutTimeUnit() {
        return this.timeOutTimeUnit;
    }

    public String getSource_channel() {
        return this.source_channel;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    private static int $default$expireMillis() {
        return 1800000;
    }

    private static String $default$alg() {
        return "HS256";
    }

    private static int $default$connectionPoolMaxIdleConnections() {
        return 5;
    }

    private static long $default$connectionPoolKeepAliveDuration() {
        return 1L;
    }

    private static TimeUnit $default$connectionPoolTimeUnit() {
        return TimeUnit.SECONDS;
    }

    private static int $default$requestTimeOut() {
        return 300;
    }

    private static int $default$connectTimeout() {
        return 100;
    }

    private static int $default$readTimeout() {
        return 100;
    }

    private static int $default$writeTimeout() {
        return 100;
    }

    private static TimeUnit $default$timeOutTimeUnit() {
        return TimeUnit.SECONDS;
    }

    private static String $default$source_channel() {
        return "java-sdk";
    }

    public static ZaiConfigBuilder builder() {
        return new ZaiConfigBuilder();
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public void setExpireMillis(int expireMillis) {
        this.expireMillis = expireMillis;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    public void setDisableTokenCache(boolean disableTokenCache) {
        this.disableTokenCache = disableTokenCache;
    }

    public void setConnectionPoolMaxIdleConnections(int connectionPoolMaxIdleConnections) {
        this.connectionPoolMaxIdleConnections = connectionPoolMaxIdleConnections;
    }

    public void setConnectionPoolKeepAliveDuration(long connectionPoolKeepAliveDuration) {
        this.connectionPoolKeepAliveDuration = connectionPoolKeepAliveDuration;
    }

    public void setConnectionPoolTimeUnit(TimeUnit connectionPoolTimeUnit) {
        this.connectionPoolTimeUnit = connectionPoolTimeUnit;
    }

    public void setRequestTimeOut(int requestTimeOut) {
        this.requestTimeOut = requestTimeOut;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setTimeOutTimeUnit(TimeUnit timeOutTimeUnit) {
        this.timeOutTimeUnit = timeOutTimeUnit;
    }

    public void setSource_channel(String source_channel) {
        this.source_channel = source_channel;
    }

    public ZaiConfig() {
        this.expireMillis = ZaiConfig.$default$expireMillis();
        this.alg = ZaiConfig.$default$alg();
        this.connectionPoolMaxIdleConnections = ZaiConfig.$default$connectionPoolMaxIdleConnections();
        this.connectionPoolKeepAliveDuration = ZaiConfig.$default$connectionPoolKeepAliveDuration();
        this.connectionPoolTimeUnit = ZaiConfig.$default$connectionPoolTimeUnit();
        this.requestTimeOut = ZaiConfig.$default$requestTimeOut();
        this.connectTimeout = ZaiConfig.$default$connectTimeout();
        this.readTimeout = ZaiConfig.$default$readTimeout();
        this.writeTimeout = ZaiConfig.$default$writeTimeout();
        this.timeOutTimeUnit = ZaiConfig.$default$timeOutTimeUnit();
        this.source_channel = ZaiConfig.$default$source_channel();
    }

    public ZaiConfig(String baseUrl, String apiKey, String apiId, String apiSecret, Map<String, String> customHeaders, int expireMillis, String alg, boolean disableTokenCache, int connectionPoolMaxIdleConnections, long connectionPoolKeepAliveDuration, TimeUnit connectionPoolTimeUnit, int requestTimeOut, int connectTimeout, int readTimeout, int writeTimeout, TimeUnit timeOutTimeUnit, String source_channel) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.apiId = apiId;
        this.apiSecret = apiSecret;
        this.customHeaders = customHeaders;
        this.expireMillis = expireMillis;
        this.alg = alg;
        this.disableTokenCache = disableTokenCache;
        this.connectionPoolMaxIdleConnections = connectionPoolMaxIdleConnections;
        this.connectionPoolKeepAliveDuration = connectionPoolKeepAliveDuration;
        this.connectionPoolTimeUnit = connectionPoolTimeUnit;
        this.requestTimeOut = requestTimeOut;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.timeOutTimeUnit = timeOutTimeUnit;
        this.source_channel = source_channel;
    }

    public static class ZaiConfigBuilder {
        private String baseUrl;
        private String apiKey;
        private String apiId;
        private String apiSecret;
        private Map<String, String> customHeaders;
        private boolean expireMillis$set;
        private int expireMillis$value;
        private boolean alg$set;
        private String alg$value;
        private boolean disableTokenCache;
        private boolean connectionPoolMaxIdleConnections$set;
        private int connectionPoolMaxIdleConnections$value;
        private boolean connectionPoolKeepAliveDuration$set;
        private long connectionPoolKeepAliveDuration$value;
        private boolean connectionPoolTimeUnit$set;
        private TimeUnit connectionPoolTimeUnit$value;
        private boolean requestTimeOut$set;
        private int requestTimeOut$value;
        private boolean connectTimeout$set;
        private int connectTimeout$value;
        private boolean readTimeout$set;
        private int readTimeout$value;
        private boolean writeTimeout$set;
        private int writeTimeout$value;
        private boolean timeOutTimeUnit$set;
        private TimeUnit timeOutTimeUnit$value;
        private boolean source_channel$set;
        private String source_channel$value;

        ZaiConfigBuilder() {
        }

        public ZaiConfigBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public ZaiConfigBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public ZaiConfigBuilder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public ZaiConfigBuilder apiSecret(String apiSecret) {
            this.apiSecret = apiSecret;
            return this;
        }

        public ZaiConfigBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public ZaiConfigBuilder expireMillis(int expireMillis) {
            this.expireMillis$value = expireMillis;
            this.expireMillis$set = true;
            return this;
        }

        public ZaiConfigBuilder alg(String alg) {
            this.alg$value = alg;
            this.alg$set = true;
            return this;
        }

        public ZaiConfigBuilder disableTokenCache(boolean disableTokenCache) {
            this.disableTokenCache = disableTokenCache;
            return this;
        }

        public ZaiConfigBuilder connectionPoolMaxIdleConnections(int connectionPoolMaxIdleConnections) {
            this.connectionPoolMaxIdleConnections$value = connectionPoolMaxIdleConnections;
            this.connectionPoolMaxIdleConnections$set = true;
            return this;
        }

        public ZaiConfigBuilder connectionPoolKeepAliveDuration(long connectionPoolKeepAliveDuration) {
            this.connectionPoolKeepAliveDuration$value = connectionPoolKeepAliveDuration;
            this.connectionPoolKeepAliveDuration$set = true;
            return this;
        }

        public ZaiConfigBuilder connectionPoolTimeUnit(TimeUnit connectionPoolTimeUnit) {
            this.connectionPoolTimeUnit$value = connectionPoolTimeUnit;
            this.connectionPoolTimeUnit$set = true;
            return this;
        }

        public ZaiConfigBuilder requestTimeOut(int requestTimeOut) {
            this.requestTimeOut$value = requestTimeOut;
            this.requestTimeOut$set = true;
            return this;
        }

        public ZaiConfigBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout$value = connectTimeout;
            this.connectTimeout$set = true;
            return this;
        }

        public ZaiConfigBuilder readTimeout(int readTimeout) {
            this.readTimeout$value = readTimeout;
            this.readTimeout$set = true;
            return this;
        }

        public ZaiConfigBuilder writeTimeout(int writeTimeout) {
            this.writeTimeout$value = writeTimeout;
            this.writeTimeout$set = true;
            return this;
        }

        public ZaiConfigBuilder timeOutTimeUnit(TimeUnit timeOutTimeUnit) {
            this.timeOutTimeUnit$value = timeOutTimeUnit;
            this.timeOutTimeUnit$set = true;
            return this;
        }

        public ZaiConfigBuilder source_channel(String source_channel) {
            this.source_channel$value = source_channel;
            this.source_channel$set = true;
            return this;
        }

        public ZaiConfig build() {
            int expireMillis$value = this.expireMillis$value;
            if (!this.expireMillis$set) {
                expireMillis$value = ZaiConfig.$default$expireMillis();
            }
            String alg$value = this.alg$value;
            if (!this.alg$set) {
                alg$value = ZaiConfig.$default$alg();
            }
            int connectionPoolMaxIdleConnections$value = this.connectionPoolMaxIdleConnections$value;
            if (!this.connectionPoolMaxIdleConnections$set) {
                connectionPoolMaxIdleConnections$value = ZaiConfig.$default$connectionPoolMaxIdleConnections();
            }
            long connectionPoolKeepAliveDuration$value = this.connectionPoolKeepAliveDuration$value;
            if (!this.connectionPoolKeepAliveDuration$set) {
                connectionPoolKeepAliveDuration$value = ZaiConfig.$default$connectionPoolKeepAliveDuration();
            }
            TimeUnit connectionPoolTimeUnit$value = this.connectionPoolTimeUnit$value;
            if (!this.connectionPoolTimeUnit$set) {
                connectionPoolTimeUnit$value = ZaiConfig.$default$connectionPoolTimeUnit();
            }
            int requestTimeOut$value = this.requestTimeOut$value;
            if (!this.requestTimeOut$set) {
                requestTimeOut$value = ZaiConfig.$default$requestTimeOut();
            }
            int connectTimeout$value = this.connectTimeout$value;
            if (!this.connectTimeout$set) {
                connectTimeout$value = ZaiConfig.$default$connectTimeout();
            }
            int readTimeout$value = this.readTimeout$value;
            if (!this.readTimeout$set) {
                readTimeout$value = ZaiConfig.$default$readTimeout();
            }
            int writeTimeout$value = this.writeTimeout$value;
            if (!this.writeTimeout$set) {
                writeTimeout$value = ZaiConfig.$default$writeTimeout();
            }
            TimeUnit timeOutTimeUnit$value = this.timeOutTimeUnit$value;
            if (!this.timeOutTimeUnit$set) {
                timeOutTimeUnit$value = ZaiConfig.$default$timeOutTimeUnit();
            }
            String source_channel$value = this.source_channel$value;
            if (!this.source_channel$set) {
                source_channel$value = ZaiConfig.$default$source_channel();
            }
            return new ZaiConfig(this.baseUrl, this.apiKey, this.apiId, this.apiSecret, this.customHeaders, expireMillis$value, alg$value, this.disableTokenCache, connectionPoolMaxIdleConnections$value, connectionPoolKeepAliveDuration$value, connectionPoolTimeUnit$value, requestTimeOut$value, connectTimeout$value, readTimeout$value, writeTimeout$value, timeOutTimeUnit$value, source_channel$value);
        }

        public String toString() {
            return "ZaiConfig.ZaiConfigBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", apiId=" + this.apiId + ", apiSecret=" + this.apiSecret + ", customHeaders=" + this.customHeaders + ", expireMillis$value=" + this.expireMillis$value + ", alg$value=" + this.alg$value + ", disableTokenCache=" + this.disableTokenCache + ", connectionPoolMaxIdleConnections$value=" + this.connectionPoolMaxIdleConnections$value + ", connectionPoolKeepAliveDuration$value=" + this.connectionPoolKeepAliveDuration$value + ", connectionPoolTimeUnit$value=" + (Object)((Object)this.connectionPoolTimeUnit$value) + ", requestTimeOut$value=" + this.requestTimeOut$value + ", connectTimeout$value=" + this.connectTimeout$value + ", readTimeout$value=" + this.readTimeout$value + ", writeTimeout$value=" + this.writeTimeout$value + ", timeOutTimeUnit$value=" + (Object)((Object)this.timeOutTimeUnit$value) + ", source_channel$value=" + this.source_channel$value + ")";
        }
    }
}

