/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi;

import ai.z.openapi.AbstractAiClient;
import ai.z.openapi.core.config.ZaiConfig;
import ai.z.openapi.utils.StringUtils;

public class ZaiClient
extends AbstractAiClient {
    public ZaiClient(ZaiConfig config) {
        super(config, StringUtils.isEmpty(config.getBaseUrl()) ? "https://api.z.ai/api/paas/v4/" : config.getBaseUrl());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder ofZHIPU(String apiKey) {
        return ((Builder)new Builder().apiKey(apiKey)).ofZHIPU();
    }

    public static Builder ofZHIPU() {
        return new Builder().ofZHIPU();
    }

    public static class Builder
    extends AbstractAiClient.AbstractBuilder<ZaiClient, Builder> {
        public Builder() {
        }

        public Builder(String apiKey) {
            super(apiKey);
        }

        public Builder(String baseUrl, String apiKey) {
            super(baseUrl, apiKey);
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder ofZHIPU() {
            this.config.setBaseUrl("https://open.bigmodel.cn/api/paas/v4/");
            return this;
        }

        public Builder ofZAI() {
            this.config.setBaseUrl("https://api.z.ai/api/paas/v4/");
            return this;
        }

        @Override
        public ZaiClient build() {
            return new ZaiClient(this.config);
        }
    }
}

