/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.test.impl.score.stream;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintFactory;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.test.api.score.stream.ConstraintVerifier;
import ai.timefold.solver.test.impl.score.stream.ConfiguredConstraintVerifier;
import ai.timefold.solver.test.impl.score.stream.DefaultMultiConstraintVerification;
import ai.timefold.solver.test.impl.score.stream.DefaultSingleConstraintVerification;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.jspecify.annotations.NonNull;

public final class DefaultConstraintVerifier<ConstraintProvider_ extends ConstraintProvider, Solution_, Score_ extends Score<Score_>>
implements ConstraintVerifier<ConstraintProvider_, Solution_> {
    private final ConstraintProvider_ constraintProvider;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final AtomicReference<ConfiguredConstraintVerifier<ConstraintProvider_, Solution_, Score_>> configuredConstraintVerifierRef = new AtomicReference();

    public DefaultConstraintVerifier(ConstraintProvider_ constraintProvider, SolutionDescriptor<Solution_> solutionDescriptor) {
        this.constraintProvider = constraintProvider;
        this.solutionDescriptor = solutionDescriptor;
    }

    public @NonNull DefaultSingleConstraintVerification<Solution_, Score_> verifyThat(@NonNull BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction) {
        return this.getOrCreateConfiguredConstraintVerifier().verifyThat(constraintFunction);
    }

    private ConfiguredConstraintVerifier<ConstraintProvider_, Solution_, Score_> getOrCreateConfiguredConstraintVerifier() {
        return this.configuredConstraintVerifierRef.updateAndGet(v -> {
            if (v == null) {
                return new ConfiguredConstraintVerifier(this.constraintProvider, this.solutionDescriptor);
            }
            return v;
        });
    }

    public @NonNull DefaultMultiConstraintVerification<Solution_, Score_> verifyThat() {
        return this.getOrCreateConfiguredConstraintVerifier().verifyThat();
    }
}

