/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.test.impl.score.stream;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirector;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.test.api.score.stream.MultiConstraintAssertion;
import ai.timefold.solver.test.api.score.stream.ShadowVariableAwareMultiConstraintAssertion;
import ai.timefold.solver.test.impl.score.stream.AbstractMultiConstraintAssertion;
import java.util.Objects;

public final class DefaultShadowVariableAwareMultiConstraintAssertion<Solution_, Score_ extends Score<Score_>>
extends AbstractMultiConstraintAssertion<Solution_, Score_>
implements ShadowVariableAwareMultiConstraintAssertion {
    private final AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_, ?> scoreDirectorFactory;
    private final Solution_ solution;

    DefaultShadowVariableAwareMultiConstraintAssertion(ConstraintProvider constraintProvider, AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_, ?> scoreDirectorFactory, Solution_ solution) {
        super(constraintProvider, scoreDirectorFactory);
        this.scoreDirectorFactory = Objects.requireNonNull(scoreDirectorFactory);
        this.solution = Objects.requireNonNull(solution);
    }

    @Override
    public MultiConstraintAssertion settingAllShadowVariables() {
        try (AbstractScoreDirector scoreDirector = this.scoreDirectorFactory.createScoreDirectorBuilder().withConstraintMatchPolicy(ConstraintMatchPolicy.ENABLED).buildDerived();){
            scoreDirector.setWorkingSolution(this.solution);
            scoreDirector.forceTriggerVariableListeners();
            this.update(scoreDirector.calculateScore(), scoreDirector.getConstraintMatchTotalMap(), scoreDirector.getIndictmentMap());
            this.toggleInitialized();
            DefaultShadowVariableAwareMultiConstraintAssertion defaultShadowVariableAwareMultiConstraintAssertion = this;
            return defaultShadowVariableAwareMultiConstraintAssertion;
        }
    }

    @Override
    Solution_ getSolution() {
        return this.solution;
    }
}

