/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.test.impl.score.stream;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import ai.timefold.solver.core.impl.score.DefaultScoreExplanation;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraint;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.stream.common.ScoreImpactType;
import ai.timefold.solver.core.impl.util.Pair;
import ai.timefold.solver.test.api.score.stream.SingleConstraintAssertion;
import ai.timefold.solver.test.impl.score.stream.AbstractConstraintAssertion;
import ai.timefold.solver.test.impl.score.stream.NumberEqualityUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractSingleConstraintAssertion<Solution_, Score_ extends Score<Score_>>
extends AbstractConstraintAssertion<Solution_, Score_>
implements SingleConstraintAssertion {
    private final AbstractConstraint<Solution_, ?, ?> constraint;
    private final ScoreDefinition<Score_> scoreDefinition;
    private Score_ score;
    private Collection<ConstraintMatchTotal<Score_>> constraintMatchTotalCollection;
    private Collection<ConstraintJustification> justificationCollection;
    private Collection<Indictment<Score_>> indictmentCollection;

    AbstractSingleConstraintAssertion(AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_, ?> scoreDirectorFactory) {
        super(scoreDirectorFactory);
        this.constraint = (AbstractConstraint)scoreDirectorFactory.getConstraintMetaModel().getConstraints().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Impossible state: no constraint found."));
        this.scoreDefinition = scoreDirectorFactory.getScoreDefinition();
    }

    @Override
    final void update(Score_ score, Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap, Map<Object, Indictment<Score_>> indictmentMap) {
        this.score = (Score)Objects.requireNonNull(score);
        this.constraintMatchTotalCollection = new ArrayList<ConstraintMatchTotal<Score_>>(Objects.requireNonNull(constraintMatchTotalMap).values());
        this.indictmentCollection = new ArrayList<Indictment<Score_>>(Objects.requireNonNull(indictmentMap).values());
        this.justificationCollection = this.constraintMatchTotalCollection.stream().flatMap(c -> c.getConstraintMatchSet().stream()).map(c -> c.getJustification()).distinct().toList();
        this.toggleInitialized();
    }

    @Override
    public @NonNull SingleConstraintAssertion justifiesWith(String message, ConstraintJustification ... justifications) {
        this.ensureInitialized();
        this.assertJustification(message, false, justifications);
        return this;
    }

    @Override
    public @NonNull SingleConstraintAssertion indictsWith(@Nullable String message, Object ... indictments) {
        this.ensureInitialized();
        this.assertIndictments(message, false, indictments);
        return this;
    }

    @Override
    public @NonNull SingleConstraintAssertion justifiesWithExactly(@Nullable String message, ConstraintJustification ... justifications) {
        this.ensureInitialized();
        this.assertJustification(message, true, justifications);
        return this;
    }

    @Override
    public @NonNull SingleConstraintAssertion indictsWithExactly(@Nullable String message, Object ... indictments) {
        this.ensureInitialized();
        this.assertIndictments(message, true, indictments);
        return this;
    }

    @Override
    public void penalizesBy(@Nullable String message, int matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesBy(@Nullable String message, long matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesBy(@Nullable String message, @NonNull BigDecimal matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizes(@Nullable String message, long times) {
        this.ensureInitialized();
        this.assertMatchCount(ScoreImpactType.PENALTY, times, message);
    }

    @Override
    public void penalizes(@Nullable String message) {
        this.ensureInitialized();
        this.assertMatch(ScoreImpactType.PENALTY, message);
    }

    @Override
    public void rewardsWith(@Nullable String message, int matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewardsWith(@Nullable String message, long matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewardsWith(@Nullable String message, @NonNull BigDecimal matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    private static void validateMatchWeighTotal(Number matchWeightTotal) {
        if (matchWeightTotal.doubleValue() < 0.0) {
            throw new IllegalArgumentException("The matchWeightTotal (%s) must be positive.".formatted(matchWeightTotal));
        }
    }

    @Override
    public void rewards(@Nullable String message, long times) {
        this.ensureInitialized();
        this.assertMatchCount(ScoreImpactType.REWARD, times, message);
    }

    @Override
    public void rewards(String message) {
        this.ensureInitialized();
        this.assertMatch(ScoreImpactType.REWARD, message);
    }

    @Override
    public void penalizesByMoreThan(@Nullable String message, int matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateMatchWeighTotal(matchWeightTotal);
        this.assertMoreThanImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesByMoreThan(String message, long matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateMatchWeighTotal(matchWeightTotal);
        this.assertMoreThanImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesByMoreThan(@Nullable String message, @NonNull BigDecimal matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateMatchWeighTotal(matchWeightTotal);
        this.assertMoreThanImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesMoreThan(@Nullable String message, long times) {
        this.ensureInitialized();
        this.assertMoreThanMatchCount(ScoreImpactType.PENALTY, times, message);
    }

    @Override
    public void rewardsWithMoreThan(@Nullable String message, int matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateMatchWeighTotal(matchWeightTotal);
        this.assertMoreThanImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewardsWithMoreThan(@Nullable String message, long matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateMatchWeighTotal(matchWeightTotal);
        this.assertMoreThanImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewardsWithMoreThan(@Nullable String message, @NonNull BigDecimal matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateMatchWeighTotal(matchWeightTotal);
        this.assertMoreThanImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewardsMoreThan(@Nullable String message, long times) {
        this.ensureInitialized();
        this.assertMoreThanMatchCount(ScoreImpactType.REWARD, times, message);
    }

    @Override
    public void penalizesByLessThan(@Nullable String message, int matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateLessThanMatchWeighTotal(matchWeightTotal);
        this.assertLessThanImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesByLessThan(@Nullable String message, long matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateLessThanMatchWeighTotal(matchWeightTotal);
        this.assertLessThanImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesByLessThan(@Nullable String message, @NonNull BigDecimal matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateLessThanMatchWeighTotal(matchWeightTotal);
        this.assertLessThanImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesLessThan(@Nullable String message, long times) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateLessThanMatchCount(times);
        this.assertLessThanMatchCount(ScoreImpactType.PENALTY, times, message);
    }

    @Override
    public void rewardsWithLessThan(@Nullable String message, int matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateLessThanMatchWeighTotal(matchWeightTotal);
        this.assertLessThanImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewardsWithLessThan(String message, long matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateLessThanMatchWeighTotal(matchWeightTotal);
        this.assertLessThanImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewardsWithLessThan(@Nullable String message, @NonNull BigDecimal matchWeightTotal) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateLessThanMatchWeighTotal(matchWeightTotal);
        this.assertLessThanImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    private static void validateLessThanMatchWeighTotal(Number matchWeightTotal) {
        if (matchWeightTotal.doubleValue() < 1.0) {
            throw new IllegalArgumentException("The matchWeightTotal (%s) must be greater than 0.".formatted(matchWeightTotal));
        }
    }

    @Override
    public void rewardsLessThan(String message, long times) {
        this.ensureInitialized();
        AbstractSingleConstraintAssertion.validateLessThanMatchCount(times);
        this.assertLessThanMatchCount(ScoreImpactType.REWARD, times, message);
    }

    private static void validateLessThanMatchCount(Number matchCount) {
        if (matchCount.doubleValue() < 1.0) {
            throw new IllegalArgumentException("The match count (%s) must be greater than 0.".formatted(matchCount));
        }
    }

    private void assertImpact(ScoreImpactType scoreImpactType, Number matchWeightTotal, String message) {
        Number negatedImpact;
        BiPredicate<Number, Number> equalityPredicate = NumberEqualityUtil.getEqualityPredicate(this.scoreDefinition, matchWeightTotal);
        Pair<Number, Number> deducedImpacts = this.deduceImpact();
        Number impact = (Number)deducedImpacts.key();
        ScoreImpactType actualScoreImpactType = this.constraint.getScoreImpactType();
        if (actualScoreImpactType == ScoreImpactType.MIXED ? (Objects.requireNonNull(scoreImpactType) == ScoreImpactType.REWARD ? equalityPredicate.test(matchWeightTotal, negatedImpact = (Number)deducedImpacts.value()) : scoreImpactType == ScoreImpactType.PENALTY && equalityPredicate.test(matchWeightTotal, impact)) : actualScoreImpactType == scoreImpactType && equalityPredicate.test(matchWeightTotal, impact)) {
            return;
        }
        String constraintId = this.constraint.getConstraintRef().constraintId();
        String assertionMessage = this.buildAssertionErrorMessage(scoreImpactType, matchWeightTotal, actualScoreImpactType, impact, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private void assertMoreThanImpact(ScoreImpactType scoreImpactType, Number matchWeightTotal, String message) {
        Number negatedImpact;
        Comparator<Number> comparator = NumberEqualityUtil.getComparison(matchWeightTotal);
        Pair<Number, Number> deducedImpacts = this.deduceImpact();
        Number impact = (Number)deducedImpacts.key();
        ScoreImpactType actualScoreImpactType = this.constraint.getScoreImpactType();
        if (actualScoreImpactType == ScoreImpactType.MIXED ? (Objects.requireNonNull(scoreImpactType) == ScoreImpactType.REWARD ? comparator.compare(matchWeightTotal, negatedImpact = (Number)deducedImpacts.value()) < 0 : scoreImpactType == ScoreImpactType.PENALTY && comparator.compare(matchWeightTotal, impact) < 0) : actualScoreImpactType == scoreImpactType && comparator.compare(matchWeightTotal, impact) < 0) {
            return;
        }
        String constraintId = this.constraint.getConstraintRef().constraintId();
        String assertionMessage = this.buildMoreThanAssertionErrorMessage(scoreImpactType, matchWeightTotal, actualScoreImpactType, impact, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private void assertLessThanImpact(ScoreImpactType scoreImpactType, Number matchWeightTotal, String message) {
        Number negatedImpact;
        Comparator<Number> comparator = NumberEqualityUtil.getComparison(matchWeightTotal);
        Pair<Number, Number> deducedImpacts = this.deduceImpact();
        Number impact = (Number)deducedImpacts.key();
        ScoreImpactType actualScoreImpactType = this.constraint.getScoreImpactType();
        if (actualScoreImpactType == ScoreImpactType.MIXED ? (Objects.requireNonNull(scoreImpactType) == ScoreImpactType.REWARD ? comparator.compare(matchWeightTotal, negatedImpact = (Number)deducedImpacts.value()) > 0 : scoreImpactType == ScoreImpactType.PENALTY && comparator.compare(matchWeightTotal, impact) > 0) : actualScoreImpactType == scoreImpactType && comparator.compare(matchWeightTotal, impact) > 0) {
            return;
        }
        String constraintId = this.constraint.getConstraintRef().constraintId();
        String assertionMessage = this.buildLessThanAssertionErrorMessage(scoreImpactType, matchWeightTotal, actualScoreImpactType, impact, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private void assertJustification(String message, boolean completeValidation, ConstraintJustification ... justifications) {
        boolean emptyJustifications;
        boolean bl = emptyJustifications = justifications == null || justifications.length == 0;
        if (emptyJustifications && this.justificationCollection.isEmpty()) {
            return;
        }
        if (emptyJustifications && !this.justificationCollection.isEmpty()) {
            String assertionMessage = AbstractSingleConstraintAssertion.buildAssertionErrorMessage("Justification", this.constraint.getConstraintRef().constraintId(), this.justificationCollection, Collections.emptyList(), Collections.emptyList(), this.justificationCollection, message);
            throw new AssertionError((Object)assertionMessage);
        }
        if (this.justificationCollection.isEmpty()) {
            String assertionMessage = AbstractSingleConstraintAssertion.buildAssertionErrorMessage("Justification", this.constraint.getConstraintRef().constraintId(), Collections.emptyList(), Arrays.asList(justifications), Arrays.asList(justifications), Collections.emptyList(), message);
            throw new AssertionError((Object)assertionMessage);
        }
        ArrayList<ConstraintJustification> expectedNotFound = new ArrayList<ConstraintJustification>(this.justificationCollection.size());
        for (ConstraintJustification justification2 : justifications) {
            if (!this.justificationCollection.stream().noneMatch(justification2::equals)) continue;
            expectedNotFound.add(justification2);
        }
        List<Object> unexpectedFound = Collections.emptyList();
        if (completeValidation) {
            unexpectedFound = this.justificationCollection.stream().filter(justification -> Stream.of(justifications).noneMatch(justification::equals)).toList();
        }
        if (expectedNotFound.isEmpty() && unexpectedFound.isEmpty()) {
            return;
        }
        String assertionMessage = AbstractSingleConstraintAssertion.buildAssertionErrorMessage("Justification", this.constraint.getConstraintRef().constraintId(), unexpectedFound, expectedNotFound, Arrays.asList(justifications), this.justificationCollection, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private void assertIndictments(String message, boolean completeValidation, Object ... indictments) {
        boolean emptyIndictments;
        boolean bl = emptyIndictments = indictments == null || indictments.length == 0;
        if (emptyIndictments && this.indictmentCollection.isEmpty()) {
            return;
        }
        List<Object> indictmentObjectList = this.indictmentCollection.stream().map(Indictment::getIndictedObject).toList();
        if (emptyIndictments && !indictmentObjectList.isEmpty()) {
            String assertionMessage = AbstractSingleConstraintAssertion.buildAssertionErrorMessage("Indictment", this.constraint.getConstraintRef().constraintId(), indictmentObjectList, Collections.emptyList(), Collections.emptyList(), indictmentObjectList, message);
            throw new AssertionError((Object)assertionMessage);
        }
        if (indictmentObjectList.isEmpty()) {
            String assertionMessage = AbstractSingleConstraintAssertion.buildAssertionErrorMessage("Indictment", this.constraint.getConstraintRef().constraintId(), Collections.emptyList(), Arrays.asList(indictments), Arrays.asList(indictments), Collections.emptyList(), message);
            throw new AssertionError((Object)assertionMessage);
        }
        ArrayList<Object> expectedNotFound = new ArrayList<Object>(indictmentObjectList.size());
        for (Object indictment2 : indictments) {
            if (!indictmentObjectList.stream().noneMatch(indictment2::equals)) continue;
            expectedNotFound.add(indictment2);
        }
        List<Object> unexpectedFound = Collections.emptyList();
        if (completeValidation) {
            unexpectedFound = indictmentObjectList.stream().filter(indictment -> Arrays.stream(indictments).noneMatch(indictment::equals)).toList();
        }
        if (expectedNotFound.isEmpty() && unexpectedFound.isEmpty()) {
            return;
        }
        String assertionMessage = AbstractSingleConstraintAssertion.buildAssertionErrorMessage("Indictment", this.constraint.getConstraintRef().constraintId(), unexpectedFound, expectedNotFound, Arrays.asList(indictments), indictmentObjectList, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private Pair<Number, Number> deduceImpact() {
        Score zeroScore = this.scoreDefinition.getZeroScore();
        Number zero = zeroScore.toLevelNumbers()[0];
        if (this.constraintMatchTotalCollection.isEmpty()) {
            return new Pair((Object)zero, (Object)zero);
        }
        Score totalMatchWeightedScore = this.constraintMatchTotalCollection.stream().map(matchScore -> this.scoreDefinition.divideBySanitizedDivisor(matchScore.getScore(), matchScore.getConstraintWeight())).reduce(zeroScore, Score::add);
        Number deducedImpact = this.retrieveImpact(totalMatchWeightedScore, zero);
        if (deducedImpact.equals(zero)) {
            return new Pair((Object)zero, (Object)zero);
        }
        Number negatedDeducedImpact = this.retrieveImpact(totalMatchWeightedScore.negate(), zero);
        return new Pair((Object)deducedImpact, (Object)negatedDeducedImpact);
    }

    private Number retrieveImpact(Score_ score, Number zero) {
        Object[] levelNumbers = score.toLevelNumbers();
        List<Number> impacts = Arrays.stream(levelNumbers).distinct().filter(matchWeight -> !Objects.equals(matchWeight, zero)).toList();
        return switch (impacts.size()) {
            case 0 -> zero;
            case 1 -> impacts.get(0);
            default -> throw new IllegalStateException("Impossible state: expecting at most one match weight (%d) in matchWeightedScore level numbers (%s).".formatted(impacts.size(), Arrays.toString(levelNumbers)));
        };
    }

    private void assertMatchCount(ScoreImpactType scoreImpactType, long expectedMatchCount, String message) {
        long actualMatchCount = this.determineMatchCount(scoreImpactType);
        if (actualMatchCount == expectedMatchCount) {
            return;
        }
        String constraintId = this.constraint.getConstraintRef().constraintId();
        String assertionMessage = this.buildAssertionErrorMessage(scoreImpactType, expectedMatchCount, actualMatchCount, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private void assertMoreThanMatchCount(ScoreImpactType scoreImpactType, long expectedMatchCount, String message) {
        long actualMatchCount = this.determineMatchCount(scoreImpactType);
        if (actualMatchCount > expectedMatchCount) {
            return;
        }
        String constraintId = this.constraint.getConstraintRef().constraintId();
        String assertionMessage = this.buildMoreThanAssertionErrorMessage(scoreImpactType, expectedMatchCount, actualMatchCount, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private void assertLessThanMatchCount(ScoreImpactType scoreImpactType, long expectedMatchCount, String message) {
        long actualMatchCount = this.determineMatchCount(scoreImpactType);
        if (actualMatchCount < expectedMatchCount) {
            return;
        }
        String constraintId = this.constraint.getConstraintRef().constraintId();
        String assertionMessage = this.buildLessThanAssertionErrorMessage(scoreImpactType, expectedMatchCount, actualMatchCount, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private void assertMatch(ScoreImpactType scoreImpactType, String message) {
        if (this.determineMatchCount(scoreImpactType) > 0L) {
            return;
        }
        String constraintId = this.constraint.getConstraintRef().constraintId();
        String assertionMessage = this.buildAssertionErrorMessage(scoreImpactType, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private long determineMatchCount(ScoreImpactType scoreImpactType) {
        if (this.constraintMatchTotalCollection.isEmpty()) {
            return 0L;
        }
        ScoreImpactType actualImpactType = this.constraint.getScoreImpactType();
        if (actualImpactType != scoreImpactType && actualImpactType != ScoreImpactType.MIXED) {
            return 0L;
        }
        Score zeroScore = this.scoreDefinition.getZeroScore();
        return this.constraintMatchTotalCollection.stream().mapToLong(constraintMatchTotal -> {
            if (actualImpactType == ScoreImpactType.MIXED) {
                boolean isImpactNegative;
                boolean isImpactPositive = constraintMatchTotal.getScore().compareTo((Object)zeroScore) > 0;
                boolean bl = isImpactNegative = constraintMatchTotal.getScore().compareTo((Object)zeroScore) < 0;
                if (isImpactPositive && scoreImpactType == ScoreImpactType.PENALTY) {
                    return constraintMatchTotal.getConstraintMatchSet().size();
                }
                if (isImpactNegative && scoreImpactType == ScoreImpactType.REWARD) {
                    return constraintMatchTotal.getConstraintMatchSet().size();
                }
                return 0L;
            }
            return constraintMatchTotal.getConstraintMatchSet().size();
        }).sum();
    }

    private String buildAssertionErrorMessage(ScoreImpactType expectedImpactType, Number expectedImpact, ScoreImpactType actualImpactType, Number actualImpact, String constraintId, String message) {
        String expectation = message != null ? message : "Broken expectation.";
        String preformattedMessage = "%s%n%18s: %s%n%18s: %s (%s)%n%18s: %s (%s)%n%n  %s";
        String expectedImpactLabel = "Expected " + AbstractSingleConstraintAssertion.getImpactTypeLabel(expectedImpactType);
        String actualImpactLabel = "Actual " + AbstractSingleConstraintAssertion.getImpactTypeLabel(actualImpactType);
        return String.format(preformattedMessage, expectation, "Constraint", constraintId, expectedImpactLabel, expectedImpact, expectedImpact.getClass(), actualImpactLabel, actualImpact, actualImpact.getClass(), DefaultScoreExplanation.explainScore(this.score, this.constraintMatchTotalCollection, this.indictmentCollection));
    }

    private String buildMoreThanAssertionErrorMessage(ScoreImpactType expectedImpactType, Number expectedImpact, ScoreImpactType actualImpactType, Number actualImpact, String constraintId, String message) {
        return this.buildMoreOrLessThanAssertionErrorMessage(expectedImpactType, "more than", expectedImpact, actualImpactType, actualImpact, constraintId, message);
    }

    private String buildLessThanAssertionErrorMessage(ScoreImpactType expectedImpactType, Number expectedImpact, ScoreImpactType actualImpactType, Number actualImpact, String constraintId, String message) {
        return this.buildMoreOrLessThanAssertionErrorMessage(expectedImpactType, "less than", expectedImpact, actualImpactType, actualImpact, constraintId, message);
    }

    private String buildMoreOrLessThanAssertionErrorMessage(ScoreImpactType expectedImpactType, String moreOrLessThan, Number expectedImpact, ScoreImpactType actualImpactType, Number actualImpact, String constraintId, String message) {
        String expectation = message != null ? message : "Broken expectation.";
        String preformattedMessage = "%s%n%28s: %s%n%28s: %s (%s)%n%28s: %s (%s)%n%n  %s";
        String expectedImpactLabel = "Expected " + AbstractSingleConstraintAssertion.getImpactTypeLabel(expectedImpactType) + " " + moreOrLessThan;
        String actualImpactLabel = "Actual " + AbstractSingleConstraintAssertion.getImpactTypeLabel(actualImpactType);
        return String.format(preformattedMessage, expectation, "Constraint", constraintId, expectedImpactLabel, expectedImpact, expectedImpact.getClass(), actualImpactLabel, actualImpact, actualImpact.getClass(), DefaultScoreExplanation.explainScore(this.score, this.constraintMatchTotalCollection, this.indictmentCollection));
    }

    private String buildAssertionErrorMessage(ScoreImpactType impactType, long expectedTimes, long actualTimes, String constraintId, String message) {
        String expectation = message != null ? message : "Broken expectation.";
        String preformattedMessage = "%s%n%18s: %s%n%18s: %s time(s)%n%18s: %s time(s)%n%n  %s";
        String expectedImpactLabel = "Expected " + AbstractSingleConstraintAssertion.getImpactTypeLabel(impactType);
        String actualImpactLabel = "Actual " + AbstractSingleConstraintAssertion.getImpactTypeLabel(impactType);
        return String.format(preformattedMessage, expectation, "Constraint", constraintId, expectedImpactLabel, expectedTimes, actualImpactLabel, actualTimes, DefaultScoreExplanation.explainScore(this.score, this.constraintMatchTotalCollection, this.indictmentCollection));
    }

    private String buildMoreThanAssertionErrorMessage(ScoreImpactType impactType, long expectedTimes, long actualTimes, String constraintId, String message) {
        return this.buildMoreOrLessThanAssertionErrorMessage(impactType, "more than", expectedTimes, actualTimes, constraintId, message);
    }

    private String buildLessThanAssertionErrorMessage(ScoreImpactType impactType, long expectedTimes, long actualTimes, String constraintId, String message) {
        return this.buildMoreOrLessThanAssertionErrorMessage(impactType, "less than", expectedTimes, actualTimes, constraintId, message);
    }

    private String buildMoreOrLessThanAssertionErrorMessage(ScoreImpactType impactType, String moreOrLessThan, long expectedTimes, long actualTimes, String constraintId, String message) {
        String expectation = message != null ? message : "Broken expectation.";
        String preformattedMessage = "%s%n%28s: %s%n%28s: %s time(s)%n%28s: %s time(s)%n%n  %s";
        String expectedImpactLabel = "Expected " + AbstractSingleConstraintAssertion.getImpactTypeLabel(impactType) + " " + moreOrLessThan;
        String actualImpactLabel = "Actual " + AbstractSingleConstraintAssertion.getImpactTypeLabel(impactType);
        return String.format(preformattedMessage, expectation, "Constraint", constraintId, expectedImpactLabel, expectedTimes, actualImpactLabel, actualTimes, DefaultScoreExplanation.explainScore(this.score, this.constraintMatchTotalCollection, this.indictmentCollection));
    }

    private String buildAssertionErrorMessage(ScoreImpactType impactType, String constraintId, String message) {
        String expectation = message != null ? message : "Broken expectation.";
        String preformattedMessage = "%s%n%18s: %s%n%18s but there was none.%n%n  %s";
        String expectedImpactLabel = "Expected " + AbstractSingleConstraintAssertion.getImpactTypeLabel(impactType);
        return String.format(preformattedMessage, expectation, "Constraint", constraintId, expectedImpactLabel, DefaultScoreExplanation.explainScore(this.score, this.constraintMatchTotalCollection, this.indictmentCollection));
    }

    private static String buildAssertionErrorMessage(String type, String constraintId, Collection<?> unexpectedFound, Collection<?> expectedNotFound, Collection<?> expectedCollection, Collection<?> actualCollection, String message) {
        String expectation = message != null ? message : "Broken expectation.";
        StringBuilder preformattedMessage = new StringBuilder("%s%n").append("%18s: %s%n");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(expectation);
        params.add(type);
        params.add(constraintId);
        preformattedMessage.append("%24s%n");
        params.add("Expected:");
        if (expectedCollection.isEmpty()) {
            preformattedMessage.append("%26s%s%n");
            params.add("");
            params.add("No " + type);
        } else {
            expectedCollection.forEach(actual -> {
                preformattedMessage.append("%26s%s%n");
                params.add("");
                params.add(actual);
            });
        }
        preformattedMessage.append("%24s%n");
        params.add("Actual:");
        if (actualCollection.isEmpty()) {
            preformattedMessage.append("%26s%s%n");
            params.add("");
            params.add("No " + type);
        } else {
            actualCollection.forEach(actual -> {
                preformattedMessage.append("%26s%s%n");
                params.add("");
                params.add(actual);
            });
        }
        if (!expectedNotFound.isEmpty()) {
            preformattedMessage.append("%24s%n");
            params.add("Expected but not found:");
            expectedNotFound.forEach(indictment -> {
                preformattedMessage.append("%26s%s%n");
                params.add("");
                params.add(indictment);
            });
        }
        if (!unexpectedFound.isEmpty()) {
            preformattedMessage.append("%24s%n");
            params.add("Unexpected but found:");
            unexpectedFound.forEach(indictment -> {
                preformattedMessage.append("%26s%s%n");
                params.add("");
                params.add(indictment);
            });
        }
        return String.format(preformattedMessage.toString(), params.toArray());
    }

    private static String getImpactTypeLabel(ScoreImpactType scoreImpactType) {
        if (scoreImpactType == ScoreImpactType.PENALTY) {
            return "penalty";
        }
        if (scoreImpactType == ScoreImpactType.REWARD) {
            return "reward";
        }
        return "impact";
    }
}

