/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.test.impl.score.stream;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.impl.score.DefaultScoreExplanation;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.test.api.score.stream.MultiConstraintAssertion;
import ai.timefold.solver.test.impl.score.stream.AbstractConstraintAssertion;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractMultiConstraintAssertion<Solution_, Score_ extends Score<Score_>>
extends AbstractConstraintAssertion<Solution_, Score_>
implements MultiConstraintAssertion {
    private final ConstraintProvider constraintProvider;
    private Score_ actualScore;
    private Collection<ConstraintMatchTotal<Score_>> constraintMatchTotalCollection;
    private Collection<Indictment<Score_>> indictmentCollection;

    AbstractMultiConstraintAssertion(ConstraintProvider constraintProvider, AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_, ?> scoreDirectorFactory) {
        super(scoreDirectorFactory);
        this.constraintProvider = Objects.requireNonNull(constraintProvider);
    }

    @Override
    final void update(Score_ score, Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap, Map<Object, Indictment<Score_>> indictmentMap) {
        this.actualScore = (Score)Objects.requireNonNull(score);
        this.constraintMatchTotalCollection = Objects.requireNonNull(constraintMatchTotalMap).values();
        this.indictmentCollection = Objects.requireNonNull(indictmentMap).values();
        this.toggleInitialized();
    }

    @Override
    public void scores(@NonNull Score<?> score, String message) {
        this.ensureInitialized();
        if (this.actualScore.equals(score)) {
            return;
        }
        Class<?> constraintProviderClass = this.constraintProvider.getClass();
        String expectation = message == null ? "Broken expectation." : message;
        throw new AssertionError((Object)"%s\n  Constraint provider: %s\n       Expected score: %s (%s)\n         Actual score: %s (%s)\n\n  %s".formatted(expectation, constraintProviderClass, score, score.getClass(), this.actualScore, this.actualScore.getClass(), DefaultScoreExplanation.explainScore(this.actualScore, this.constraintMatchTotalCollection, this.indictmentCollection)));
    }
}

