/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.test.impl.score.stream;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirector;
import ai.timefold.solver.core.impl.score.director.stream.BavetConstraintStreamScoreDirector;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraintStreamScoreDirectorFactory;
import java.util.Map;

public abstract class AbstractConstraintAssertion<Solution_, Score_ extends Score<Score_>> {
    private boolean initialized = false;
    private final AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_, ?> scoreDirectorFactory;

    protected AbstractConstraintAssertion(AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_, ?> scoreDirectorFactory) {
        this.scoreDirectorFactory = scoreDirectorFactory;
    }

    abstract Solution_ getSolution();

    abstract void update(Score_ var1, Map<String, ConstraintMatchTotal<Score_>> var2, Map<Object, Indictment<Score_>> var3);

    void ensureInitialized() {
        if (this.initialized) {
            return;
        }
        try (AbstractScoreDirector scoreDirector = this.scoreDirectorFactory.createScoreDirectorBuilder().withConstraintMatchPolicy(ConstraintMatchPolicy.ENABLED).buildDerived();){
            scoreDirector.setWorkingSolution(this.getSolution());
            if (scoreDirector instanceof BavetConstraintStreamScoreDirector) {
                BavetConstraintStreamScoreDirector bavetConstraintStreamScoreDirector = (BavetConstraintStreamScoreDirector)scoreDirector;
                bavetConstraintStreamScoreDirector.clearShadowVariablesListenerQueue();
            }
            this.update(scoreDirector.calculateScore(), scoreDirector.getConstraintMatchTotalMap(), scoreDirector.getIndictmentMap());
            this.initialized = true;
        }
    }

    void toggleInitialized() {
        this.initialized = true;
    }
}

