/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.spring.boot.autoconfigure;

import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.spring.boot.autoconfigure.util.LambdaUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.autoconfigure.domain.EntityScanner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class IncludeAbstractClassesEntityScanner
extends EntityScanner {
    private final ApplicationContext context;

    public IncludeAbstractClassesEntityScanner(ApplicationContext context) {
        super(context);
        this.context = context;
    }

    public <T> Class<? extends T> findFirstImplementingClass(Class<T> targetClass) {
        List<Class<T>> classes = this.findImplementingClassList(targetClass);
        if (!classes.isEmpty()) {
            return classes.get(0);
        }
        return null;
    }

    private Set<String> findPackages() {
        HashSet<String> packages = new HashSet<String>();
        packages.addAll(AutoConfigurationPackages.get((BeanFactory)this.context));
        EntityScanPackages entityScanPackages = EntityScanPackages.get((BeanFactory)this.context);
        packages.addAll(entityScanPackages.getPackageNames());
        return packages;
    }

    public <T> List<Class<? extends T>> findImplementingClassList(Class<T> targetClass) {
        if (!AutoConfigurationPackages.has((BeanFactory)this.context)) {
            return Collections.emptyList();
        }
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.setEnvironment(this.context.getEnvironment());
        scanner.setResourceLoader((ResourceLoader)this.context);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(targetClass));
        Set<String> packages = this.findPackages();
        return packages.stream().flatMap(basePackage -> scanner.findCandidateComponents(basePackage).stream()).distinct().sorted(Comparator.comparing(BeanDefinition::getBeanClassName)).map(candidate -> {
            try {
                return ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)this.context.getClassLoader()).asSubclass(targetClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("The %s class (%s) cannot be found.".formatted(targetClass.getSimpleName(), candidate.getBeanClassName()), e);
            }
        }).collect(Collectors.toList());
    }

    @SafeVarargs
    public final List<Class<?>> findClassesWithAnnotation(Class<? extends Annotation> ... annotations) {
        if (!AutoConfigurationPackages.has((BeanFactory)this.context)) {
            return Collections.emptyList();
        }
        Set<String> packages = this.findPackages();
        return packages.stream().flatMap(LambdaUtils.rethrowFunction(basePackage -> this.findAllClassesUsingClassLoader(this.context.getClassLoader(), (String)basePackage).stream())).filter(clazz -> this.hasAnyFieldOrMethodWithAnnotation((Class<?>)clazz, annotations)).toList();
    }

    private boolean hasAnyFieldOrMethodWithAnnotation(Class<?> clazz, Class<? extends Annotation>[] annotations) {
        List<Field> fieldList = List.of(clazz.getDeclaredFields());
        List<Method> methodList = List.of(clazz.getDeclaredMethods());
        return List.of(annotations).stream().anyMatch(a -> fieldList.stream().anyMatch(f -> f.getAnnotation(a) != null) || methodList.stream().anyMatch(m -> m.getDeclaredAnnotation(a) != null));
    }

    public boolean hasSolutionOrEntityClasses() {
        try {
            return !this.scan(new Class[]{PlanningSolution.class}).isEmpty() || !this.scan(new Class[]{PlanningEntity.class}).isEmpty();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Scanning for @%s and @%s annotations failed.".formatted(PlanningSolution.class.getSimpleName(), PlanningEntity.class.getSimpleName()), e);
        }
    }

    public Class<?> findFirstSolutionClass() {
        Set solutionClassSet;
        try {
            solutionClassSet = this.scan(new Class[]{PlanningSolution.class});
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Scanning for @%s annotations failed.".formatted(PlanningSolution.class.getSimpleName()), e);
        }
        if (solutionClassSet.isEmpty()) {
            return null;
        }
        return solutionClassSet.stream().filter(c -> !Modifier.isAbstract(c.getModifiers())).findFirst().orElse(null);
    }

    public List<Class<?>> findEntityClassList() {
        try {
            HashSet<Class> entityClassSet = new HashSet<Class>(this.scan(new Class[]{PlanningEntity.class}));
            ArrayList<Class> childEntityList = new ArrayList<Class>(entityClassSet);
            while (!childEntityList.isEmpty()) {
                Class entityClass = (Class)childEntityList.remove(0);
                List<Class> childEntityClassList = this.findImplementingClassList(entityClass).stream().filter(c -> !c.equals(entityClass)).toList();
                if (childEntityClassList.isEmpty()) continue;
                entityClassSet.addAll(childEntityClassList);
                childEntityList.addAll(childEntityClassList);
            }
            return new ArrayList(entityClassSet);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Scanning for @%s failed.".formatted(PlanningEntity.class.getSimpleName()), e);
        }
    }

    private Set<Class<?>> findAllClassesUsingClassLoader(ClassLoader classLoader, String packageName) throws IOException {
        try (InputStream stream = classLoader.getResourceAsStream(packageName.replaceAll("[.]", "/"));){
            Set<Class<?>> set;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                set = reader.lines().filter(line -> line.endsWith(".class")).map(className -> packageName + "." + className.substring(0, className.lastIndexOf(46))).map(className -> this.getClass(classLoader, (String)className)).collect(Collectors.toSet());
            }
            return set;
        }
    }

    private Class<?> getClass(ClassLoader classLoader, String className) {
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected ClassPathScanningCandidateComponentProvider createClassPathScanningCandidateComponentProvider(ApplicationContext context) {
        return new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                AnnotationMetadata metadata = beanDefinition.getMetadata();
                return metadata.isIndependent();
            }
        };
    }
}

