/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.spring.boot.autoconfigure.config;

import ai.timefold.solver.spring.boot.autoconfigure.config.BenchmarkProperties;
import ai.timefold.solver.spring.boot.autoconfigure.config.SolverManagerProperties;
import ai.timefold.solver.spring.boot.autoconfigure.config.SolverProperties;
import ai.timefold.solver.spring.boot.autoconfigure.config.SolverProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="timefold", ignoreUnknownFields=false)
public class TimefoldProperties {
    public static final String DEFAULT_SOLVER_CONFIG_URL = "solverConfig.xml";
    public static final String DEFAULT_SOLVER_BENCHMARK_CONFIG_URL = "solverBenchmarkConfig.xml";
    public static final String DEFAULT_SOLVER_NAME = "default";
    @NestedConfigurationProperty
    private SolverManagerProperties solverManager;
    private String solverConfigXml;
    @NestedConfigurationProperty
    private Map<String, SolverProperties> solver;
    @NestedConfigurationProperty
    private BenchmarkProperties benchmark;

    public SolverManagerProperties getSolverManager() {
        return this.solverManager;
    }

    public void setSolverManager(SolverManagerProperties solverManager) {
        this.solverManager = solverManager;
    }

    public String getSolverConfigXml() {
        return this.solverConfigXml;
    }

    public void setSolverConfigXml(String solverConfigXml) {
        this.solverConfigXml = solverConfigXml;
    }

    public Map<String, SolverProperties> getSolver() {
        return this.solver;
    }

    public void setSolver(Map<String, Object> solver) {
        this.solver = new HashMap<String, SolverProperties>();
        if (SolverProperty.getValidPropertyNames().containsAll(solver.keySet())) {
            SolverProperties solverProperties = new SolverProperties();
            solverProperties.loadProperties(solver);
            this.solver.put(DEFAULT_SOLVER_NAME, solverProperties);
        } else {
            TreeSet invalidKeySet = solver.entrySet().stream().filter(e -> e.getValue() != null && !(e.getValue() instanceof Map)).map(Map.Entry::getKey).collect(Collectors.toCollection(TreeSet::new));
            if (!invalidKeySet.isEmpty()) {
                throw new IllegalStateException("Cannot use global solver properties with named solvers.\nExpected all values to be maps, but values for key(s) %s are not map(s).\nMaybe try changing the property name to kebab-case.\nHere is the list of valid global solver properties: %s".formatted(invalidKeySet, String.join((CharSequence)", ", SolverProperty.getValidPropertyNames())));
            }
            solver.forEach((key, value) -> {
                SolverProperties solverProperties = new SolverProperties();
                if (value != null) {
                    solverProperties.loadProperties((Map)value);
                }
                this.solver.put((String)key, solverProperties);
            });
        }
    }

    public BenchmarkProperties getBenchmark() {
        return this.benchmark;
    }

    public void setBenchmark(BenchmarkProperties benchmark) {
        this.benchmark = benchmark;
    }

    public Optional<SolverProperties> getSolverConfig(String solverName) {
        return Optional.ofNullable(this.solver).map(s -> (SolverProperties)s.get(solverName));
    }
}

